import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:generp/Notifiers/crmProvider/crmDashboardProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/crm/pendingTasksDetails.dart';
import 'package:provider/provider.dart';

import 'LeadDetailsByMode.dart';

class Generatedquoteslist extends StatefulWidget {
  const Generatedquoteslist({super.key});

  @override
  State<Generatedquoteslist> createState() => _GeneratedquoteslistState();
}

class _GeneratedquoteslistState extends State<Generatedquoteslist> {
  FocusNode focusNode = FocusNode();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((event) {
      setState(() => _source = event);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Crmdashboardprovider>(context, listen: false);
      prov.crmDashboardQuotationsAPIFunction(context);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  getDecorationColor(value) {
    switch (value) {
      case "Hot":
        return AppColors.processed_bg_color;
      case "Warm":
        return AppColors.rejected_bg_color;
      case "Cold":
        return AppColors.approved_bg_color;
      case "All":
        return AppColors.requested_bg_color;
    }
  }

  getTextColor(value) {
    switch (value) {
      case "Hot":
        return AppColors.processed_text_color;
      case "Warm":
        return AppColors.rejected_text_color;
      case "Cold":
        return AppColors.approved_text_color;
      case "All":
        return AppColors.requested_text_color;
    }
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Crmdashboardprovider>(
      builder: (context, provider, child) {
        var quotess = provider.dashboardQuotations;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: AppBar(
            automaticallyImplyLeading: false,
            // elevation: 2.0,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () => Navigator.pop(context, true),
                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  InkResponse(
                    onTap: () => Navigator.pop(context, true),
                    child: Text(
                      "Quotations Generated",
                      style: TextStyle(
                        fontSize: 16,
                        height: 1.1,
                        fontFamily: "JakartaSemiBold",
                        color: AppColors.semi_black,
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
          body:
              (quotess.isNotEmpty)
                  ? SingleChildScrollView(
                    physics: AlwaysScrollableScrollPhysics(),
                    child: Column(
                      children: [
                        SizedBox(
                          width: double.infinity,
                          child: ListView.builder(
                            physics: NeverScrollableScrollPhysics(),
                            shrinkWrap: true,
                            padding: EdgeInsets.symmetric(
                              vertical: 5,
                              horizontal: 10,
                            ),
                            itemCount: quotess.length,
                            itemBuilder: (context, index) {
                              return InkResponse(
                                onTap: () async {
                                  Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => LeadDetailsByMode(
                                            pageTitleName: "Lead Details",
                                            mode: "",
                                            leadId: quotess[index].leadid,
                                          ),
                                    ),
                                  );
                                },
                                child: Container(
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(15),
                                  ),
                                  margin: EdgeInsets.symmetric(vertical: 3),
                                  padding: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 10,
                                  ),
                                  child: Row(
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/finance/fin_payments_ic.svg",
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 4,
                                        child: Text(
                                          "${quotess[index].aname}",
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            decoration:
                                                TextDecoration.underline,
                                            height: 1.5,
                                            decorationStyle:
                                                TextDecorationStyle.dotted,
                                            decorationColor: Color(0xFF676767),
                                            color: AppColors.semi_black,
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                      SizedBox(width: 10),
                                      Expanded(
                                        flex: 2,
                                        child: Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 5,
                                          ),
                                          decoration: BoxDecoration(
                                            borderRadius: BorderRadius.circular(
                                              8,
                                            ),
                                            color: getDecorationColor(
                                              quotess[index].lstatus,
                                            ),
                                          ),
                                          child: Text(
                                            "${quotess[index].lstatus}",
                                            textAlign: TextAlign.center,
                                            maxLines: 1,
                                            style: TextStyle(
                                              color: getTextColor(
                                                quotess[index].lstatus,
                                              ),
                                              fontFamily: "JakartaRegular",
                                              fontSize: 14,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              );
                            },
                          ),
                        ),

                        SizedBox(height: 150),
                      ],
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }
}
