import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/commonProvider/accountDetailsProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/commom/editCommonAccount.dart';
import 'package:generp/screens/commom/transactionDetails.dart';
import 'package:generp/screens/finance/submitPaymentRequestionListsByMode.dart';
import 'package:provider/provider.dart';

import '../../Models/commonModels/commonAccountdetailsResponse.dart';
import 'addCommonPayment.dart';

class Accountslistdetails extends StatefulWidget {
  final accountID;

  const Accountslistdetails({super.key, required this.accountID});

  @override
  State<Accountslistdetails> createState() => _AccountslistdetailsState();
}

class _AccountslistdetailsState extends State<Accountslistdetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Accountdetailsprovider>(context, listen: false);
      prov.accountdetailsAPIFunction(context, widget.accountID);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Accountdetailsprovider>(
      builder: (context, provider, child) {
        final groupedData = provider.groupByDate(provider.ledgerList);
        // Calculate total credit, debit, and balance
        double totalCredit = 0;
        double totalDebit = 0;
        double overallBalance = 0;

        for (var item in provider.ledgerList) {
          double credit = double.tryParse(item.creditAmount.toString()) ?? 0;
          double debit = double.tryParse(item.debitAmount.toString()) ?? 0;
          totalCredit += credit;
          totalDebit += debit;
        }
        overallBalance = totalDebit - totalCredit;

        final headings1 = [
          "Bank Name",
          "Bank Branch",
          "Bank IFSC Code",
          "Account Holder",
          "Account Number",
          "Bank UPI ID",
        ];

        final headings2 = ["Address", "State", "District", "Sub Locality"];
        final headings3 = ["Created Date"];

        final subHeadings1 = [
          provider.accountDetails.bankName ?? "-",
          provider.accountDetails.bankBranchName ?? "-",
          provider.accountDetails.bankIfscCode ?? "-",
          provider.accountDetails.bankAccountHolderName ?? "-",
          provider.accountDetails.bankAccountNumber ?? "-",
          provider.accountDetails.bankUpiId ?? "-",
        ];

        final subHeadings2 = [
          provider.accountDetails.address ?? "-",
          provider.accountDetails.state ?? "-",
          provider.accountDetails.district ?? "-",
          provider.accountDetails.subLocality ?? "-",
        ];
        final subHeadings3 = [provider.accountDetails.createdDatetime ?? "-"];

        return Scaffold(
          appBar: appbar2New(
            context,
            "Account Details",
            provider.resetValues,
            SizedBox.shrink(),
            0xFFFFFFFF,
          ),
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          body: Builder(builder: (context){
            if (provider.isLoading) {
              return const Center(
                child: CircularProgressIndicator(color: Colors.blue),
              );
            }
            return SizedBox(
              child: SingleChildScrollView(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Card(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.only(
                          bottomLeft: Radius.circular(30),
                          bottomRight: Radius.circular(30),
                        ),
                      ),
                      elevation: 2,

                      child: Column(
                        children: [
                          Container(
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.vertical(
                                bottom: Radius.circular(30),
                              ),
                            ),
                            // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                            padding: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 10,
                            ),
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: SizedBox(
                                        height: 50,
                                        width: 35,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/lead_details_ic.svg",
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 5,
                                      child: SizedBox(
                                        child: Column(
                                          crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              provider.accountDetails.name ?? "-",
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                            Text(
                                              provider.accountDetails.type ?? "-",
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.grey_semi,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 2),
                                    Expanded(
                                      flex: 1,
                                      child: InkResponse(
                                        onTap: () {
                                          Navigator.push(
                                              context,
                                              MaterialPageRoute(builder: (context) => EditCommonAccountScreen(accountID: widget.accountID,))
                                          ).then((_) async {
                                            var prov = Provider.of<Accountdetailsprovider>(context, listen: false);
                                            await prov.accountdetailsAPIFunction(context, widget.accountID);
                                          });
                                        },
                                        child: SizedBox(
                                          height: 25,
                                          width: 25,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm_contact_edit.svg",
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                Visibility(
                                  visible:
                                  provider.showMoreDetails ? true : false,
                                  child: Column(
                                    children: [
                                      Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 4,
                                        ),
                                        child: Row(
                                          children: [
                                            Expanded(
                                              flex: 3,
                                              child: Text(
                                                "Bank Details",
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  fontFamily: "JakartaSemiBold",
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              flex: 6,
                                              child: DottedLine(
                                                dashGapLength: 4,
                                                dashGapColor: Colors.white,
                                                dashColor: AppColors.grey_semi,
                                                dashLength: 2,
                                                lineThickness: 0.5,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                      ...List.generate(subHeadings1.length, (j) {
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 7,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: Text(
                                                  headings1[j],
                                                  style: TextStyle(
                                                    fontFamily: "JakartaRegular",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                child: Text(
                                                  subHeadings1[j] == ""
                                                      ? "-"
                                                      : subHeadings1[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: Color(0xFF818181),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                      Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 4,
                                        ),
                                        child: Row(
                                          children: [
                                            Expanded(
                                              flex: 3,
                                              child: Text(
                                                "Address Details",
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  fontFamily: "JakartaSemiBold",
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              flex: 6,
                                              child: DottedLine(
                                                dashGapLength: 4,
                                                dashGapColor: Colors.white,
                                                dashColor: AppColors.grey_semi,
                                                dashLength: 2,
                                                lineThickness: 0.5,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                      ...List.generate(subHeadings2.length, (j) {
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 7,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: Text(
                                                  headings2[j],
                                                  style: TextStyle(
                                                    fontFamily: "JakartaRegular",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                child: Text(
                                                  subHeadings2[j] == ""
                                                      ? "-"
                                                      : subHeadings2[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: Color(0xFF818181),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                      Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 4,
                                        ),
                                        child: Row(
                                          children: [
                                            Expanded(
                                              flex: 3,
                                              child: Text(
                                                "More Details",
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  fontFamily: "JakartaSemiBold",
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              flex: 6,
                                              child: DottedLine(
                                                dashGapLength: 4,
                                                dashGapColor: Colors.white,
                                                dashColor: AppColors.grey_semi,
                                                dashLength: 2,
                                                lineThickness: 0.5,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                      ...List.generate(subHeadings3.length, (j) {
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 7,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: Text(
                                                  headings3[j],
                                                  style: TextStyle(
                                                    fontFamily: "JakartaRegular",
                                                    fontSize: 14,
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                child: Text(
                                                  subHeadings3[j] == ""
                                                      ? "-"
                                                      : subHeadings3[j],
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: Color(0xFF818181),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                    ],
                                  ),
                                ),

                                InkResponse(
                                  onTap: () async {
                                    provider.showMoreDetails =
                                    !provider.showMoreDetails;
                                  },
                                  child: Container(
                                    padding: EdgeInsets.symmetric(vertical: 5),
                                    child: Row(
                                      crossAxisAlignment:
                                      CrossAxisAlignment.center,
                                      mainAxisAlignment: MainAxisAlignment.center,
                                      children: [
                                        Text(
                                          provider.showMoreDetails
                                              ? "Hide Details"
                                              : "View Details",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                          ),
                                        ),
                                        Transform.flip(
                                          flipY:
                                          provider.showMoreDetails
                                              ? true
                                              : false,
                                          child: SvgPicture.asset(
                                            "assets/svg/arrow_dropdown.svg",
                                            height: 25,
                                            width: 20,
                                            color: AppColors.app_blue,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),

                    Container(
                      margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(16),
                      ),
                      child: Column(
                        children: [
                          Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 15,
                            ),
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 15,
                            ),
                            decoration: BoxDecoration(
                              color: Color(0xFFEDF7FF),
                              borderRadius: BorderRadius.circular(16),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Text(
                                      provider.balanceDetails.balance ?? "-",
                                      style: TextStyle(
                                        fontSize: 20,
                                        fontFamily: "JakartaMedium",
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                                Container(
                                  padding: EdgeInsets.only(top: 5),
                                  child: Text(
                                    "Total Balance",
                                    maxLines: 1,
                                    style: TextStyle(
                                      fontSize: 14,
                                      fontFamily: "JakartaRegular",
                                      color: AppColors.semi_black,
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),

                          Row(
                            children: [
                              ...List.generate(2, (jj) {
                                final texts = ["Credited", "Debited"];
                                final heads = [
                                  provider.balanceDetails.totalCredit ?? "-",
                                  provider.balanceDetails.totalDebit ?? "-",
                                ];
                                final svgs = [
                                  "assets/svg/finance/cred_debit_ic.svg",
                                  "assets/svg/finance/deb_credit_ic.svg",
                                ];
                                return Expanded(
                                  child: Container(
                                    padding: EdgeInsets.symmetric(
                                      horizontal: 10,
                                      vertical: 15,
                                    ),
                                    margin: EdgeInsets.symmetric(
                                      horizontal: 10,
                                      vertical: 15,
                                    ),
                                    decoration: BoxDecoration(
                                      color:
                                      texts[jj] == "Credited"
                                          ? Color(0xFFFFEFEF)
                                          : Color(0xFFE7FFE5),
                                      borderRadius: BorderRadius.circular(16),
                                    ),
                                    child: Column(
                                      crossAxisAlignment:
                                      CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          heads[jj] ?? "-",
                                          maxLines: 2,
                                          style: TextStyle(
                                            fontSize: 20,
                                            color:
                                            texts[jj] == "Credited"
                                                ? Color(0xFFEF3739)
                                                : Color(0xFF0D9C00),
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                        Container(
                                          padding: EdgeInsets.only(top: 5),
                                          child: Row(
                                            children: [
                                              Expanded(
                                                flex: 3,
                                                child: Text(
                                                  texts[jj] ?? "-",
                                                  maxLines: 1,
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    fontFamily: "JakartaRegular",
                                                    color: AppColors.semi_black,
                                                  ),
                                                ),
                                              ),
                                              Expanded(
                                                flex: 1,
                                                child: SvgPicture.asset(svgs[jj]),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                );
                              }),
                            ],
                          ),
                        ],
                      ),
                    ),

                    ListView.builder(
                      physics: NeverScrollableScrollPhysics(),
                      shrinkWrap: true,
                      itemCount: provider.ledgerList.length,
                      itemBuilder: (context, index) {
                        double runningBalance = 0;
                        int currentIndex = provider.ledgerList.indexOf(
                          provider.ledgerList[index],
                        );
                        for (var i = 0; i <= currentIndex; i++) {
                          var ledgerItem = provider.ledgerList[i];
                          double credit =
                              double.tryParse(
                                ledgerItem.creditAmount.toString(),
                              ) ??
                                  0;
                          double debit =
                              double.tryParse(
                                ledgerItem.debitAmount.toString(),
                              ) ??
                                  0;
                          runningBalance += (debit - credit);
                        }
                        return InkResponse(
                          onTap: () async {
                            Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) => Transactiondetails(
                                  paymentID: provider.ledgerList[index].refId,
                                  type: provider.ledgerList[index].type,
                                  description:
                                  provider.ledgerList[index].description,
                                ),
                              ),
                            );
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 10,
                            ),
                            margin: EdgeInsets.symmetric(vertical: 5),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                  flex: 1,
                                  child: SizedBox(
                                    child:
                                    provider.ledgerList[index].type ==
                                        "Credit"
                                        ? SvgPicture.asset(
                                      "assets/svg/finance/debited_filled_ic.svg",
                                      height: 45,
                                      width: 45,
                                      fit: BoxFit.contain,
                                    )
                                        : SvgPicture.asset(
                                      "assets/svg/finance/credited_filled_ic.svg",
                                      height: 45,
                                      width: 45,
                                      fit: BoxFit.contain,
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 8,
                                  child: SizedBox(
                                    child: Column(
                                      children: [
                                        Row(
                                          crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              flex: 5,
                                              child: SizedBox(
                                                child: Text(
                                                  provider
                                                      .ledgerList[index]
                                                      .description ??
                                                      "-",
                                                  maxLines: 2,
                                                  overflow: TextOverflow.ellipsis,
                                                  style: TextStyle(
                                                    fontFamily: "JakartaRegular",
                                                    fontSize: 14,
                                                  ),
                                                ),
                                              ),
                                            ),
                                            Spacer(),
                                            Expanded(
                                              flex: 3,
                                              child: SizedBox(
                                                child: RichText(
                                                  maxLines: 1,
                                                  textAlign: TextAlign.right,
                                                  overflow: TextOverflow.ellipsis,
                                                  text: TextSpan(
                                                    children: [
                                                      TextSpan(
                                                        text:
                                                        provider
                                                            .ledgerList[index]
                                                            .type ==
                                                            "Credit"
                                                            ? "-"
                                                            : "+",
                                                        style: TextStyle(
                                                          color:
                                                          provider
                                                              .ledgerList[index]
                                                              .type ==
                                                              "Credit"
                                                              ? Color(
                                                            0xFFEF3739,
                                                          )
                                                              : Color(
                                                            0xFF0D9C00,
                                                          ),
                                                          fontSize: 14,
                                                          fontFamily:
                                                          "JakartaRegular",
                                                        ),
                                                      ),
                                                      TextSpan(
                                                        text:
                                                        "₹${provider.ledgerList[index].type == "Credit" ? "${provider.ledgerList[index].creditAmount}" : "${provider.ledgerList[index].debitAmount}"}",
                                                        style: TextStyle(
                                                          color:
                                                          provider
                                                              .ledgerList[index]
                                                              .type ==
                                                              "Credit"
                                                              ? Color(
                                                            0xFFEF3739,
                                                          )
                                                              : Color(
                                                            0xFF0D9C00,
                                                          ),
                                                          fontSize: 14,
                                                          fontFamily:
                                                          "JakartaRegular",
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                        SizedBox(height: 7),
                                        Row(
                                          children: [
                                            Expanded(
                                              flex: 5,
                                              child: SizedBox(
                                                child: Text(
                                                  provider
                                                      .ledgerList[index]
                                                      .date ??
                                                      "-",
                                                  maxLines: 2,
                                                  overflow: TextOverflow.ellipsis,
                                                  style: TextStyle(
                                                    fontFamily: "JakartaRegular",
                                                    color: AppColors.grey_semi,
                                                    fontSize: 12,
                                                  ),
                                                ),
                                              ),
                                            ),
                                            Spacer(),
                                            // Expanded(
                                            //   flex: 3,
                                            //   child: SizedBox(
                                            //     child: RichText(
                                            //       maxLines: 1,
                                            //       textAlign: TextAlign.right,
                                            //       overflow: TextOverflow.ellipsis,
                                            //       text: TextSpan(
                                            //         children: [
                                            //           TextSpan(
                                            //             text: "Bal: ",
                                            //             style: TextStyle(
                                            //               color:
                                            //               AppColors
                                            //                   .semi_black,
                                            //               fontSize: 12,
                                            //               fontFamily:
                                            //               "JakartaRegular",
                                            //             ),
                                            //           ),
                                            //           TextSpan(
                                            //             text: "₹$runningBalance",
                                            //             style: TextStyle(
                                            //               color:
                                            //               AppColors.grey_semi,
                                            //               fontSize: 12,
                                            //               fontFamily:
                                            //               "JakartaMedium",
                                            //             ),
                                            //           ),
                                            //         ],
                                            //       ),
                                            //     ),
                                            //   ),
                                            // ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                    if ([
                      "Vendor",
                      "Customer",
                    ].contains(provider.accountDetails.type)) ...[
                      InkWell(
                        onTap: () {
                          Navigator.push(
                            context,
                            MaterialPageRoute(
                              builder:
                                  (context) => Submitpaymentrequestionlistsbymode(
                                mode: "other",
                                pageTitleName: "Add Payment Request (Other)",
                                accountId: provider.accountDetails.id!,
                              ),
                            ),
                          );
                        },
                        child: Container(
                          alignment: Alignment.center,
                          height: 45,
                          margin: EdgeInsets.only(
                            left: 5.0,
                            right: 5.0,
                            top: 5.0,
                            bottom: 5.0,
                          ),
                          decoration: BoxDecoration(
                            color: AppColors.app_blue, //1487C9
                            borderRadius: BorderRadius.circular(15.0),
                          ),
                          child: Center(
                            child: Text(
                              "Add Payment Request (Other)",
                              textAlign: TextAlign.center,
                              style: TextStyle(
                                color: Colors.white,
                                fontFamily: "JakartaMedium",
                                fontSize: 15,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ],
                ),
              ),
            );
          }
          )
        );
      },
    );
  }

  Future<bool> _onBackPressed(BuildContext context) async {
    Navigator.pop(context, true);
    return true;
  }
}

///import 'dart:io';
//
// import 'package:connectivity_plus/connectivity_plus.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_svg/svg.dart';
// import 'package:generp/Notifiers/commonProvider/accountDetailsProvider.dart';
// import 'package:generp/Utils/app_colors.dart';
// import 'package:generp/Utils/commonServices.dart';
// import 'package:generp/Utils/commonWidgets.dart';
// import 'package:generp/screens/commom/transactionDetails.dart';
// import 'package:generp/screens/finance/submitPaymentRequestionListsByMode.dart';
// import 'package:provider/provider.dart';
//
// import '../../Models/commonModels/commonAccountdetailsResponse.dart';
//
// class Accountslistdetails extends StatefulWidget {
//   final accountID;
//
//   const Accountslistdetails({super.key, required this.accountID});
//
//   @override
//   State<Accountslistdetails> createState() => _AccountslistdetailsState();
// }
//
// class _AccountslistdetailsState extends State<Accountslistdetails> {
//   Map _source = {ConnectivityResult.mobile: true};
//   final MyConnectivity _connectivity = MyConnectivity.instance;
//
//   @override
//   void initState() {
//     // TODO: implement initState
//     super.initState();
//     _connectivity.initialise();
//     _connectivity.myStream.listen((source) {
//       setState(() => _source = source);
//     });
//     WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
//       var prov = Provider.of<Accountdetailsprovider>(context, listen: false);
//       prov.accountdetailsAPIFunction(context, widget.accountID);
//     });
//   }
//
//   @override
//   void dispose() {
//     // TODO: implement dispose
//     super.dispose();
//     _connectivity.disposeStream();
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     switch (_source.keys.toList()[0]) {
//       case ConnectivityResult.mobile:
//         connection = 'Online';
//         break;
//       case ConnectivityResult.wifi:
//         connection = 'Online';
//         break;
//       case ConnectivityResult.none:
//       default:
//         connection = 'Offline';
//     }
//     return (connection == "Online")
//         ? Platform.isAndroid
//             ? WillPopScope(
//               onWillPop: () => onBackPressed(context),
//               child: SafeArea(
//                 top: false,
//                 bottom: true,
//                 child: _scaffold(context),
//               ),
//             )
//             : _scaffold(context)
//         : NoNetwork(context);
//   }
//
//   Widget _scaffold(BuildContext context) {
//     return Consumer<Accountdetailsprovider>(
//       builder: (context, provider, child) {
//         final groupedData = provider.groupByDate(provider.ledgerList);
//         // Calculate total credit, debit, and balance
//         double totalCredit = 0;
//         double totalDebit = 0;
//         double overallBalance = 0;
//
//         for (var item in provider.ledgerList) {
//           double credit = double.tryParse(item.creditAmount.toString()) ?? 0;
//           double debit = double.tryParse(item.debitAmount.toString()) ?? 0;
//           totalCredit += credit;
//           totalDebit += debit;
//         }
//         overallBalance = totalDebit - totalCredit;
//
//         return Scaffold(
//           appBar: appbar2New(
//             context,
//             "Account Details",
//             provider.resetValues,
//             SizedBox.shrink(),
//             0xFFFFFFFF
//           ),
//           resizeToAvoidBottomInset: true,
//           backgroundColor: AppColors.scaffold_bg_color,
//           body: SizedBox(
//             child: SingleChildScrollView(
//               child: Column(
//                 crossAxisAlignment: CrossAxisAlignment.start,
//                 children: [
//
//                   Container(
//                     decoration: BoxDecoration(
//                       color: Colors.white,
//                       borderRadius: BorderRadius.circular(16),
//                     ),
//                     child: Column(
//                       children: [
//                         Container(
//                           padding: EdgeInsets.symmetric(
//                             horizontal: 10,
//                             vertical: 15,
//                           ),
//                           margin: EdgeInsets.symmetric(
//                             horizontal: 10,
//                             vertical: 15,
//                           ),
//                           decoration: BoxDecoration(
//                             color: Color(0xFFEDF7FF),
//                             borderRadius: BorderRadius.circular(16),
//                           ),
//                           child: Row(
//                             mainAxisAlignment: MainAxisAlignment.center,
//                             children: [
//                               Text(
//                                 overallBalance.toString() ?? "-",
//                                 style: TextStyle(fontSize: 20,
//                                     fontFamily: "JakartaMedium",
//                                     color: AppColors.app_blue
//                                 ),
//                               ),
//                             ],
//                           ),
//                         ),
//                         Row(
//                           children: [
//                             Expanded(
//                               child: Container(
//                                 padding: EdgeInsets.symmetric(
//                                   horizontal: 10,
//                                   vertical: 15,
//                                 ),
//                                 margin: EdgeInsets.symmetric(
//                                   horizontal: 10,
//                                   vertical: 15,
//                                 ),
//                                 decoration: BoxDecoration(
//                                   color: Color(0xFFFFEFEF),
//                                   borderRadius: BorderRadius.circular(16),
//                                 ),
//                                 child: Column(
//                                   crossAxisAlignment: CrossAxisAlignment.start,
//                                   children: [
//                                     RichText(
//                                       text: TextSpan(
//                                         children: [
//                                           TextSpan(
//                                             text: "${totalCredit}",
//                                             style: TextStyle(
//                                               color: Color(0xFFED3424),
//                                               fontFamily: "JakartaRegular",
//                                               fontSize: 25,
//                                             ),
//                                           ),
//                                         ],
//                                       ),
//                                     ),
//                                     Text(
//                                       "credit",
//                                       style: TextStyle(color: Color(0xFF818181)),
//                                     ),
//                                   ],
//                                 ),
//                               ),
//                             ),
//                             Expanded(
//                               child: Container(
//                                 padding: EdgeInsets.symmetric(
//                                   horizontal: 10,
//                                   vertical: 15,
//                                 ),
//                                 margin: EdgeInsets.symmetric(
//                                   horizontal: 10,
//                                   vertical: 15,
//                                 ),
//                                 decoration: BoxDecoration(
//                                   color: Color(0xFFFFEFEF),
//                                   borderRadius: BorderRadius.circular(16),
//                                 ),
//                                 child: Column(
//                                   crossAxisAlignment: CrossAxisAlignment.start,
//                                   children: [
//                                     RichText(
//                                       text: TextSpan(
//                                         children: [
//                                           TextSpan(
//                                             text: "${totalDebit}",
//                                             style: TextStyle(
//                                               color: Color(0xFFED3424),
//                                               fontFamily: "JakartaRegular",
//                                               fontSize: 25,
//                                             ),
//                                           ),
//                                         ],
//                                       ),
//                                     ),
//                                     Text(
//                                       "debit",
//                                       style: TextStyle(color: Color(0xFF818181)),
//                                     ),
//                                   ],
//                                 ),
//                               ),
//                             ),
//                           ],
//                         ),
//                       ],
//                     ),
//                   ),
//                   // Text(
//                   //   "Account Details",
//                   //   style: TextStyle(
//                   //     fontSize: 16,
//                   //     color: AppColors.grey_thick,
//                   //     fontFamily: "JakartaMedium",
//                   //   ),
//                   // ),
//                   Container(
//                     padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
//                     margin: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
//                     decoration: BoxDecoration(
//                       color: Colors.white,
//                       borderRadius: BorderRadius.circular(16),
//                     ),
//                     child: Column(
//                       children: [
//                         ...List.generate(12, (j) {
//                           final headings = [
//                             "Name",
//                             "Address",
//                             "Date",
//                             "Bank Name",
//                             "Bank Branch",
//                             "Bank IFSC Code",
//                             "Account Holder",
//                             "Account Number",
//                             "Bank UPI ID",
//                             "State",
//                             "District",
//                             "Sub Locality",
//                           ];
//
//                           final subHeadings = [
//                             provider.accountDetails.name ?? "-",
//                             provider.accountDetails.address ?? "-",
//                             provider.accountDetails.createdDatetime ?? "-",
//                             provider.accountDetails.bankName ?? "-",
//                             provider.accountDetails.bankBranchName ?? "-",
//                             provider.accountDetails.bankIfscCode ?? "-",
//                             provider.accountDetails.bankAccountHolderName ??
//                                 "-",
//                             provider.accountDetails.bankAccountNumber ?? "-",
//                             provider.accountDetails.bankUpiId ?? "-",
//                             provider.accountDetails.state ?? "-",
//                             provider.accountDetails.district ?? "-",
//                             provider.accountDetails.subLocality ?? "-",
//                           ];
//                           return Container(
//                             padding: EdgeInsets.symmetric(vertical: 5),
//                             child: Row(
//                               crossAxisAlignment: CrossAxisAlignment.start,
//                               children: [
//                                 Expanded(
//                                   child: Text(
//                                     headings[j],
//                                     style: TextStyle(
//                                       fontFamily: "JakartaMedium",
//                                       fontSize: 14,
//                                       color: AppColors.semi_black,
//                                     ),
//                                   ),
//                                 ),
//                                 SizedBox(width: 15),
//                                 Expanded(
//                                   child: Text(
//                                     subHeadings[j] == ""
//                                         ? "-"
//                                         : subHeadings[j] ?? "-",
//                                     style: TextStyle(
//                                       fontFamily: "JakartaMedium",
//                                       fontSize: 14,
//                                       color: AppColors.grey_thick,
//                                     ),
//                                   ),
//                                 ),
//                               ],
//                             ),
//                           );
//                         }),
//                       ],
//                     ),
//                   ),
//                   ListView.builder(
//                     physics: NeverScrollableScrollPhysics(),
//                     shrinkWrap: true,
//                     itemCount: groupedData.keys.length,
//                     itemBuilder: (context, index) {
//                       String date = groupedData.keys.elementAt(index);
//                       List<LedgerList> items = groupedData[date]!;
//
//                       return Container(
//                         padding: EdgeInsets.symmetric(vertical: 5),
//                         margin: EdgeInsets.symmetric(horizontal: 10),
//                         child: Column(
//                           crossAxisAlignment: CrossAxisAlignment.start,
//                           children: [
//                             Container(
//                               padding: EdgeInsets.only(bottom: 5),
//                               child: Text(
//                                 date,
//                                 style: TextStyle(
//                                   fontSize: 14,
//                                   fontFamily: "JakartaMedium",
//                                   color: Color(0xFF818181),
//                                 ),
//                               ),
//                             ),
//                             ...items.map((item) {
//                               double running_balance = 0;
//                               int currentIndex = provider.ledgerList.indexOf(
//                                 item,
//                               );
//                               for (var i = 0; i <= currentIndex; i++) {
//                                 var ledgerItem = provider.ledgerList[i];
//                                 double credit =
//                                     double.tryParse(
//                                       ledgerItem.creditAmount.toString(),
//                                     ) ??
//                                     0;
//                                 double debit =
//                                     double.tryParse(
//                                       ledgerItem.debitAmount.toString(),
//                                     ) ??
//                                     0;
//                                 running_balance += (debit - credit);
//                               }
//
//                               return Container(
//                                 padding: EdgeInsets.symmetric(
//                                   horizontal: 10,
//                                   vertical: 10,
//                                 ),
//                                 margin: EdgeInsets.symmetric(vertical: 5),
//                                 decoration: BoxDecoration(
//                                   color: Colors.white,
//                                   borderRadius: BorderRadius.circular(16),
//                                 ),
//                                 child: Column(
//                                   children: [
//                                     Row(
//                                       mainAxisAlignment:
//                                           MainAxisAlignment.start,
//                                       children: [
//                                         Expanded(
//                                           flex: 1,
//                                           child: SizedBox(
//                                             child:
//                                                 item.type == "Credit"
//                                                     ? Image.asset(
//                                                       "assets/images/trans_debit.png",
//                                                       height: 45,
//                                                       width: 45,
//                                                       fit: BoxFit.contain,
//                                                     )
//                                                     : Image.asset(
//                                                       "assets/images/trans_credit.png",
//                                                       height: 45,
//                                                       width: 45,
//                                                       fit: BoxFit.contain,
//                                                     ),
//                                           ),
//                                         ),
//                                         SizedBox(width: 10),
//                                         Expanded(
//                                           flex: 5,
//                                           child: SizedBox(
//                                             child: Column(
//                                               crossAxisAlignment:
//                                                   CrossAxisAlignment.start,
//                                               children: [
//                                                 Text(
//                                                   item.description ?? "-",
//                                                   maxLines: 2,
//                                                   overflow:
//                                                       TextOverflow.ellipsis,
//                                                   style: TextStyle(
//                                                     fontFamily: "JakartaMedium",
//                                                     fontSize: 12,
//                                                   ),
//                                                 ),
//                                               ],
//                                             ),
//                                           ),
//                                         ),
//                                         Spacer(),
//                                         Expanded(
//                                           flex: 3,
//                                           child: SizedBox(
//                                             child: RichText(
//                                               maxLines: 1,
//                                               textAlign: TextAlign.right,
//                                               overflow: TextOverflow.ellipsis,
//                                               text: TextSpan(
//                                                 children: [
//                                                   TextSpan(
//                                                     text:
//                                                         item.type == "Credit"
//                                                             ? "-"
//                                                             : "+",
//                                                     style: TextStyle(
//                                                       color: Color(0xFF2D2D2D),
//                                                       fontSize: 13,
//                                                       fontFamily:
//                                                           "JakartaRegular",
//                                                     ),
//                                                   ),
//                                                   TextSpan(
//                                                     text:
//                                                         "₹${item.type == "Credit" ? "${item.creditAmount}" : "${item.debitAmount}"}",
//                                                     style: TextStyle(
//                                                       color: Color(0xFF2D2D2D),
//                                                       fontSize: 13,
//                                                       fontFamily:
//                                                           "JakartaMedium",
//                                                     ),
//                                                   ),
//                                                 ],
//                                               ),
//                                             ),
//                                           ),
//                                         ),
//                                       ],
//                                     ),
//                                     Divider(
//                                       thickness: 0.5,
//                                       color: Color(0xFFd7d7d7),
//                                     ),
//                                     Row(
//                                       children: [
//                                         Expanded(
//                                           child: Text(
//                                             "Balance",
//                                             style: TextStyle(
//                                               fontSize: 13,
//                                               color: Color(0xFF2d2d2d),
//                                             ),
//                                           ),
//                                         ),
//                                         Expanded(
//                                           child: Text(
//                                             textAlign: TextAlign.right,
//                                             "${running_balance.toString()}" ??
//                                                 "-",
//                                             style: TextStyle(
//                                               color: Color(0xFF818181),
//                                               fontSize: 13,
//                                             ),
//                                           ),
//                                         ),
//                                       ],
//                                     ),
//                                     InkResponse(
//                                       onTap: () async {
//                                         Navigator.push(
//                                           context,
//                                           MaterialPageRoute(
//                                             builder:
//                                                 (context) => Transactiondetails(
//                                                   paymentID: item.refId,
//                                                   type: item.type,
//                                                 ),
//                                           ),
//                                         );
//                                       },
//                                       child: Container(
//                                         padding: EdgeInsets.symmetric(
//                                           vertical: 5,
//                                         ),
//                                         child: Row(
//                                           crossAxisAlignment:
//                                               CrossAxisAlignment.center,
//                                           mainAxisAlignment:
//                                               MainAxisAlignment.start,
//                                           children: [
//                                             Text(
//                                               "View Details",
//                                               style: TextStyle(
//                                                 fontFamily: "JakartaMedium",
//                                                 fontSize: 14,
//                                                 color: AppColors.app_blue,
//                                               ),
//                                             ),
//                                             SizedBox(width: 5),
//                                             SvgPicture.asset(
//                                               "assets/svg/next_button.svg",
//                                             ),
//                                           ],
//                                         ),
//                                       ),
//                                     ),
//                                   ],
//                                 ),
//                               );
//                             }).toList(),
//                           ],
//                         ),
//                       );
//                     },
//                   ),
//                   if ([
//                     "Vendor",
//                     "Customer",
//                   ].contains(provider.accountDetails.type)) ...[
//                     InkWell(
//                       onTap: () {
//                         Navigator.push(
//                           context,
//                           MaterialPageRoute(
//                             builder:
//                                 (context) => Submitpaymentrequestionlistsbymode(
//                                   mode: "other",
//                                   pageTitleName: "Add Payment Request (Other)",
//                                   accountId: provider.accountDetails.id!,
//                                 ),
//                           ),
//                         );
//                       },
//                       child: Container(
//                         alignment: Alignment.center,
//                         height: 45,
//                         margin: EdgeInsets.only(
//                           left: 5.0,
//                           right: 5.0,
//                           top: 5.0,
//                           bottom: 5.0,
//                         ),
//                         decoration: BoxDecoration(
//                           color: AppColors.app_blue, //1487C9
//                           borderRadius: BorderRadius.circular(15.0),
//                         ),
//                         child: Center(
//                           child: Text(
//                             "Add Payment Request (Other)",
//                             textAlign: TextAlign.center,
//                             style: TextStyle(
//                               color: Colors.white,
//                               fontFamily: "JakartaMedium",
//                               fontSize: 15,
//                             ),
//                           ),
//                         ),
//                       ),
//                     ),
//                   ],
//                 ],
//               ),
//             ),
//           ),
//         );
//       },
//     );
//   }
//
//   Future<bool> _onBackPressed(BuildContext context) async {
//     Navigator.pop(context, true);
//     return true;
//   }
// }
