class crmProspectDetailsAddLeadsResponse {
  List<LeadEmployees>? employees;
  List<Products>? products;
  List<String>? status;
  String? error;
  String? message;

  crmProspectDetailsAddLeadsResponse({
    this.employees,
    this.products,
    this.status,
    this.error,
    this.message,
  });

  crmProspectDetailsAddLeadsResponse.fromJson(Map<String, dynamic> json) {
    if (json['employees'] != null) {
      employees = <LeadEmployees>[];
      json['employees'].forEach((v) {
        employees!.add(LeadEmployees.fromJson(v));
      });
    }
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(Products.fromJson(v));
      });
    }
    status = json['status'].cast<String>();
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (employees != null) {
      data['employees'] = employees!.map((v) => v.toJson()).toList();
    }
    if (products != null) {
      data['products'] = products!.map((v) => v.toJson()).toList();
    }
    data['status'] = status;
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class LeadEmployees {
  String? id;
  String? name;

  LeadEmployees({this.id, this.name});

  LeadEmployees.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class Products {
  String? id;
  String? name;

  Products({this.id, this.name});

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
