import 'package:flutter/cupertino.dart';
import 'package:provider/provider.dart';

import '../../Models/hrmModels/tourExpensesDetailsResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class TourExpensesDetailsProvider extends ChangeNotifier {
  tourExpensesDetailsResponse? _response;
  bool _isLoading = false;
  String? _errorMessage;

  tourExpensesDetailsResponse? get response => _response;
  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;

  Future<void> fetchTourExpensesDetails(
    BuildContext context,
    String tourBillId,
  ) async {
    _isLoading = true;
    _errorMessage = null;
    _response = null;
    notifyListeners();

    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final result = await ApiCalling.tourExpensesDetailAPI(
        provider.session,
        provider.empId,
        tourBillId,
      );
      print("==== Tour Submitted ====");
      print("empId: ${provider.empId}");
      print("Session: ${provider.session}");
      print(": $result.");
      print("finish");
      print("=============================");

      if (result != null) {
        _response = result;
      } else {
        _errorMessage = "No data found!";
      }
    } catch (e) {
      _errorMessage = "Something went wrong: $e";
    }

    _isLoading = false;
    notifyListeners();
  }
}
