import 'package:flutter/material.dart';

import '../../Models/hrmModels/contactListResponse.dart';
import '../../services/api_calling.dart';

class ContactProvider with ChangeNotifier {
  bool _isLoading = false;
  ContactListResponse? _contactResponse;

  bool get isLoading => _isLoading;
  ContactListResponse? get contactResponse => _contactResponse;
  List<EmpContactList> get contactList =>
      _contactResponse?.empContactList ?? [];

  /// Fetch contact list from API
  Future<void> fetchContactList(String session, String empId, int pageNumber) async {
    _isLoading = true;
    notifyListeners();

    try {
      final response = await ApiCalling.contactListAPI(session, empId, pageNumber);
      _contactResponse = response;
    } catch (e) {
      debugPrint("❌ Error fetching contact list: $e");
      _contactResponse = null;
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  /// Optional: To clear the list
  void clearContacts() {
    _contactResponse = null;
    notifyListeners();
  }
}
