class rewardListResponse {
  RewardsList? rewardsList;
  String? achievedAmount;
  String? disbursedAmount;
  String? balanceAmount;
  String? error;
  String? message;
  int? sessionExists;

  rewardListResponse({
    this.rewardsList,
    this.achievedAmount,
    this.disbursedAmount,
    this.balanceAmount,
    this.error,
    this.message,
    this.sessionExists,
  });

  rewardListResponse.fromJson(Map<String, dynamic> json) {
    rewardsList =
        json['rewards_list'] != null
            ? RewardsList.fromJson(json['rewards_list'])
            : null;
    achievedAmount = json['achieved_amount'];
    disbursedAmount = json['disbursed_amount'];
    balanceAmount = json['balance_amount'];
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (rewardsList != null) {
      data['rewards_list'] = rewardsList!.toJson();
    }
    data['achieved_amount'] = achievedAmount;
    data['disbursed_amount'] = disbursedAmount;
    data['balance_amount'] = balanceAmount;
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class RewardsList {
  String? id;
  String? empId;
  String? description;
  String? type;
  String? cAmount;
  String? dAmount;
  String? enteredBy;
  String? isApproved;
  String? approvedBy;
  String? approvedDatetime;
  String? updatedDatetime;
  String? isExist;
  String? dateTime;
  String? employeeName;
  String? entryName;

  RewardsList({
    this.id,
    this.empId,
    this.description,
    this.type,
    this.cAmount,
    this.dAmount,
    this.enteredBy,
    this.isApproved,
    this.approvedBy,
    this.approvedDatetime,
    this.updatedDatetime,
    this.isExist,
    this.dateTime,
    this.employeeName,
    this.entryName,
  });

  RewardsList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    empId = json['emp_id'];
    description = json['description'];
    type = json['type'];
    cAmount = json['c_amount'];
    dAmount = json['d_amount'];
    enteredBy = json['entered_by'];
    isApproved = json['is_approved'];
    approvedBy = json['approved_by'];
    approvedDatetime = json['approved_datetime'];
    updatedDatetime = json['updated_datetime'];
    isExist = json['is_exist'];
    dateTime = json['date_time'];
    employeeName = json['employee_name'];
    entryName = json['entry_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['emp_id'] = empId;
    data['description'] = description;
    data['type'] = type;
    data['c_amount'] = cAmount;
    data['d_amount'] = dAmount;
    data['entered_by'] = enteredBy;
    data['is_approved'] = isApproved;
    data['approved_by'] = approvedBy;
    data['approved_datetime'] = approvedDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['is_exist'] = isExist;
    data['date_time'] = dateTime;
    data['employee_name'] = employeeName;
    data['entry_name'] = entryName;
    return data;
  }
}
