class attendanceRequestListResponse {
  List<RequestList>? requestList;
  String? error;
  String? message;
  int? sessionExists;

  attendanceRequestListResponse({
    this.requestList,
    this.error,
    this.message,
    this.sessionExists,
  });

  attendanceRequestListResponse.fromJson(Map<String, dynamic> json) {
    if (json['request_list'] != null) {
      requestList = <RequestList>[];
      json['request_list'].forEach((v) {
        requestList!.add(RequestList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requestList != null) {
      data['request_list'] = requestList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class RequestList {
  String? id;
  String? attendanceType;
  String? type;
  String? date;
  String? checkInType;
  String? checkInTime;
  String? chechOutType;
  String? checkOutTime;
  String? status;
  String? requestedDatetime;
  String? employeeName;

  RequestList({
    this.id,
    this.attendanceType,
    this.type,
    this.date,
    this.checkInType,
    this.checkInTime,
    this.chechOutType,
    this.checkOutTime,
    this.status,
    this.requestedDatetime,
    this.employeeName,
  });

  RequestList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    attendanceType = json['attendance_type'];
    type = json['type'];
    date = json['date'];
    checkInType = json['check_in_type'];
    checkInTime = json['check_in_time'];
    chechOutType = json['chech_out_type'];
    checkOutTime = json['check_out_time'];
    status = json['status'];
    requestedDatetime = json['requested_datetime'];
    employeeName = json['employee_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['attendance_type'] = attendanceType;
    data['type'] = type;
    data['date'] = date;
    data['check_in_type'] = checkInType;
    data['check_in_time'] = checkInTime;
    data['chech_out_type'] = chechOutType;
    data['check_out_time'] = checkOutTime;
    data['status'] = status;
    data['requested_datetime'] = requestedDatetime;
    data['employee_name'] = employeeName;
    return data;
  }
}
