class EditCommonAccFormDetailsResponse {
  List<AccountList>? accountList;
  String? error;
  String? message;
  int? sessionExists;

  EditCommonAccFormDetailsResponse(
      {this.accountList, this.error, this.message, this.sessionExists});

  EditCommonAccFormDetailsResponse.fromJson(Map<String, dynamic> json) {
    if (json['account_list'] != null) {
      accountList = <AccountList>[];
      json['account_list'].forEach((v) {
        accountList!.add(new AccountList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.accountList != null) {
      data['account_list'] = this.accountList!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class AccountList {
  String? id;
  String? isPaymentAccount;
  String? createdEmployeeId;
  String? type;
  String? refId;
  String? name;
  String? subLocality;
  String? district;
  String? state;
  String? address;
  String? datetime;
  String? empId;
  String? bankName;
  String? bankBranchName;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;
  String? bankUpiName;
  String? gstNumber;
  Null? cashfreeAccountId;
  String? isGstNumberVerified;
  String? isBankAccountVerified;
  String? remarks;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? mob1;
  String? email;
  String? contactName;

  AccountList(
      {this.id,
        this.isPaymentAccount,
        this.createdEmployeeId,
        this.type,
        this.refId,
        this.name,
        this.subLocality,
        this.district,
        this.state,
        this.address,
        this.datetime,
        this.empId,
        this.bankName,
        this.bankBranchName,
        this.bankIfscCode,
        this.bankAccountHolderName,
        this.bankAccountNumber,
        this.bankUpiId,
        this.bankUpiName,
        this.gstNumber,
        this.cashfreeAccountId,
        this.isGstNumberVerified,
        this.isBankAccountVerified,
        this.remarks,
        this.isExists,
        this.createdDatetime,
        this.updatedDatetime,
        this.mob1,
        this.email,
        this.contactName});

  AccountList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    isPaymentAccount = json['is_payment_account'];
    createdEmployeeId = json['created_employee_id'];
    type = json['type'];
    refId = json['ref_id'];
    name = json['name'];
    subLocality = json['sub_locality'];
    district = json['district'];
    state = json['state'];
    address = json['address'];
    datetime = json['datetime'];
    empId = json['emp_id'];
    bankName = json['bank_name'];
    bankBranchName = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
    bankUpiName = json['bank_upi_name'];
    gstNumber = json['gst_number'];
    cashfreeAccountId = json['cashfree_account_id'];
    isGstNumberVerified = json['is_gst_number_verified'];
    isBankAccountVerified = json['is_bank_account_verified'];
    remarks = json['remarks'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    mob1 = json['mob1'];
    email = json['email'];
    contactName = json['contact_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['is_payment_account'] = this.isPaymentAccount;
    data['created_employee_id'] = this.createdEmployeeId;
    data['type'] = this.type;
    data['ref_id'] = this.refId;
    data['name'] = this.name;
    data['sub_locality'] = this.subLocality;
    data['district'] = this.district;
    data['state'] = this.state;
    data['address'] = this.address;
    data['datetime'] = this.datetime;
    data['emp_id'] = this.empId;
    data['bank_name'] = this.bankName;
    data['bank_branch_name'] = this.bankBranchName;
    data['bank_ifsc_code'] = this.bankIfscCode;
    data['bank_account_holder_name'] = this.bankAccountHolderName;
    data['bank_account_number'] = this.bankAccountNumber;
    data['bank_upi_id'] = this.bankUpiId;
    data['bank_upi_name'] = this.bankUpiName;
    data['gst_number'] = this.gstNumber;
    data['cashfree_account_id'] = this.cashfreeAccountId;
    data['is_gst_number_verified'] = this.isGstNumberVerified;
    data['is_bank_account_verified'] = this.isBankAccountVerified;
    data['remarks'] = this.remarks;
    data['is_exists'] = this.isExists;
    data['created_datetime'] = this.createdDatetime;
    data['updated_datetime'] = this.updatedDatetime;
    data['mob1'] = this.mob1;
    data['email'] = this.email;
    data['contact_name'] = this.contactName;
    return data;
  }
}
