class ServiceComplaintBillListResponse {
  List<ComplaintList>? complaintList;
  int? error;
  int? sessionExists;

  ServiceComplaintBillListResponse(
      {this.complaintList, this.error, this.sessionExists});

  ServiceComplaintBillListResponse.fromJson(Map<String, dynamic> json) {
    if (json['complaint_list'] != null) {
      complaintList = <ComplaintList>[];
      json['complaint_list'].forEach((v) {
        complaintList!.add(new ComplaintList.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.complaintList != null) {
      data['complaint_list'] =
          this.complaintList!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class ComplaintList {
  String? billId;
  String? totalAmount;
  String? rawAmount;
  String? narration;
  String? billDate;
  String? dueDate;
  String? billPaid;

  ComplaintList(
      {this.billId,
        this.totalAmount,
        this.rawAmount,
        this.narration,
        this.billDate,
        this.dueDate,
        this.billPaid});

  ComplaintList.fromJson(Map<String, dynamic> json) {
    billId = json['bill_id'];
    totalAmount = json['total_amount'];
    rawAmount = json['raw_amount'];
    narration = json['narration'];
    billDate = json['bill_date'];
    dueDate = json['due_date'];
    billPaid = json['bill_paid'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['bill_id'] = this.billId;
    data['total_amount'] = this.totalAmount;
    data['raw_amount'] = this.rawAmount;
    data['narration'] = this.narration;
    data['bill_date'] = this.billDate;
    data['due_date'] = this.dueDate;
    data['bill_paid'] = this.billPaid;
    return data;
  }
}
