import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/screens/crm/editProductsList.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class Productdetails extends StatefulWidget {
  final leadID;
  final mode;
  const Productdetails({super.key, required this.leadID, required this.mode});

  @override
  State<Productdetails> createState() => _ProductdetailsState();
}

class _ProductdetailsState extends State<Productdetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<crmLeadDetailsProvider>(
        context,
        listen: false,
      );
      provider.crmLeadDetailsAPIFunction(context, widget.leadID, widget.mode);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<crmLeadDetailsProvider>(
      builder: (context, provider, child) {
        var customerDetails = provider.leadProducts;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar(context, "Product Details"),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              provider.leadProducts.isNotEmpty
                  ? SizedBox(
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          // TextWidget(context,"Product Details"),
                          ListView.builder(
                            itemCount: customerDetails.length,
                            shrinkWrap: true,
                            itemBuilder: (context, index) {
                              return Container(
                                margin: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 5,
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 15,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: List.generate(4, (j) {
                                    final textheads = [
                                      "Product Name",
                                      "Product Price",
                                      "Quantity",
                                      "Total Price",
                                    ];
                                    final textSubheads = [
                                      customerDetails[index].productName ?? "-",
                                      customerDetails[index].price ?? "-",
                                      customerDetails[index].qty ?? "-",
                                      customerDetails[index].price ?? "-",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 6,
                                        horizontal: 0,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            flex: 2,
                                            child: Text(
                                              textheads[j].toString(),
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                          ),
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              textSubheads[j],
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                              style: TextStyle(
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ),
                              );
                            },
                          ),

                          SizedBox(height: 75),
                        ],
                      ),
                    ),
                  )
                  : Emptywidget(context),
          floatingActionButton: Align(
            alignment: Alignment.bottomCenter,
            child: InkWell(
              onTap: () async {
                var res = await Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder:
                        (context) => EditProductsList(leadID: widget.leadID),
                  ),
                );
                if (res == true) {
                  provider.crmLeadDetailsAPIFunction(
                    context,
                    widget.leadID,
                    widget.mode,
                  );
                }
              },
              child: Container(
                alignment: Alignment.bottomCenter,
                height: 45,
                width: MediaQuery.of(context).size.width,
                margin: EdgeInsets.symmetric(horizontal: 10),
                decoration: BoxDecoration(
                  color: AppColors.app_blue,
                  borderRadius: BorderRadius.circular(14.0),
                ),
                child: Center(
                  child: Text(
                    "Edit Products",
                    textAlign: TextAlign.center,
                    style: TextStyle(
                      color: Colors.white,
                      fontFamily: "JakartaMedium",
                    ),
                  ),
                ),
              ),
            ),
          ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
        );
      },
    );
  }
}
