import 'dart:io';

import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class AppointmentDetails extends StatefulWidget {
  final leadID;
  const AppointmentDetails({super.key, this.leadID});

  @override
  State<AppointmentDetails> createState() => _AppointmentDetailsState();
}

class _AppointmentDetailsState extends State<AppointmentDetails> {
  Dropdowntheme ddtheme = Dropdowntheme();

  @override
  Widget build(BuildContext context) {
    return Consumer<crmLeadDetailsProvider>(
      builder: (context, provider, child) {
        var quotationDetails = provider.appointmentDetails;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Appointment Details"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: SizedBox(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      // TextWidget(context, "Appointment Details"),
                      ListView.builder(
                        itemCount: quotationDetails.length,
                        shrinkWrap: true,
                        itemBuilder: (context, index) {
                          return Container(
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            padding: EdgeInsets.symmetric(
                              horizontal: 15,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                ...List.generate(5, (j) {
                                  final textheads = [
                                    "Employee Name",
                                    "Appointment Date",
                                    "Appointment Type",
                                    "Note",
                                    "Appointment Executed",
                                    "Appointment Created on",
                                  ];
                                  final textSubheads = [
                                    quotationDetails[index].ename ?? "-",
                                    quotationDetails[index].aappDate ?? "-",
                                    quotationDetails[index].atype ?? "-",
                                    quotationDetails[index].anote ?? "-",
                                    quotationDetails[index].astatus ?? "-",
                                    quotationDetails[index].adate ?? "-",
                                  ];
                                  return Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 6,
                                      horizontal: 0,
                                    ),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Text(
                                            textheads[j].toString(),
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                        Expanded(
                                          child: Text(
                                            textSubheads[j],
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                            style: TextStyle(
                                              color:
                                                  textSubheads[j] == "View File"
                                                      ? AppColors.app_blue
                                                      : Color(0xFF818181),
                                              decoration:
                                                  textSubheads[j] == "View File"
                                                      ? TextDecoration.underline
                                                      : TextDecoration.none,
                                              decorationColor:
                                                  AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                              ],
                            ),
                          );
                        },
                      ),

                      SizedBox(height: 75),
                    ],
                  ),
                ),
              ),
              floatingActionButton: Align(
                alignment: Alignment.bottomCenter,
                child: InkWell(
                  onTap: () {
                    _showAddAppointmentSheet(context);
                  },
                  child: Container(
                    alignment: Alignment.bottomCenter,
                    height: 45,
                    width: MediaQuery.of(context).size.width,
                    margin: EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                      color: AppColors.app_blue,
                      borderRadius: BorderRadius.circular(14.0),
                    ),
                    child: Center(
                      child: Text(
                        "Add Appointment",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: Colors.white,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),
                  ),
                ),
              ),
              floatingActionButtonLocation:
                  FloatingActionButtonLocation.centerFloat,
            ),
          ),
        );
      },
    );
  }

  Future<void> _showAddAppointmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<crmLeadDetailsProvider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Add Contact",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          TextWidget(context, "Appointment Date"),
                          GestureDetector(
                            onTap: () {
                              provider.showDatePickerDialog(context);
                            },
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Expanded(
                                  child: Container(
                                    height: 50,
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                      color: AppColors.text_field_color,
                                      borderRadius: BorderRadius.circular(14),
                                    ),
                                    child: Padding(
                                      padding: const EdgeInsets.fromLTRB(
                                        10.0,
                                        0.0,
                                        10,
                                        0,
                                      ),
                                      child: TextFormField(
                                        controller: provider.dateController,
                                        keyboardType: TextInputType.text,
                                        enabled: false,
                                        maxLines: 1,
                                        readOnly: true,
                                        onChanged: (value) {},
                                        decoration: InputDecoration(
                                          hintText: "Enter Date",
                                          hintStyle: TextStyle(
                                            fontWeight: FontWeight.w400,
                                            color: Color(0xFFB4BEC0),
                                            fontSize: 14,
                                          ),

                                          enabledBorder: InputBorder.none,
                                          disabledBorder: InputBorder.none,
                                          focusedBorder: InputBorder.none,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.dateError),

                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    isExpanded: true,
                                    hint: const Row(
                                      children: [
                                        Expanded(
                                          child: Text(
                                            'Select Account',
                                            style: TextStyle(fontSize: 14),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                      ],
                                    ),
                                    items:
                                        provider.visitTypes
                                            .map(
                                              (vt) => DropdownMenuItem<String>(
                                                value: vt,
                                                child: Text(
                                                  vt,
                                                  style: const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    value: provider.selectedVisitType,
                                    onChanged: (value) {
                                      if (value != null) {
                                        provider.selectedVisitType = value;
                                        print(
                                          "statusId:${provider.selectedVisitType}",
                                        );
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.visitTypeError),

                          textControllerWidget(
                            context,
                            provider.noteController,
                            "Note",
                            "Enter Note",
                            provider.onChangeNote,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          errorWidget(context, provider.noteError),

                          InkWell(
                            onTap:
                                provider.isLoading
                                    ? null
                                    : () {
                                      provider.isLoading = true;
                                      provider
                                          .crmLeadDetailsAddAppointmentAPIFunction(
                                            context,
                                            widget.leadID,
                                            provider.formattedDateToSend,
                                            provider.selectedVisitType,
                                            provider.noteController.text,
                                          );
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child:
                                    provider.isLoading
                                        ? CircularProgressIndicator.adaptive(
                                          valueColor: AlwaysStoppedAnimation(
                                            AppColors.white,
                                          ),
                                        )
                                        : Text(
                                          "Submit",
                                          textAlign: TextAlign.center,
                                          style: TextStyle(color: Colors.white),
                                        ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
