class AdvanceListResponse {
  List<AdvanceList>? advanceList;
  String? error;
  String? message;
  int? sessionExists;

  AdvanceListResponse(
      {this.advanceList, this.error, this.message, this.sessionExists});

  AdvanceListResponse.fromJson(Map<String, dynamic> json) {
    if (json['advance_list'] != null) {
      advanceList = <AdvanceList>[];
      json['advance_list'].forEach((v) {
        advanceList!.add(new AdvanceList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.advanceList != null) {
      data['advance_list'] = this.advanceList!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class AdvanceList {
  String? id;
  String? createdDatetime;
  String? narration;
  String? issuedAmount;
  String? deductedAmount;
  String? type;

  AdvanceList(
      {this.id,
        this.createdDatetime,
        this.narration,
        this.issuedAmount,
        this.deductedAmount,
        this.type
      });

  AdvanceList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createdDatetime = json['created_datetime'];
    narration = json['narration'];
    issuedAmount = json['issued_amount'];
    deductedAmount = json['deducted_amount'];
    type = json['type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['created_datetime'] = this.createdDatetime;
    data['narration'] = this.narration;
    data['issued_amount'] = this.issuedAmount;
    data['deducted_amount'] = this.deductedAmount;
    data['type'] = this.type;
    return data;
  }
}
