class DashboardResponse {
  int? attStatus;
  String? appRequestAutostart;
  String? notificationsCount;
  int? sessionExists;

  DashboardResponse({
    this.attStatus,
    this.appRequestAutostart,
    this.notificationsCount,
    this.sessionExists,
  });

  DashboardResponse.fromJson(Map<String, dynamic> json) {
    attStatus = json['att_status'];
    appRequestAutostart = json['app_request_autostart'];
    notificationsCount = json['notifications_count'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['att_status'] = attStatus;
    data['app_request_autostart'] = appRequestAutostart;
    data['notifications_count'] = notificationsCount;
    data['session_exists'] = sessionExists;
    return data;
  }
}
