import 'dart:io';

import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/ordersProvider/pagesDashboardProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class Orderdetailsproductshistory extends StatefulWidget {
  const Orderdetailsproductshistory({super.key});

  @override
  State<Orderdetailsproductshistory> createState() => _OrderdetailsproductshistoryState();
}

class _OrderdetailsproductshistoryState extends State<Orderdetailsproductshistory> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var details = Provider.of<Pagesdashboardprovider>(
        context,
        listen: false,
      );

    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Pagesdashboardprovider>(
      builder: (context, provider, child) {
        final productsHistory = provider.productsHistory;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS?false:true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Products"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: productsHistory.isNotEmpty?Container(
                child: ListView.builder(
                    scrollDirection: Axis.vertical,
                    shrinkWrap: true,
                    physics: AlwaysScrollableScrollPhysics(),
                    itemCount: productsHistory.length,
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),

                    itemBuilder: (context, index) {
                      return Container(
                        margin: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                        padding: EdgeInsets.symmetric(horizontal: 15, vertical: 10),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: List.generate(7, (j) {
                            final textheads = [
                              "Product Name",
                              "Product Price",
                              "Quantity",
                              "CGST %",
                              "SGST %",
                              "IGST %",
                              "Total Price",
                            ];
                            final textSubheads = [
                              "${productsHistory[index].productName}",
                              "${productsHistory[index].unitPrice}",
                              "${productsHistory[index].qty}",
                              "${productsHistory[index].cgstPercentage}",
                              "${productsHistory[index].sgstPercentage}",
                              "${productsHistory[index].igstPercentage}",
                              "${productsHistory[index].totalPrice}",
                            ];
                            return Container(

                              padding: EdgeInsets.symmetric(
                                vertical: 6,
                                horizontal: 0,
                              ),
                              child: Row(
                                mainAxisAlignment:
                                MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [

                                  Expanded(
                                    child: Text(textheads[j].toString(),
                                      maxLines: 2,
                                      overflow: TextOverflow.ellipsis,),
                                  ),
                                  Expanded(
                                    child: SizedBox(
                                      // height:45,
                                      width:
                                      MediaQuery.of(
                                        context,
                                      ).size.width *
                                          0.75,
                                      child: Text(
                                        textSubheads[j],
                                        maxLines: 2,
                                        overflow:
                                        TextOverflow.ellipsis,
                                        style: TextStyle(
                                          color: Color(0xFF818181),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          }),
                        ),
                      );
                    }
                ),
              ):Emptywidget(context),

            ),
          ),
        );
      },
    );
  }
}
