import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/crm/ProspectDetailsByMode.dart';
import 'package:provider/provider.dart';

import '../../Models/crmModels/ProspectListViewResponse.dart';
import '../../Notifiers/crmProvider/ProspectListProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class ProspectListByModeold extends StatefulWidget {
  final pageTitleName;
  final mode;
  const ProspectListByModeold({super.key, this.pageTitleName, this.mode});

  @override
  State<ProspectListByModeold> createState() => _ProspectListByModeoldState();
}

class _ProspectListByModeoldState extends State<ProspectListByModeold> {
  Dropdowntheme ddtheme = Dropdowntheme();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<ProspectListProvider>(
        context,
        listen: false,
      );
      provider.crmProspectListViewAPIFunction(context, widget.mode);
      provider.crmProspectListAPIFunction(context, widget.mode, "");
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<ProspectListProvider>(
      builder: (context, provider, child) {
        final crmLists = provider.accountList;
        // ignore: deprecated_member_use
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2(
            context,
            widget.pageTitleName,
            provider.resetForm,
            Row(
              children: [
                InkResponse(
                  onTap: () async {
                    _showFilterSheet(context);
                  },
                  child: SvgPicture.asset(
                    "assets/svg/filter_ic.svg",
                    height: 25,
                  ),
                ),
              ],
            ),
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              provider.isLoading
                  ? Center(
                    child: CircularProgressIndicator.adaptive(
                      valueColor: AlwaysStoppedAnimation<Color>(
                        AppColors.app_blue,
                      ),
                    ),
                  )
                  : crmLists.isNotEmpty
                  ? SizedBox(
                    child: Scrollbar(
                      thumbVisibility: false,
                      child: ListView.builder(
                        itemCount: crmLists.length,
                        shrinkWrap: true,
                        physics: AlwaysScrollableScrollPhysics(),
                        itemBuilder: (context, index) {
                          if (crmLists.isEmpty) {
                            return SizedBox(
                              child: Center(child: Text("No Data Available")),
                            );
                          }

                          // if(crmLists[index].aid=="1726"){
                          return Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 10,
                            ),
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16),
                            ),
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: Container(
                                        height: 50,
                                        width: 35,
                                        padding: EdgeInsets.all(8.0),
                                        decoration: BoxDecoration(
                                          color: Color(0xFFE6F6FF),
                                          borderRadius: BorderRadius.circular(
                                            8,
                                          ),
                                        ),
                                        child: SvgPicture.asset(
                                          "assets/svg/se_block_head.svg",
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 4,
                                      child: SizedBox(
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              crmLists[index].aname!,
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                Divider(
                                  thickness: 0.5,
                                  color: Color(0xFFD7D7D7),
                                ),
                                ...List.generate(6, (j) {
                                  final headings = [
                                    "Account Manager",
                                    "Contact Person",
                                    "Mobile Number",
                                    "Address",
                                    "Account Age",
                                    "GST Number",
                                  ];

                                  final subHeadings = [
                                    crmLists[index].accman,
                                    crmLists[index].cname,
                                    crmLists[index].mob1,
                                    crmLists[index].address,
                                    "${crmLists[index].age} days old",
                                    crmLists[index].gstNumber,
                                  ];
                                  return Container(
                                    padding: EdgeInsets.symmetric(vertical: 5),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Text(
                                            headings[j],
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.semi_black,
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          child: Text(
                                            subHeadings[j]!,
                                            style: TextStyle(
                                              fontSize: 14,
                                              color: Color(0xFF818181),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                                InkResponse(
                                  onTap: () async {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => ProspectDetailsByMode(
                                              pageTitleName:
                                                  widget.pageTitleName,
                                              mode: widget.mode,
                                              leadId:
                                                  provider
                                                      .accountList[index]
                                                      .aid,
                                            ),
                                      ),
                                    );
                                  },
                                  child: Container(
                                    padding: EdgeInsets.symmetric(vertical: 5),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.center,
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      children: [
                                        Text(
                                          "View Details",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                          ),
                                        ),
                                        SizedBox(width: 5),
                                        SvgPicture.asset(
                                          "assets/svg/next_button.svg",
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          );
                        },
                      ),
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }

  Future<void> _showFilterSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<ProspectListProvider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),
                          Row(
                            children: [
                              Expanded(
                                child: Text(
                                  "Filter",
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontSize: 14,
                                  ),
                                ),
                              ),
                            ],
                          ),

                          if (widget.mode != "executive") ...[
                            TextWidget(context, "Employee"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<Employees>(
                                      hint: Text(
                                        "Select Source",
                                        style: TextStyle(fontSize: 14),
                                      ),
                                      items:
                                          provider.employeesList
                                              .map(
                                                (slist) =>
                                                    DropdownMenuItem<Employees>(
                                                      value: slist,
                                                      child: Text(
                                                        slist.name!,
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                      ),
                                                    ),
                                              )
                                              .toList(),
                                      value:
                                          provider.employeesList.contains(
                                                provider.selectedEmployees,
                                              )
                                              ? provider.selectedEmployees
                                              : null,

                                      // value: provider.selectedEmployees,
                                      onChanged: (Employees? value) {
                                        if (value != null) {
                                          if (provider
                                              .employeesList
                                              .isNotEmpty) {
                                            provider.selectedEmployees = value;
                                            provider.selectedEmployeeId =
                                                value.id!;
                                            provider.selectedEmployeeValue =
                                                value.name!;
                                          }
                                        }
                                      },
                                      isExpanded: true,
                                      dropdownSearchData: DropdownSearchData(
                                        searchInnerWidgetHeight: 50,
                                        searchController:
                                            provider.searchController,
                                        searchInnerWidget: Padding(
                                          padding: const EdgeInsets.all(8),
                                          child: TextFormField(
                                            controller:
                                                provider.searchController,
                                            decoration: InputDecoration(
                                              isDense: true,
                                              contentPadding:
                                                  const EdgeInsets.symmetric(
                                                    horizontal: 10,
                                                    vertical: 8,
                                                  ),
                                              hintText: 'Search account...',
                                              border: OutlineInputBorder(
                                                borderRadius:
                                                    BorderRadius.circular(8),
                                              ),
                                            ),
                                          ),
                                        ),
                                        searchMatchFn: (item, searchValue) {
                                          return item.value?.name
                                                  ?.toLowerCase()
                                                  .contains(
                                                    searchValue.toLowerCase(),
                                                  ) ??
                                              false;
                                        },
                                      ),
                                      onMenuStateChange: (isOpen) {
                                        if (!isOpen) {
                                          provider.searchController.clear();
                                        }
                                      },
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData:
                                          ddtheme.menuItemStyleData,
                                      dropdownStyleData:
                                          ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],

                          textControllerWidget(
                            context,
                            provider.mobileNumberController,
                            "Mobile Number",
                            "Enter Mobile Number",
                            provider.onChangedMobileNum,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          textControllerWidget(
                            context,
                            provider.companyNameController,
                            "Company Name",
                            "Enter Company Name",
                            provider.onChangedCompanyName,
                            TextInputType.text,
                            false,
                            null,
                          ),

                          InkResponse(
                            onTap: () {
                              provider.crmProspectListAPIFunction(
                                context,
                                widget.mode,
                                provider.selectedEmployeeId,
                              );
                              Navigator.pop(context);
                            },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: EdgeInsets.symmetric(horizontal: 10),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child: Text(
                                "Submit",
                                style: TextStyle(
                                  fontSize: 15,
                                  fontFamily: "JakartaMedium",
                                  color: Colors.white,
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
