class tourExpensesDetailsResponse {
  RequestDetails? requestDetails;
  TourExpenses? tourExpenses;
  List<TravelExpenses>? travelExpenses;
  List<HotelExpenses>? hotelExpenses;
  List<OtherExpenses>? otherExpenses;
  String? error;
  String? message;
  int? sessionExists;

  tourExpensesDetailsResponse({
    this.requestDetails,
    this.tourExpenses,
    this.travelExpenses,
    this.hotelExpenses,
    this.otherExpenses,
    this.error,
    this.message,
    this.sessionExists,
  });

  tourExpensesDetailsResponse.fromJson(Map<String, dynamic> json) {
    requestDetails =
        json['request_details'] != null
            ? RequestDetails.fromJson(json['request_details'])
            : null;
    tourExpenses =
        json['tour_expenses'] != null
            ? TourExpenses.fromJson(json['tour_expenses'])
            : null;
    if (json['travel_expenses'] != null) {
      travelExpenses = <TravelExpenses>[];
      json['travel_expenses'].forEach((v) {
        travelExpenses!.add(TravelExpenses.fromJson(v));
      });
    }
    if (json['hotel_expenses'] != null) {
      hotelExpenses = <HotelExpenses>[];
      json['hotel_expenses'].forEach((v) {
        hotelExpenses!.add(HotelExpenses.fromJson(v));
      });
    }
    if (json['other_expenses'] != null) {
      otherExpenses = <OtherExpenses>[];
      json['other_expenses'].forEach((v) {
        otherExpenses!.add(OtherExpenses.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requestDetails != null) {
      data['request_details'] = requestDetails!.toJson();
    }
    if (tourExpenses != null) {
      data['tour_expenses'] = tourExpenses!.toJson();
    }
    if (travelExpenses != null) {
      data['travel_expenses'] = travelExpenses!.map((v) => v.toJson()).toList();
    }
    if (hotelExpenses != null) {
      data['hotel_expenses'] = hotelExpenses!.map((v) => v.toJson()).toList();
    }
    if (otherExpenses != null) {
      data['other_expenses'] = otherExpenses!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class RequestDetails {
  String? id;
  String? employeeName;
  String? placeOfVisit;
  String? appliedDate;
  String? fromDate;
  String? toDate;
  String? type;
  String? appliedAmount;
  String? approvedAmount;
  String? approvalStatus;
  String? tlApprovedBy;
  String? tlApprovedAmount;
  String? tlRemarks;
  String? tlApprovedDate;
  String? hrApprovedBy;
  String? hrApprovedAmount;
  String? hrRemarks;
  Null hrApprovedDate;

  RequestDetails({
    this.id,
    this.employeeName,
    this.placeOfVisit,
    this.appliedDate,
    this.fromDate,
    this.toDate,
    this.type,
    this.appliedAmount,
    this.approvedAmount,
    this.approvalStatus,
    this.tlApprovedBy,
    this.tlApprovedAmount,
    this.tlRemarks,
    this.tlApprovedDate,
    this.hrApprovedBy,
    this.hrApprovedAmount,
    this.hrRemarks,
    this.hrApprovedDate,
  });

  RequestDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    employeeName = json['employee_name'];
    placeOfVisit = json['place_of_visit'];
    appliedDate = json['applied_date'];
    fromDate = json['from_date'];
    toDate = json['to_date'];
    type = json['type'];
    appliedAmount = json['applied_amount'];
    approvedAmount = json['approved_amount'];
    approvalStatus = json['approval_status'];
    tlApprovedBy = json['tl_approved_by'];
    tlApprovedAmount = json['tl_approved_amount'];
    tlRemarks = json['tl_remarks'];
    tlApprovedDate = json['tl_approved_date'];
    hrApprovedBy = json['hr_approved_by'];
    hrApprovedAmount = json['hr_approved_amount'];
    hrRemarks = json['hr_remarks'];
    hrApprovedDate = json['hr_approved_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['id'] = id;
    data['employee_name'] = employeeName;
    data['place_of_visit'] = placeOfVisit;
    data['applied_date'] = appliedDate;
    data['from_date'] = fromDate;
    data['to_date'] = toDate;
    data['type'] = type;
    data['applied_amount'] = appliedAmount;
    data['approved_amount'] = approvedAmount;
    data['approval_status'] = approvalStatus;
    data['tl_approved_by'] = tlApprovedBy;
    data['tl_approved_amount'] = tlApprovedAmount;
    data['tl_remarks'] = tlRemarks;
    data['tl_approved_date'] = tlApprovedDate;
    data['hr_approved_by'] = hrApprovedBy;
    data['hr_approved_amount'] = hrApprovedAmount;
    data['hr_remarks'] = hrRemarks;
    data['hr_approved_date'] = hrApprovedDate;
    return data;
  }
}

class TourExpenses {
  String? placeOfVisit;
  String? da;
  String? type;
  String? appliedAmount;
  String? fromDate;
  String? toDate;
  String? extraNote;

  TourExpenses({
    this.placeOfVisit,
    this.da,
    this.type,
    this.appliedAmount,
    this.fromDate,
    this.toDate,
    this.extraNote,
  });

  TourExpenses.fromJson(Map<String, dynamic> json) {
    placeOfVisit = json['place_of_visit'];
    da = json['da'];
    type = json['type'];
    appliedAmount = json['applied_amount'];
    fromDate = json['from_date'];
    toDate = json['to_date'];
    extraNote = json['extra_note'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['place_of_visit'] = placeOfVisit;
    data['da'] = da;
    data['type'] = type;
    data['applied_amount'] = appliedAmount;
    data['from_date'] = fromDate;
    data['to_date'] = toDate;
    data['extra_note'] = extraNote;
    return data;
  }
}

class TravelExpenses {
  String? froma;
  String? toa;
  String? travelType;
  String? fare;
  String? travelBill;
  String? imageDirFilePath;

  TravelExpenses({
    this.froma,
    this.toa,
    this.travelType,
    this.fare,
    this.travelBill,
    this.imageDirFilePath,
  });

  TravelExpenses.fromJson(Map<String, dynamic> json) {
    froma = json['froma'];
    toa = json['toa'];
    travelType = json['travel_type'];
    fare = json['fare'];
    travelBill = json['travel_bill'];
    imageDirFilePath = json['image_dir_file_path'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['froma'] = froma;
    data['toa'] = toa;
    data['travel_type'] = travelType;
    data['fare'] = fare;
    data['travel_bill'] = travelBill;
    data['image_dir_file_path'] = imageDirFilePath;
    return data;
  }
}

class HotelExpenses {
  String? hotelName;
  String? fromDate;
  String? toDate;
  String? amount;
  String? imageDirFilePath;

  HotelExpenses({
    this.hotelName,
    this.fromDate,
    this.toDate,
    this.amount,
    this.imageDirFilePath,
  });

  HotelExpenses.fromJson(Map<String, dynamic> json) {
    hotelName = json['hotel_name'];
    fromDate = json['from_date'];
    toDate = json['to_date'];
    amount = json['amount'];
    imageDirFilePath = json['image_dir_file_path'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['hotel_name'] = hotelName;
    data['from_date'] = fromDate;
    data['to_date'] = toDate;
    data['amount'] = amount;
    data['image_dir_file_path'] = imageDirFilePath;
    return data;
  }
}

class OtherExpenses {
  String? otherAmount;
  String? otherDate;
  String? otherDesc;
  String? imageDirFilePath;

  OtherExpenses({
    this.otherAmount,
    this.otherDate,
    this.otherDesc,
    this.imageDirFilePath,
  });

  OtherExpenses.fromJson(Map<String, dynamic> json) {
    otherAmount = json['other_amount'];
    otherDate = json['other_date'];
    otherDesc = json['other_desc'];
    imageDirFilePath = json['image_dir_file_path'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['other_amount'] = otherAmount;
    data['other_date'] = otherDate;
    data['other_desc'] = otherDesc;
    data['image_dir_file_path'] = imageDirFilePath;
    return data;
  }
}
