class paymentRequisitionPaymentsListResponse {
  List<PaymentsList>? paymentsList;
  String? error;
  String? message;

  paymentRequisitionPaymentsListResponse({
    this.paymentsList,
    this.error,
    this.message,
  });

  paymentRequisitionPaymentsListResponse.fromJson(Map<String, dynamic> json) {
    if (json['payments_list'] != null) {
      paymentsList = <PaymentsList>[];
      json['payments_list'].forEach((v) {
        paymentsList!.add(PaymentsList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (paymentsList != null) {
      data['payments_list'] = paymentsList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class PaymentsList {
  String? id;
  String? refType;
  String? amount;
  String? bankName;
  String? bankBranchName;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;
  String? attachmentDirFilePath;
  String? attachmentViewFileName;
  String? description;
  String? paymentReferenceNumber;
  String? paymentDate;
  String? receipientAccount;
  String? payAccount;
  String? requestMode;
  String? createdEmployee;
  String? createdDatetime;
  String? accountId;
  String? paymentAccountId;

  PaymentsList({
    this.id,
    this.refType,
    this.amount,
    this.bankName,
    this.bankBranchName,
    this.bankIfscCode,
    this.bankAccountHolderName,
    this.bankAccountNumber,
    this.bankUpiId,
    this.attachmentDirFilePath,
    this.attachmentViewFileName,
    this.description,
    this.paymentReferenceNumber,
    this.paymentDate,
    this.receipientAccount,
    this.payAccount,
    this.requestMode,
    this.createdEmployee,
    this.createdDatetime,
    this.accountId,
    this.paymentAccountId,
  });

  PaymentsList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    refType = json['ref_type'];
    amount = json['amount'];
    bankName = json['bank_name'];
    bankBranchName = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
    attachmentDirFilePath = json['attachment_dir_file_path'];
    attachmentViewFileName = json['attachment_view_file_name'];
    description = json['description'];
    paymentReferenceNumber = json['payment_reference_number'];
    paymentDate = json['payment_date'];
    receipientAccount = json['receipient_account'];
    payAccount = json['pay_account'];
    requestMode = json['request_mode'];
    createdEmployee = json['created_employee'];
    createdDatetime = json['created_datetime'];
    accountId = json['account_id'];
    paymentAccountId = json['payment_account_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['ref_type'] = refType;
    data['amount'] = amount;
    data['bank_name'] = bankName;
    data['bank_branch_name'] = bankBranchName;
    data['bank_ifsc_code'] = bankIfscCode;
    data['bank_account_holder_name'] = bankAccountHolderName;
    data['bank_account_number'] = bankAccountNumber;
    data['bank_upi_id'] = bankUpiId;
    data['attachment_dir_file_path'] = attachmentDirFilePath;
    data['attachment_view_file_name'] = attachmentViewFileName;
    data['description'] = description;
    data['payment_reference_number'] = paymentReferenceNumber;
    data['payment_date'] = paymentDate;
    data['receipient_account'] = receipientAccount;
    data['pay_account'] = payAccount;
    data['request_mode'] = requestMode;
    data['created_employee'] = createdEmployee;
    data['created_datetime'] = createdDatetime;
    data['account_id'] = accountId;
    data['payment_account_id'] = paymentAccountId;
    return data;
  }
}
