class crmDashboardResponse {
  Hotleads? hotleads;
  Hotleads? pendingTasks;
  Hotleads? coldleads;
  Hotleads? warmleads;
  Hotleads? totalleads;
  Hotleads? openleads;
  Hotleads? visits;
  Hotleads? calls;
  Hotleads? quote;
  Hotleads? orderlost;
  Hotleads? norequirement;
  Hotleads? openEnquiries;
  List<NearbyLeads>? nearbyLeads;
  String? error;
  String? message;
  int? sessionExists;

  crmDashboardResponse({
    this.hotleads,
    this.pendingTasks,
    this.coldleads,
    this.warmleads,
    this.totalleads,
    this.openleads,
    this.visits,
    this.calls,
    this.quote,
    this.orderlost,
    this.norequirement,
    this.openEnquiries,
    this.nearbyLeads,
    this.error,
    this.message,
    this.sessionExists,
  });

  crmDashboardResponse.fromJson(Map<String, dynamic> json) {
    hotleads =
        json['hotleads'] != null ? Hotleads.fromJson(json['hotleads']) : null;
    pendingTasks =
        json['pending_tasks'] != null
            ? Hotleads.fromJson(json['pending_tasks'])
            : null;
    coldleads =
        json['coldleads'] != null ? Hotleads.fromJson(json['coldleads']) : null;
    warmleads =
        json['warmleads'] != null ? Hotleads.fromJson(json['warmleads']) : null;
    totalleads =
        json['totalleads'] != null
            ? Hotleads.fromJson(json['totalleads'])
            : null;
    openleads =
        json['openleads'] != null ? Hotleads.fromJson(json['openleads']) : null;
    visits = json['visits'] != null ? Hotleads.fromJson(json['visits']) : null;
    calls = json['calls'] != null ? Hotleads.fromJson(json['calls']) : null;
    quote = json['quote'] != null ? Hotleads.fromJson(json['quote']) : null;
    orderlost =
        json['orderlost'] != null ? Hotleads.fromJson(json['orderlost']) : null;
    norequirement =
        json['norequirement'] != null
            ? Hotleads.fromJson(json['norequirement'])
            : null;
    openEnquiries =
        json['open_enquiries'] != null
            ? Hotleads.fromJson(json['open_enquiries'])
            : null;
    if (json['nearby_leads'] != null) {
      nearbyLeads = <NearbyLeads>[];
      json['nearby_leads'].forEach((v) {
        nearbyLeads!.add(NearbyLeads.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (hotleads != null) {
      data['hotleads'] = hotleads!.toJson();
    }
    if (pendingTasks != null) {
      data['pending_tasks'] = pendingTasks!.toJson();
    }
    if (coldleads != null) {
      data['coldleads'] = coldleads!.toJson();
    }
    if (warmleads != null) {
      data['warmleads'] = warmleads!.toJson();
    }
    if (totalleads != null) {
      data['totalleads'] = totalleads!.toJson();
    }
    if (openleads != null) {
      data['openleads'] = openleads!.toJson();
    }
    if (visits != null) {
      data['visits'] = visits!.toJson();
    }
    if (calls != null) {
      data['calls'] = calls!.toJson();
    }
    if (quote != null) {
      data['quote'] = quote!.toJson();
    }
    if (orderlost != null) {
      data['orderlost'] = orderlost!.toJson();
    }
    if (norequirement != null) {
      data['norequirement'] = norequirement!.toJson();
    }
    if (openEnquiries != null) {
      data['open_enquiries'] = openEnquiries!.toJson();
    }
    if (nearbyLeads != null) {
      data['nearby_leads'] = nearbyLeads!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Hotleads {
  String? count;
  Filter? filter;

  Hotleads({this.count, this.filter});

  Hotleads.fromJson(Map<String, dynamic> json) {
    count = json['count'];
    filter = json['filter'] != null ? Filter.fromJson(json['filter']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['count'] = count;
    if (filter != null) {
      data['filter'] = filter!.toJson();
    }
    return data;
  }
}

class Filter {
  String? id;
  String? pageName;
  String? mode;
  String? openStatus;
  String? status;

  Filter({this.id, this.pageName, this.mode, this.openStatus, this.status});

  Filter.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    pageName = json['page_name'];
    mode = json['mode'];
    openStatus = json['open_status'];
    status = json['status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['page_name'] = pageName;
    data['mode'] = mode;
    data['open_status'] = openStatus;
    data['status'] = status;
    return data;
  }
}

class NearbyLeads {
  String? id;
  String? ownerId;
  String? accId;
  String? accManagerId;
  String? status;
  String? openStatus;
  String? date;
  String? closeDate;
  String? closereason;
  String? competitor;
  String? orderGainId;
  String? loc;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? followupFunction;
  String? name;
  String? product;
  String? contName;
  String? address;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? distance;

  NearbyLeads({
    this.id,
    this.ownerId,
    this.accId,
    this.accManagerId,
    this.status,
    this.openStatus,
    this.date,
    this.closeDate,
    this.closereason,
    this.competitor,
    this.orderGainId,
    this.loc,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.followupFunction,
    this.name,
    this.product,
    this.contName,
    this.address,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.distance,
  });

  NearbyLeads.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    ownerId = json['owner_id'];
    accId = json['acc_id'];
    accManagerId = json['acc_manager_id'];
    status = json['status'];
    openStatus = json['open_status'];
    date = json['date'];
    closeDate = json['close_date'];
    closereason = json['closereason'];
    competitor = json['competitor'];
    orderGainId = json['order_gain_id'];
    loc = json['loc'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    followupFunction = json['followup_function'];
    name = json['name'];
    product = json['product'];
    contName = json['cont_name'];
    address = json['address'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    distance = json['distance'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['owner_id'] = ownerId;
    data['acc_id'] = accId;
    data['acc_manager_id'] = accManagerId;
    data['status'] = status;
    data['open_status'] = openStatus;
    data['date'] = date;
    data['close_date'] = closeDate;
    data['closereason'] = closereason;
    data['competitor'] = competitor;
    data['order_gain_id'] = orderGainId;
    data['loc'] = loc;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['followup_function'] = followupFunction;
    data['name'] = name;
    data['product'] = product;
    data['cont_name'] = contName;
    data['address'] = address;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['distance'] = distance;
    return data;
  }
}
