class crmDashboardQuotationResponse {
  String? error;
  List<QuotationLists>? quotationLists;
  String? message;
  int? sessionExists;

  crmDashboardQuotationResponse({
    this.error,
    this.quotationLists,
    this.message,
    this.sessionExists,
  });

  crmDashboardQuotationResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['quotation_lists'] != null) {
      quotationLists = <QuotationLists>[];
      json['quotation_lists'].forEach((v) {
        quotationLists!.add(QuotationLists.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (quotationLists != null) {
      data['quotation_lists'] = quotationLists!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class QuotationLists {
  String? aname;
  String? leadid;
  String? lstatus;
  String? lempid;
  String? quotationId;

  QuotationLists({
    this.aname,
    this.leadid,
    this.lstatus,
    this.lempid,
    this.quotationId,
  });

  QuotationLists.fromJson(Map<String, dynamic> json) {
    aname = json['aname'];
    leadid = json['leadid'];
    lstatus = json['lstatus'];
    lempid = json['lempid'];
    quotationId = json['quotation_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['aname'] = aname;
    data['leadid'] = leadid;
    data['lstatus'] = lstatus;
    data['lempid'] = lempid;
    data['quotation_id'] = quotationId;
    return data;
  }
}
