import 'dart:io';

import 'package:flutter/material.dart';
import 'package:generp/screens/notifierExports.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:provider/provider.dart';
import 'package:qr_code_scanner/qr_code_scanner.dart';

import '../../Utils/app_colors.dart';

class Scancomplaintdetails extends StatefulWidget {
  const Scancomplaintdetails({super.key});

  @override
  State<Scancomplaintdetails> createState() => _ScancomplaintdetailsState();
}

class _ScancomplaintdetailsState extends State<Scancomplaintdetails> {
  FocusNode partIDfocusNode = FocusNode();
  TextEditingController partIDcontroller = TextEditingController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var inventoryProvider = Provider.of<InventoryProvider>(
        context,
        listen: false,
      );
      inventoryProvider.checkPermission1();
      inventoryProvider.requestCameraPermission();
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<InventoryProvider>(
      builder: (context, provider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              backgroundColor: AppColors.scaffold_bg_color,
              appBar: appbar(context, "Pending Complaints"),
              body: Container(
                decoration: BoxDecoration(color: Colors.black),
                child: Column(
                  children: [
                    Spacer(),
                    SizedBox(
                      height: 250,

                      child: QRView(
                        key: provider.scannerKey,
                        onQRViewCreated: (p0) {
                          provider.onQRViewCreated(
                            p0,
                            "pendingComplaints",
                            context,
                          );
                        },
                        formatsAllowed: [BarcodeFormat.qrcode],
                        cameraFacing: CameraFacing.back,

                        overlay: QrScannerOverlayShape(
                          borderColor: AppColors.app_blue,
                          borderRadius: 20,
                          borderLength: 60,
                          borderWidth: 10,
                          cutOutSize: 250.0,
                        ),
                      ),
                    ),
                    SizedBox(height: 25),
                    Text(
                      "Scan QR",
                      textAlign: TextAlign.center,
                      style: TextStyle(fontSize: 18, color: Colors.white),
                    ),
                    Text(
                      "to open Complaints",
                      textAlign: TextAlign.center,
                      style: TextStyle(fontSize: 14, color: Colors.white),
                    ),
                    Spacer(),
                    Text(
                      "or",
                      textAlign: TextAlign.center,
                      style: TextStyle(fontSize: 18, color: Colors.white),
                    ),
                    InkResponse(
                      onTap: () async {
                        _showPartIdBottomSheet(context);
                      },
                      child: Text(
                        "Tap To Enter Generator ID",
                        textAlign: TextAlign.center,
                        style: TextStyle(fontSize: 14, color: Colors.white),
                      ),
                    ),
                    SizedBox(height: 50),
                  ],
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showPartIdBottomSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      useRootNavigator: true,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Padding(
                padding: EdgeInsets.only(
                  bottom:
                      MediaQuery.of(
                        context,
                      ).viewInsets.bottom, // This handles keyboard
                ),
                child: Container(
                  margin: EdgeInsets.only(
                    bottom: 15,
                    left: 15,
                    right: 15,
                    top: 30,
                  ),

                  child: Consumer2<InventoryProvider, HomescreenNotifier>(
                    builder: (context, provider, homeProvider, child) {
                      return SingleChildScrollView(
                        child: Column(
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(horizontal: 10),
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Generator ID",
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                              ),
                            ),
                            SizedBox(height: 5),
                            Container(
                              height: 48,
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                color: AppColors.text_field_color,
                                borderRadius: BorderRadius.circular(20),
                                border:
                                    partIDfocusNode.hasFocus
                                        ? Border.all(
                                          color: AppColors.app_blue,
                                          width: 0.5,
                                        )
                                        : null,
                              ),
                              //  alignment: Alignment.center,
                              margin: EdgeInsets.only(left: 5.0, right: 5.0),
                              child: Padding(
                                padding: const EdgeInsets.fromLTRB(
                                  10.0,
                                  0.0,
                                  15,
                                  0,
                                ),
                                child: TextField(
                                  controller: partIDcontroller,
                                  keyboardType: TextInputType.emailAddress,
                                  focusNode: partIDfocusNode,
                                  textCapitalization:
                                      TextCapitalization.characters,

                                  style: TextStyle(fontSize: 14),
                                  onChanged: (value) {},
                                  onTapOutside: (event) {
                                    // Handle onTapOutside
                                    FocusScope.of(context).unfocus();
                                  },
                                  decoration: InputDecoration(
                                    isDense: true,
                                    hintStyle: TextStyle(
                                      fontWeight: FontWeight.w400,
                                      fontSize: 14,
                                    ),
                                    //contentPadding: EdgeInsets.fromLTRB(5.0, 10.0, 5.0, 10.0),
                                    enabledBorder: InputBorder.none,
                                    focusedBorder: InputBorder.none,
                                    hintText: 'Enter Generator ID',
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                provider.LoadgeneratorComplaintHistoryApifunction(
                                  homeProvider,
                                  context,
                                  "pendingComplaints",
                                  partIDcontroller.text,
                                );
                              },
                              child: Container(
                                alignment: Alignment.center,
                                height: 45,
                                margin: EdgeInsets.only(
                                  left: 5.0,
                                  right: 5.0,
                                  top: 5.0,
                                  bottom: 5.0,
                                ),
                                decoration: BoxDecoration(
                                  color: AppColors.app_blue, //1487C9
                                  borderRadius: BorderRadius.circular(15.0),
                                ),
                                child: Center(
                                  child: Text(
                                    "Submit",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(color: Colors.white),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      );
                    },
                  ),
                ),
              ),
            );
          },
        );
      },
    );
  }
}
