import 'package:flutter/material.dart';

class OrganizationStructureScreen extends StatelessWidget {
  final List<Department> departments = [
    Department(
      name: "Engineering",
      teams: [
        Team(name: "Mobile Team", members: ["Mohit", "Srinivas"]),
        Team(name: "Backend Team", members: ["Dheeraj", "Satya", "Sneha"]),
      ],
    ),
    Department(
      name: "Sales & Marketing",
      teams: [
        Team(name: "Digital Marketing", members: ["Kiran", "Priya"]),
        Team(name: "Field Sales", members: ["Raj", "Anjali"]),
      ],
    ),
    Department(
      name: "HR & Admin",
      teams: [
        Team(name: "Recruitment", members: ["Naresh"]),
        Team(name: "Operations", members: ["Suresh", "Divya"]),
      ],
    ),
  ];

   OrganizationStructureScreen({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text("Organization Structure")),
      body: ListView.builder(
        padding: const EdgeInsets.all(16),
        itemCount: departments.length,
        itemBuilder: (context, deptIndex) {
          final dept = departments[deptIndex];
          return Card(
            margin: const EdgeInsets.only(bottom: 16),
            elevation: 2,
            child: ExpansionTile(
              title: Text(
                "${dept.name} not ready",
                style: const TextStyle(
                  fontSize: 18,
                  fontWeight: FontWeight.bold,
                ),
              ),
              children:
                  dept.teams.map((team) {
                    return Padding(
                      padding: const EdgeInsets.symmetric(
                        horizontal: 16,
                        vertical: 8,
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            team.name,
                            style: const TextStyle(
                              fontSize: 16,
                              fontWeight: FontWeight.w600,
                            ),
                          ),
                          const SizedBox(height: 4),
                          Wrap(
                            spacing: 8,
                            children:
                                team.members.map((member) {
                                  return Chip(
                                    label: Text(member),
                                    backgroundColor: Colors.blue.shade50,
                                  );
                                }).toList(),
                          ),

                          const SizedBox(height: 8),
                        ],
                      ),
                    );
                  }).toList(),
            ),
          );
        },
      ),
    );
  }
}

class Department {
  final String name;
  final List<Team> teams;

  Department({required this.name, required this.teams});
}

class Team {
  final String name;
  final List<String> members;

  Team({required this.name, required this.members});
}
