import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/commom/accountsListDetails.dart';
import 'package:provider/provider.dart';
import '../../Notifiers/financeProvider/paymentReceiptsProvider.dart';
import '../../Utils/commonServices.dart';
import 'FileViewer.dart';

class Paymentreceiptdetails extends StatefulWidget {
  final paymentRequestId;
  final pageName;

  const Paymentreceiptdetails({
    super.key,
    required this.paymentRequestId,
    required this.pageName,
  });

  @override
  State<Paymentreceiptdetails> createState() => _PaymentreceiptdetailsState();
}

class _PaymentreceiptdetailsState extends State<Paymentreceiptdetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Paymentreceiptsprovider>(
        context,
        listen: false,
      );
      provider.showMoreDetails = false;
      provider.paymentsListDetailsAPI(context, widget.paymentRequestId);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Paymentreceiptsprovider>(
      builder: (context, provider, child) {
        var paymentDet = provider.receiptDetails;

        final headings1 = ["Payment Mode", "Receipt Date"];
        final subHeadings1 = [
          paymentDet.requestMode ?? "-",
          paymentDet.receiptDate ?? "-",
        ];
        final headings2 = [
          "Bank Name",
          "Account Holder Name",
          "Account Number",
          "Branch",
          "IFSC",
          "UPI ID",
        ];
        final subHeadings2 = [
          paymentDet.bankName ?? "-",
          paymentDet.bankAccountHolderName ?? "-",
          paymentDet.bankAccountNumber ?? "-",
          paymentDet.bankBranchName ?? "-",
          paymentDet.bankIfscCode ?? "-",
          paymentDet.bankUpiId ?? "-",
        ];
        final headings3 = ["Note", "Created Employee"];
        final subHeadings3 = [
          paymentDet.description ?? "-",
          paymentDet.createdEmployee ?? "-",
        ];

        final sections = [
          {
            "title": "Receipt Details",
            "headings": headings1,
            "subHeadings": subHeadings1,
          },
          if (provider.showMoreDetails) ...[
            {
              "title": "Bank Details",
              "headings": headings2,
              "subHeadings": subHeadings2,
            },
            {
              "title": "Other Details",
              "headings": headings3,
              "subHeadings": subHeadings3,
            },
          ],
        ];
        return Scaffold(
          resizeToAvoidBottomInset: true,
          //widget.pageName
          appBar: appbarNew(context, "Payment Receipt Details", 0xFFFFFFFF),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Card(
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.only(
                  bottomLeft: Radius.circular(30),
                  bottomRight: Radius.circular(30),
                ),
              ),
              elevation: 2,
              child: Container(
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.only(
                    bottomLeft: Radius.circular(30),
                    bottomRight: Radius.circular(30),
                  ),
                ),
                // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                child: Column(
                  children: [
                    Row(
                      children: [
                        Expanded(
                          flex: 1,
                          child: Container(
                            height: 45,
                            width: 45,
                            padding: EdgeInsets.all(7.5),
                            decoration: BoxDecoration(
                              color: Color(0xFFE6F6FF),
                              shape: BoxShape.circle,
                              // borderRadius: BorderRadius.circular(8),
                            ),
                            child: SvgPicture.asset("assets/svg/fin_ic.svg"),
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          flex: 8,
                          child: SizedBox(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                InkResponse(
                                  onTap: () {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Accountslistdetails(
                                              accountID:
                                                  provider
                                                      .receiptDetails
                                                      .accountId,
                                            ),
                                      ),
                                    );
                                  },
                                  child: Padding(
                                    padding: const EdgeInsets.symmetric(
                                      vertical: 6,
                                    ),
                                    child: Text(
                                      paymentDet.receipientAccount ?? "-",
                                      style: TextStyle(
                                        decoration: TextDecoration.underline,
                                        decorationColor: AppColors.grey_thick,
                                        decorationStyle:
                                            TextDecorationStyle.dotted,
                                        height: 1.5,
                                        fontFamily: "JakartaRegular",
                                        fontSize: 14,
                                        color: AppColors.semi_black,
                                      ),
                                    ),
                                  ),
                                ),
                                Text(
                                  "₹${paymentDet.amount}",
                                  style: TextStyle(
                                    fontFamily: "JakartaRegular",
                                    fontSize: 14,
                                    color: AppColors.grey_semi,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    Column(
                      children: List.generate(sections.length, (sectionIndex) {
                        final section = sections[sectionIndex];
                        final title = section["title"] as String;
                        final headings = section["headings"] as List<String>;
                        final subHeadings =
                            section["subHeadings"] as List<String>;

                        return Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(vertical: 4),
                              child: Row(
                                children: [
                                  Expanded(
                                    flex: 3,
                                    child: Text(
                                      title,
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaSemiBold",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 6,
                                    child: DottedLine(
                                      dashGapLength: 4,
                                      dashGapColor: Colors.white,
                                      dashColor: AppColors.grey_semi,
                                      dashLength: 2,
                                      lineThickness: 0.5,
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Column(
                              children: List.generate(headings.length, (j) {
                                return Container(
                                  padding: EdgeInsets.symmetric(vertical: 7),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: Text(
                                          headings[j],
                                          style: TextStyle(
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        child: Text(
                                          subHeadings[j].isEmpty
                                              ? "-"
                                              : subHeadings[j],
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(0xFF818181),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              }),
                            ),
                          ],
                        );
                      }),
                    ),

                    InkResponse(
                      onTap: () async {
                        provider.showMoreDetails = !provider.showMoreDetails;
                      },
                      child: Container(
                        padding: EdgeInsets.symmetric(vertical: 5),
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            Text(
                              provider.showMoreDetails
                                  ? "Hide Details"
                                  : "View Details",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                            Transform.flip(
                              flipY: provider.showMoreDetails ? true : false,
                              child: SvgPicture.asset(
                                "assets/svg/arrow_dropdown.svg",
                                height: 25,
                                width: 20,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Paymentreceiptsprovider>(
      builder: (context, provider, child) {
        var paymentDet = provider.receiptDetails;

        return Scaffold(
          resizeToAvoidBottomInset: true,
          //widget.pageName
          appBar: appbar(context, "Payment Receipt Details"),
          backgroundColor: AppColors.scaffold_bg_color,
          body: Container(
            child: SingleChildScrollView(
              child: Container(
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.circular(16),
                ),
                margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                child: Column(
                  children: [
                    Row(
                      children: [
                        Expanded(
                          flex: 1,
                          child: Container(
                            height: 50,
                            width: 35,
                            padding: EdgeInsets.all(8.0),
                            decoration: BoxDecoration(
                              color: Color(0xFFFFF3CE),
                              borderRadius: BorderRadius.circular(8),
                            ),
                            child: SvgPicture.asset("assets/svg/fin_ic.svg"),
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          flex: 4,
                          child: SizedBox(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  paymentDet.receipientAccount ?? "-",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                                Text(
                                  "₹${paymentDet.amount}",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                    ...List.generate(provider.subHeadings.length, (j) {
                      if (provider.Headings[j] == "Attachment" &&
                          paymentDet.attachmentViewFileName == "") {
                        return SizedBox.shrink();
                      }
                      return Container(
                        padding: EdgeInsets.symmetric(vertical: 7),
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Expanded(
                              child: Text(
                                provider.Headings[j],
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  fontSize: 14,
                                  color: AppColors.semi_black,
                                ),
                              ),
                            ),
                            Expanded(
                              child: InkResponse(
                                onTap: () {
                                  if (provider.Headings[j] == "Attachment") {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Fileviewer(
                                              fileName:
                                                  paymentDet
                                                      .attachmentViewFileName!,
                                              fileUrl:
                                                  paymentDet
                                                      .attachmentDirFilePath!,
                                            ),
                                      ),
                                    );
                                  }
                                },
                                child: Text(
                                  provider.Headings[j] == "Attachment"
                                      ? "View"
                                      : provider.subHeadings[j] == ""
                                      ? "-"
                                      : provider.subHeadings[j] ?? "-",
                                  style: TextStyle(
                                    fontSize: 14,
                                    color:
                                        provider.Headings[j] == "Attachment"
                                            ? AppColors.app_blue
                                            : Color(0xFF818181),
                                    decoration:
                                        provider.Headings[j] == "Attachment"
                                            ? TextDecoration.underline
                                            : TextDecoration.none,
                                    decorationColor:
                                        provider.Headings[j] == "Attachment"
                                            ? AppColors.app_blue
                                            : AppColors.white,
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      );
                    }),
                  ],
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
