import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/screens/order/paymentDetailsByMode.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/crmProvider/crmProspectDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class ProspectPaymentDetails extends StatefulWidget {
  final leadID;

  const ProspectPaymentDetails({super.key, required this.leadID});

  @override
  State<ProspectPaymentDetails> createState() => _ProspectPaymentDetailsState();
}

class _ProspectPaymentDetailsState extends State<ProspectPaymentDetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<crmProspectDetailsProvider>(
        context,
        listen: false,
      );
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<crmProspectDetailsProvider>(
      builder: (context, provider, child) {
        var customerDetails = provider.paymentsList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar(context, "Payment Details"),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              customerDetails.isNotEmpty
                  ? SizedBox(
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          // TextWidget(context, "Payment Details"),
                          ListView.builder(
                            itemCount: customerDetails.length,
                            shrinkWrap: true,
                            itemBuilder: (context, index) {
                              return Container(
                                margin: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 5,
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 15,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: List.generate(6, (j) {
                                    final textheads = [
                                      "Mode of Payment",
                                      "Payment Reference",
                                      "Amount",
                                      "Entered By Employee",
                                      "Payment Received Date",
                                      "Action",
                                    ];
                                    final textSubheads = [
                                      customerDetails[index].paymentType ?? "-",
                                      customerDetails[index].refNo ?? "-",
                                      customerDetails[index].amount ?? "-",
                                      customerDetails[index].employeeName ??
                                          "-",
                                      customerDetails[index].paymentDate ?? "-",
                                      "View Details",
                                    ];
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 6,
                                        horizontal: 0,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            flex: 2,
                                            child: Text(
                                              textheads[j].toString(),
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                          ),
                                          if (textSubheads[j] ==
                                              "View Details") ...[
                                            Expanded(
                                              flex: 3,
                                              child: InkResponse(
                                                onTap: () async {
                                                  var res = await Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (
                                                            context,
                                                          ) => Paymentdetailsbymode(
                                                            mode: "",
                                                            pageTitleName:
                                                                "Payment Details",
                                                            paymentId:
                                                                customerDetails[index]
                                                                    .id,
                                                          ),
                                                    ),
                                                  );
                                                  if (res == true) {
                                                    provider
                                                        .crmProspectDetailsAPIFunction(
                                                          context,
                                                          widget.leadID,
                                                        );
                                                  }
                                                },
                                                child: Text(
                                                  textSubheads[j] == ""
                                                      ? "-"
                                                      : textSubheads[j],
                                                  maxLines: 2,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                  style: TextStyle(
                                                    color: AppColors.app_blue,
                                                    decorationColor:
                                                        AppColors.app_blue,
                                                    decoration:
                                                        TextDecoration
                                                            .underline,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            Expanded(
                                              flex: 3,
                                              child: Text(
                                                textSubheads[j] == ""
                                                    ? "-"
                                                    : textSubheads[j],
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    );
                                  }),
                                ),
                              );
                            },
                          ),

                          SizedBox(height: 75),
                        ],
                      ),
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }
}
