import 'dart:io';

import 'package:flutter/material.dart';
import 'package:generp/screens/crm/generateQuotationScreen.dart';
import 'package:provider/provider.dart';
import '../../Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class QuotationDetails extends StatefulWidget {
  final leadID;
  final mode;
  const QuotationDetails({super.key,required this.leadID,required this.mode});

  @override
  State<QuotationDetails> createState() => _QuotationDetailsState();
}

class _QuotationDetailsState extends State<QuotationDetails> {
  @override
  Widget build(BuildContext context) {
    return Consumer<crmLeadDetailsProvider>(
      builder: (context, provider, child) {
        var quotationDetails = provider.quotationsDetails;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS?false:true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Quotation Details"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: SizedBox(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      // TextWidget(context, "Quotation Details"),
                      ListView.builder(
                        itemCount: quotationDetails.length,
                        shrinkWrap: true,
                        itemBuilder: (context, index) {
                          return Container(
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            padding: EdgeInsets.symmetric(
                              horizontal: 15,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                ...List.generate(5, (j) {
                                  final textheads = [
                                    "Description",
                                    "Employee Name",
                                    "Quotation",
                                    "Info",
                                    "Date",
                                  ];
                                  final textSubheads = [
                                    quotationDetails[index].subject ?? "-",
                                    quotationDetails[index].employee ?? "-",
                                    "View File",
                                    // quotationDetails[index].finTime ?? "-",
                                    quotationDetails[index].info ?? "-",
                                    quotationDetails[index].date ?? "-",
                                  ];
                                  return Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 6,
                                      horizontal: 0,
                                    ),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Text(
                                            textheads[j].toString(),
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                        Expanded(
                                          child: Text(
                                            textSubheads[j],
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                            style: TextStyle(
                                              color:
                                                  textSubheads[j] == "View File"
                                                      ? AppColors.app_blue
                                                      : Color(0xFF818181),
                                              decoration:
                                                  textSubheads[j] == "View File"
                                                      ? TextDecoration.underline
                                                      : TextDecoration.none,
                                              decorationColor:
                                                  AppColors.app_blue,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                              ],
                            ),
                          );
                        },
                      ),
                      SizedBox(height: 150),
                    ],
                  ),
                ),
              ),
              floatingActionButton: Align(
                alignment: Alignment.bottomCenter,
                child: InkWell(
                  onTap: () async {
                    var res = await Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder:
                            (context) =>
                                Generatequotationscreen(leadId: widget.leadID),
                      ),
                    );
                    if(res==true){
                      provider.crmLeadDetailsAPIFunction(context, widget.leadID, widget.mode);
                    }
                  },
                  child: Container(
                    alignment: Alignment.bottomCenter,
                    height: 45,
                    width: MediaQuery.of(context).size.width,
                    margin: EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                      color: AppColors.app_blue,
                      borderRadius: BorderRadius.circular(14.0),
                    ),
                    child: Center(
                      child: Text(
                        "Generate Quotation",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: Colors.white,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),
                  ),
                ),
              ),
              floatingActionButtonLocation:
                  FloatingActionButtonLocation.centerFloat,
            ),
          ),
        );
      },
    );
  }
}
