import 'dart:async';
import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_inappwebview/flutter_inappwebview.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:generp/Utils/commonWidgets.dart';
import '../Utils/commonServices.dart';
import 'JobDescription.dart';
import 'genTracker/ScanEnterGeneratorIDScreen.dart';
import 'hrm/ContactList.dart';
import 'hrm/HrmDashboardScreen.dart';
import 'notifierExports.dart';
import 'screensExports.dart';
import 'package:geolocator/geolocator.dart';
import 'package:provider/provider.dart';
import 'package:cached_network_image/cached_network_image.dart';
import 'package:location/location.dart' as loc;
import '../Utils/app_colors.dart';
import 'inventory/InventoryScreen.dart';
import 'package:auto_size_text/auto_size_text.dart';

class MyHomePage extends StatefulWidget {
  const MyHomePage({super.key});

  @override
  State<MyHomePage> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  Timer? timer;
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    var prov = Provider.of<HomescreenNotifier>(context, listen: false);
    var profProv = Provider.of<ProfileNotifer>(context, listen: false);
    Future.microtask(() {
      prov.DashboardApiFunction(context);
    });
    Future.delayed(Duration(milliseconds: 600), () {
      profProv.ProfileApiFunction(prov, context);
      profProv.VersionApiFunction();
      profProv.fetchMissedCheckoutStrip(prov.empId, prov.session);
    });
    super.initState();
  }

  Future<bool> onBackPressed() async {
    return await showDialog<bool>(
          context: context,
          builder:
              (context) => AlertDialog(
                title: const Text('Are you sure?'),
                content: const Text('Do you want to exit the App'),
                actions: [
                  TextButton(
                    style: ButtonStyle(
                      backgroundColor: WidgetStateProperty.all(Colors.white),
                      overlayColor: WidgetStateProperty.all(Colors.white),
                    ),
                    onPressed: () => Navigator.of(context).pop(false),
                    child: Text(
                      "NO",
                      style: TextStyle(fontWeight: FontWeight.w500),
                    ),
                  ),
                  const SizedBox(height: 16),
                  TextButton(
                    style: ButtonStyle(
                      backgroundColor: WidgetStateProperty.all(Colors.white),
                      overlayColor: WidgetStateProperty.all(Colors.white70),
                    ),
                    onPressed:
                        () => SystemChannels.platform.invokeMethod(
                          'SystemNavigator.pop',
                        ),
                    child: Text(
                      "YES",
                      style: TextStyle(fontWeight: FontWeight.w500),
                    ),
                  ),
                ],
                elevation: 30.0,
              ),
          barrierDismissible: false,
        ) ??
        false;
  }

  Future<void> requestGpsPermission() async {
    bool isLocationEnabled = false;
    bool hasLocationPermission = false;
    isLocationEnabled = await Geolocator.isLocationServiceEnabled();

    // Check if the app has been granted location permission
    LocationPermission permission = await Geolocator.checkPermission();
    hasLocationPermission =
        permission == LocationPermission.always ||
        permission == LocationPermission.whileInUse;

    final loc.Location location = loc.Location();
    bool serviceEnabled;
    serviceEnabled = await location.serviceEnabled();
    if (!serviceEnabled) {
      serviceEnabled = await location.requestService();
      if (!serviceEnabled) {
        return;
      }
    }
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    double screenWidth = MediaQuery.of(context).size.width;
    double screenHeight = MediaQuery.of(context).size.height;
    double bottomPadding = MediaQuery.of(context).padding.bottom;
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == 'Online')
        ? Consumer2<HomescreenNotifier, ProfileNotifer>(
          builder: (context, homescreen, profile, child) {
            final coreRequiredRoles = ["12", "540", "433", "434", "430"];
            final requiredRoles = ["430", "430", "431", "431"];

            final coreNames = [
              "CRM",
              "Orders",
              "Service",
              "Gen Tracker",
              "HRM",
            ];
            final names = ["Attendance", "Finance", "ERP", "Whizzdom"];
            final subtitles = [
              "Check-in,Check-out",
              "Payment Requests, Transactions",
              "Centralized data and reports",
              "Page guidance, Learn to use",
            ];
            final coreIcons = [
              "assets/svg/home/home_crm_ic.svg",
              "assets/svg/home/home_order_ic.svg",
              "assets/svg/home/home_service_ic.svg",
              "assets/svg/home/home_gentracker_ic.svg",
              "assets/svg/home/icd.svg",
            ];
            final icons = [
              "assets/svg/home/home_attendance_ic.svg",
              "assets/svg/home/home_finance_ic.svg",
              "assets/svg/home/home_erp_ic.svg",
              "assets/svg/home/home_whizzdom_ic.svg",
            ];
            final coreSubtitles = [
              "Leads, Followups",
              "Orders, TPC, Dispatch",
              "Visits, P.C. Wallet",
              "Generator Details",
              "Tour Bills, Live Attendance",
            ];
            final coreFilteredItems = <Map<String, String>>[];
            final filteredItems = <Map<String, String>>[];

            for (int j = 0; j < names.length; j++) {
              if (homescreen.roleStatus.contains(requiredRoles[j])) {
                filteredItems.add({
                  'name': names[j],
                  'icon': icons[j],
                  'subtitle': subtitles[j],
                });
              }
            }

            for (int i = 0; i < coreNames.length; i++) {
              if (homescreen.roleStatus.contains(coreRequiredRoles[i])) {
                coreFilteredItems.add({
                  'name': coreNames[i],
                  'icon': coreIcons[i],
                  'subtitle': coreSubtitles[i],
                });
              }
            }

            return WillPopScope(
              onWillPop: onBackPressed,
              child: RefreshIndicator.adaptive(
                color: AppColors.app_blue,

                onRefresh: () async {
                  await Future.delayed(const Duration(milliseconds: 600));
                  homescreen.DashboardApiFunction(context);
                },
                child: SafeArea(
                  top: false,
                  bottom: Platform.isIOS ? false : true,
                  child: Scaffold(
                    resizeToAvoidBottomInset: true,
                    backgroundColor: AppColors.scaffold_bg_color,
                    appBar: AppBar(
                      automaticallyImplyLeading: false,
                      toolbarHeight: 0,
                      backgroundColor: Colors.white,
                    ),
                    body: Container(
                      height: screenHeight,
                      decoration: BoxDecoration(
                        gradient: LinearGradient(
                          colors: [
                            AppColors.scaffold_bg_color,
                            AppColors.scaffold_bg_color,
                            Color(0xFFCEEDFF),
                          ],
                          begin: Alignment.topCenter,
                          end: Alignment.bottomCenter,
                        ),
                      ),
                      child: SingleChildScrollView(
                        child: Column(
                          children: [
                            Stack(
                              children: [
                                // Container(
                                //   height: screenHeight,
                                //   decoration: BoxDecoration(
                                //     gradient: LinearGradient(
                                //       colors: [
                                //         AppColors.scaffold_bg_color,
                                //         AppColors.scaffold_bg_color,
                                //         Color(0xFFCEEDFF),
                                //       ],
                                //       begin: Alignment.topCenter,
                                //       end: Alignment.bottomCenter,
                                //     ),
                                //   ),
                                // ),

                                Column(
                                  mainAxisSize: MainAxisSize.min,
                                  children: [
                                    Stack(
                                      clipBehavior: Clip.none,
                                      children: [
                                        // ---------------- MISSED CHECKOUT STRIP BACKGROUND ----------------
                                        if (profile.missedCheckoutData?.error == "0")
                                          Container(
                                            height: 214, // Taller than the profile card
                                            decoration: BoxDecoration(
                                              color: const Color(0xFFFFD9D9),
                                              borderRadius: const BorderRadius.vertical(
                                                bottom: Radius.circular(20),
                                              ),
                                            ),
                                            child: Align(
                                              alignment: Alignment.bottomCenter,
                                              child: Padding(
                                                padding: const EdgeInsets.only(bottom: 10),
                                                child: Row(
                                                  mainAxisAlignment: MainAxisAlignment.center,
                                                  children: [
                                                    SvgPicture.asset(
                                                      "assets/svg/missed_warning_ic.svg",
                                                      height: 20,
                                                    ),
                                                    const SizedBox(width: 8),
                                                    Text(
                                                      profile.missedCheckoutData?.visibleText ?? "",
                                                      style: TextStyle(
                                                        color: Colors.black,
                                                        fontSize: 12,
                                                        fontFamily: "JakartaMedium",
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),
                                          ),

                                        // ---------------- PROFILE CARD (FRONT) ----------------
                                        InkResponse(
                                          onTap: () {
                                            HapticFeedback.selectionClick();
                                            _showProfileBottomSheet(context);
                                          },
                                          child: Container(
                                            // padding: EdgeInsets.symmetric(vertical: 5),
                                            decoration: BoxDecoration(
                                              color: Colors.white,
                                              borderRadius: BorderRadius.vertical(
                                                bottom: Radius.circular(30),
                                              ),
                                            ),
                                            child: Container(
                                              margin: EdgeInsets.only(
                                                bottom: 15,
                                                left: 15,
                                                right: 15,
                                                top: 30,
                                              ),
                                              padding: EdgeInsets.only(
                                                bottom: 1,
                                                right: 10,
                                              ),
                                              decoration: BoxDecoration(
                                                borderRadius: BorderRadius.circular(
                                                  20,
                                                ),
                                                gradient: LinearGradient(
                                                  colors: [
                                                    AppColors.profile_card,
                                                    AppColors.profile_card,
                                                  ],
                                                ),
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                                mainAxisAlignment:
                                                MainAxisAlignment.center,
                                                children: [
                                                  Expanded(
                                                    flex: 8,
                                                    child: Padding(
                                                      padding: EdgeInsets.only(
                                                        left: 25,
                                                        top: 15,
                                                        bottom: 15,
                                                      ),
                                                      child: Column(
                                                        mainAxisAlignment:
                                                        MainAxisAlignment
                                                            .center,
                                                        crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,

                                                        children: [
                                                          // Text(
                                                          //   "${profile.employeeName}",
                                                          //   maxLines: 1,
                                                          //   style: TextStyle(
                                                          //     color: AppColors.app_blue,
                                                          //     fontFamily: "JakartaSemiBold",
                                                          //     fontSize: 18,
                                                          //   ),
                                                          // ),
                                                          AutoSizeText(
                                                            '${profile.employeeName}',
                                                            maxFontSize: 16,
                                                            minFontSize: 12,
                                                            style: TextStyle(
                                                              fontSize: 16,
                                                              color:
                                                              AppColors
                                                                  .app_blue,
                                                              fontFamily:
                                                              "JakartaSemiBold",
                                                            ),
                                                            maxLines: 2,
                                                          ),
                                                          AutoSizeText(
                                                            '(${profile.designation})',
                                                            maxFontSize: 14,
                                                            minFontSize: 10,
                                                            style: TextStyle(
                                                              fontSize: 14,
                                                              color:
                                                              AppColors
                                                                  .semi_black,
                                                              fontFamily:
                                                              "JakartaRegular",
                                                            ),
                                                            maxLines: 1,
                                                          ),
                                                          // Text(
                                                          //   "${profile.designation}",
                                                          //   maxLines: 1,
                                                          //   style: TextStyle(
                                                          //     color: AppColors.semi_black,
                                                          //     fontFamily: "JakartaRegular",
                                                          //     fontSize: 14,
                                                          //   ),
                                                          // ),
                                                          Text(
                                                            "${profile.employeeeID}",
                                                            style: TextStyle(
                                                              color:
                                                              AppColors
                                                                  .semi_black,
                                                              fontFamily:
                                                              "JakartaRegular",
                                                              fontSize: 14,
                                                            ),
                                                          ),
                                                          SizedBox(height: 12),
                                                          Row(
                                                            mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .start,
                                                            children: [
                                                              Container(
                                                                width: 12,
                                                                height: 12,
                                                                decoration: BoxDecoration(
                                                                  shape:
                                                                  BoxShape
                                                                      .circle,
                                                                  color:
                                                                  homescreen.onlineStatus ==
                                                                      "Online"
                                                                      ? AppColors
                                                                      .approved_text_color
                                                                      : AppColors
                                                                      .rejected_text_color,
                                                                ),
                                                              ),
                                                              SizedBox(width: 6),
                                                              Text(
                                                                "${homescreen.onlineStatus}",
                                                                style: TextStyle(
                                                                  fontSize: 14,
                                                                  fontFamily:
                                                                  "JakartaRegular",
                                                                  color: Color(
                                                                    0xFF2D2D2D,
                                                                  ),
                                                                ),
                                                              ),
                                                            ],
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                  Spacer(),
                                                  Expanded(
                                                    flex: 2,
                                                    child: Container(
                                                      padding: EdgeInsets.symmetric(
                                                        vertical: 15,
                                                      ),
                                                      child: Column(
                                                        crossAxisAlignment:
                                                        CrossAxisAlignment
                                                            .start,
                                                        mainAxisAlignment:
                                                        MainAxisAlignment
                                                            .center,
                                                        children: [
                                                          SizedBox(
                                                            width: 60,
                                                            height: 60,
                                                            child: ClipRRect(
                                                              borderRadius:
                                                              BorderRadius.circular(
                                                                50,
                                                              ),
                                                              child: CachedNetworkImage(
                                                                cacheKey:
                                                                profile
                                                                    .profileImage,
                                                                fit: BoxFit.cover,
                                                                imageUrl:
                                                                "${profile.profileImage}",
                                                                useOldImageOnUrlChange:
                                                                false,
                                                                placeholder:
                                                                    (
                                                                    context,
                                                                    url,
                                                                    ) =>
                                                                    CircularProgressIndicator.adaptive(),
                                                                errorWidget:
                                                                    (
                                                                    context,
                                                                    url,
                                                                    error,
                                                                    ) => Icon(
                                                                  Icons.error,
                                                                ),
                                                              ),
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),

                                    SizedBox(
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          // if (coreFilteredItems.isNotEmpty) ...[
                                          //   Container(
                                          //     padding: const EdgeInsets.only(
                                          //       top: 10,
                                          //       bottom: 5,
                                          //     ),
                                          //     margin: EdgeInsets.symmetric(
                                          //       horizontal: 10,
                                          //     ),
                                          //     child: Text(
                                          //       "Core Functionalities",
                                          //       style: TextStyle(
                                          //         color: AppColors.grey_thick,
                                          //         fontSize: 14,
                                          //         fontFamily: "JakartaMedium",
                                          //       ),
                                          //     ),
                                          //   ),
                                          //   Container(
                                          //     padding: EdgeInsets.symmetric(
                                          //       vertical: 10,
                                          //       horizontal: 15,
                                          //     ),
                                          //     margin: EdgeInsets.symmetric(
                                          //       horizontal: 10,
                                          //     ),
                                          //     decoration: BoxDecoration(
                                          //       color: Colors.white,
                                          //       borderRadius: BorderRadius.circular(14),
                                          //     ),
                                          //     child: Row(
                                          //       mainAxisAlignment:
                                          //       MainAxisAlignment.center,
                                          //       children: List.generate(4, (ic) {
                                          //         return Expanded(
                                          //           child: InkResponse(
                                          //             onTap: () async {
                                          //               var res;
                                          //               switch (coreFilteredItems[ic]['name']) {
                                          //                 case "Gen Tracker":
                                          //                   res = await Navigator.push(
                                          //                     context,
                                          //                     MaterialPageRoute(
                                          //                       builder:
                                          //                           (context) =>
                                          //                           Gentrackerdashboard(),
                                          //                       settings: RouteSettings(
                                          //                         arguments:
                                          //                         'Gentrackerdashboard',
                                          //                       ),
                                          //                     ),
                                          //                   );
                                          //                   break;
                                          //                 case "Service":
                                          //                   res = await Navigator.push(
                                          //                     context,
                                          //                     MaterialPageRoute(
                                          //                       builder:
                                          //                           (context) =>
                                          //                           Serviceengineerdashboard(),
                                          //                     ),
                                          //                   );
                                          //                   break;
                                          //                 case "Orders":
                                          //                   res = await Navigator.push(
                                          //                     context,
                                          //                     MaterialPageRoute(
                                          //                       builder:
                                          //                           (context) =>
                                          //                           Ordermoduledashboard(),
                                          //                     ),
                                          //                   );
                                          //                 case "CRM":
                                          //                   res = await Navigator.push(
                                          //                     context,
                                          //                     MaterialPageRoute(
                                          //                       builder:
                                          //                           (context) =>
                                          //                           CrmdashboardScreen(),
                                          //                       settings: RouteSettings(
                                          //                         name:
                                          //                         'CrmdashboardScreen',
                                          //                       ),
                                          //                     ),
                                          //                   );
                                          //                 default:
                                          //                   print("111");
                                          //                   break;
                                          //               }
                                          //               if (res == true) {
                                          //                 homescreen.DashboardApiFunction(
                                          //                   context,
                                          //                 );
                                          //               }
                                          //             },
                                          //             child: SizedBox(
                                          //               child: Column(
                                          //                 crossAxisAlignment:
                                          //                 CrossAxisAlignment.center,
                                          //                 mainAxisAlignment:
                                          //                 MainAxisAlignment.center,
                                          //                 children: [
                                          //                   SvgPicture.asset(
                                          //                     coreFilteredItems[ic]['icon'] ??
                                          //                         "-",
                                          //                   ),
                                          //                   SizedBox(height: 10),
                                          //                   Text(
                                          //                     coreFilteredItems[ic]['name'] ??
                                          //                         "-",
                                          //                     maxLines: 2,
                                          //                     textAlign:
                                          //                     TextAlign.center,
                                          //                     style: TextStyle(
                                          //                       fontSize: 12,
                                          //                       fontFamily:
                                          //                       "JakartaMedium",
                                          //                     ),
                                          //                   ),
                                          //                 ],
                                          //               ),
                                          //             ),
                                          //           ),
                                          //         );
                                          //       }),
                                          //     ),
                                          //   ),
                                          // ],
                                          if (homescreen.roleStatus.contains(
                                            "432",
                                          )) ...[
                                            if (filteredItems.isNotEmpty) ...[
                                              Container(
                                                padding: const EdgeInsets.only(
                                                  top: 10,
                                                  bottom: 5,
                                                ),
                                                margin: EdgeInsets.only(
                                                  left: 10,
                                                  bottom: 5,
                                                  top: 10,
                                                ),
                                                child: Text(
                                                  "Workforce & Operations",
                                                  style: TextStyle(
                                                    color: AppColors.grey_thick,
                                                    fontSize: 14,
                                                    fontFamily: "JakartaMedium",
                                                  ),
                                                ),
                                              ),

                                              Container(
                                                padding: EdgeInsets.symmetric(
                                                  vertical: 15,
                                                  horizontal: 15,
                                                ),
                                                margin: EdgeInsets.symmetric(
                                                  horizontal: 10,
                                                ),
                                                decoration: BoxDecoration(
                                                  color: Colors.white,
                                                  borderRadius:
                                                      BorderRadius.circular(14),
                                                ),
                                                child: Row(
                                                  mainAxisAlignment:
                                                      MainAxisAlignment.center,
                                                  children: List.generate(4, (
                                                    ic,
                                                  ) {
                                                    return Expanded(
                                                      child: InkResponse(
                                                        onTap: () async {
                                                          HapticFeedback.selectionClick();
                                                          var res;
                                                          switch (filteredItems[ic]['name']) {
                                                            case "Attendance":
                                                              res = await Navigator.push(
                                                                context,
                                                                MaterialPageRoute(
                                                                  builder:
                                                                      (
                                                                        context,
                                                                      ) =>
                                                                          AttendanceScreen(),
                                                                  settings: RouteSettings(
                                                                    arguments:
                                                                        'AttendanceScreen',
                                                                  ),
                                                                ),
                                                              );
                                                              break;
                                                            case "ERP":
                                                              bool
                                                              isGpsEnabled =
                                                                  await Geolocator.isLocationServiceEnabled();
                                                              if (isGpsEnabled) {
                                                                if (Platform
                                                                    .isAndroid) {
                                                                  res = await Navigator.push(
                                                                    context,
                                                                    MaterialPageRoute(
                                                                      builder:
                                                                          (
                                                                            context,
                                                                          ) => WebErpScreen(
                                                                            erp_url:
                                                                                homescreen.webPageUrl,
                                                                          ),
                                                                    ),
                                                                  );
                                                                } else {
                                                                  res = await Navigator.push(
                                                                    context,
                                                                    MaterialPageRoute(
                                                                      builder:
                                                                          (
                                                                            context,
                                                                          ) => WebERPIOS(
                                                                            url:
                                                                                homescreen.webPageUrl,
                                                                          ),
                                                                    ),
                                                                  );
                                                                }
                                                              } else {
                                                                requestGpsPermission();
                                                              }
                                                              break;
                                                            case "Whizzdom":
                                                              bool
                                                              isGpsEnabled =
                                                                  await Geolocator.isLocationServiceEnabled();
                                                              if (isGpsEnabled) {
                                                                res = await Navigator.push(
                                                                  context,
                                                                  MaterialPageRoute(
                                                                    builder:
                                                                        (
                                                                          context,
                                                                        ) => WebWhizzdomScreen(
                                                                          whizzdom_url:
                                                                              homescreen.whizzdomPageUrl,
                                                                        ),
                                                                  ),
                                                                );
                                                              } else {
                                                                requestGpsPermission();
                                                              }
                                                              break;
                                                            case "Finance":
                                                              res = await Navigator.push(
                                                                context,
                                                                MaterialPageRoute(
                                                                  builder:
                                                                      (
                                                                        context,
                                                                      ) =>
                                                                          Financedashboard(),
                                                                  settings: RouteSettings(
                                                                    arguments:
                                                                        'Financedashboard',
                                                                  ),
                                                                ),
                                                              );
                                                              break;
                                                            default:
                                                              print("111");
                                                              break;
                                                          }
                                                          if (res == true) {
                                                            homescreen.DashboardApiFunction(
                                                              context,
                                                            );
                                                          }
                                                        },
                                                        child: SizedBox(
                                                          child: Column(
                                                            crossAxisAlignment:
                                                                CrossAxisAlignment
                                                                    .center,
                                                            mainAxisAlignment:
                                                                MainAxisAlignment
                                                                    .center,
                                                            children: [
                                                              SvgPicture.asset(
                                                                filteredItems[ic]['icon'] ??
                                                                    "-",
                                                              ),
                                                              SizedBox(
                                                                height: 10,
                                                              ),
                                                              Text(
                                                                filteredItems[ic]['name'] ??
                                                                    "-",
                                                                maxLines: 2,
                                                                textAlign:
                                                                    TextAlign
                                                                        .center,
                                                                style: TextStyle(
                                                                  fontSize: 12,
                                                                  fontFamily:
                                                                      "JakartaMedium",
                                                                ),
                                                              ),
                                                            ],
                                                          ),
                                                        ),
                                                      ),
                                                    );
                                                  }),
                                                ),
                                              ),
                                            ],

                                            SizedBox(height: 16,),
                                            // Emp contact list
                                            InkResponse(
                                              onTap: () async {
                                                HapticFeedback.selectionClick();
                                                var res = await Navigator.push(
                                                  context,
                                                  MaterialPageRoute(
                                                    builder:
                                                        (context) =>
                                                        ContactListScreen(),
                                                  ),
                                                );
                                                if (res == true) {
                                                  homescreen.DashboardApiFunction(
                                                    context,
                                                  );
                                                }
                                              },
                                              child: Container(
                                                margin: EdgeInsets.symmetric(
                                                  horizontal: 10,
                                                ),
                                                padding: EdgeInsets.symmetric(
                                                  vertical: 15,
                                                  horizontal: 15,
                                                ),
                                                decoration: BoxDecoration(
                                                  color: Colors.white,
                                                  borderRadius:
                                                  BorderRadius.circular(14),
                                                ),
                                                child: Row(
                                                  mainAxisAlignment:
                                                  MainAxisAlignment.center,
                                                  children: [
                                                    Expanded(
                                                      flex: 1,
                                                      child: Container(
                                                        height: 42,
                                                        width: 42,
                                                        decoration: BoxDecoration(
                                                          shape: BoxShape.circle,
                                                          color: const Color(0xFFEDF8FF),
                                                        ),
                                                        child: Center(
                                                          child: SvgPicture.asset(
                                                            "assets/svg/hrm/emp_contact_list.svg",
                                                            color: Color(0xFF1487C9),
                                                            height: 24,
                                                            width: 24,
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                    SizedBox(width: 10),
                                                    Expanded(
                                                      flex: 5,
                                                      child: SizedBox(
                                                        child: Column(
                                                          crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .start,
                                                          children: [
                                                            Text(
                                                              "Employee Contacts",
                                                              style: TextStyle(
                                                                fontSize: 14,
                                                                color:
                                                                AppColors
                                                                    .app_blue,
                                                                fontFamily:
                                                                "JakartaMedium",
                                                              ),
                                                            ),
                                                            Text(
                                                              "Contact Details, Whatsapp",
                                                              style: TextStyle(
                                                                fontSize: 14,
                                                                color:
                                                                AppColors
                                                                    .grey_semi,
                                                                fontFamily:
                                                                "JakartaMedium",
                                                              ),
                                                            ),
                                                          ],
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),
                                            SizedBox(height: 4,),


                                            Container(
                                              margin: EdgeInsets.only(
                                                left: 10,
                                                bottom: 5,
                                                top: 10,
                                              ),
                                              padding: const EdgeInsets.only(
                                                top: 10,
                                                bottom: 5,
                                              ),
                                              child: Text(
                                                "Inventory Management",
                                                style: TextStyle(
                                                  color: AppColors.grey_thick,
                                                  fontSize: 14,
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                            ),
                                            InkResponse(
                                              onTap: () async {
                                                HapticFeedback.selectionClick();
                                                var res = await Navigator.push(
                                                  context,
                                                  MaterialPageRoute(
                                                    builder:
                                                        (context) =>
                                                            InventoryScreen(),
                                                  ),
                                                );
                                                if (res == true) {
                                                  homescreen.DashboardApiFunction(
                                                    context,
                                                  );
                                                }
                                              },
                                              child: Container(
                                                margin: EdgeInsets.symmetric(
                                                  horizontal: 10,
                                                ),
                                                padding: EdgeInsets.symmetric(
                                                  vertical: 15,
                                                  horizontal: 15,
                                                ),
                                                decoration: BoxDecoration(
                                                  color: Colors.white,
                                                  borderRadius:
                                                      BorderRadius.circular(14),
                                                ),
                                                child: Row(
                                                  mainAxisAlignment:
                                                      MainAxisAlignment.center,
                                                  children: [
                                                    Expanded(
                                                      flex: 1,
                                                      child: SvgPicture.asset(
                                                        "assets/svg/home/home_inventory_ic.svg",
                                                      ),
                                                    ),
                                                    SizedBox(width: 10),
                                                    Expanded(
                                                      flex: 5,
                                                      child: SizedBox(
                                                        child: Column(
                                                          crossAxisAlignment:
                                                              CrossAxisAlignment
                                                                  .start,
                                                          children: [
                                                            Text(
                                                              "Inventory",
                                                              style: TextStyle(
                                                                fontSize: 14,
                                                                color:
                                                                    AppColors
                                                                        .app_blue,
                                                                fontFamily:
                                                                    "JakartaMedium",
                                                              ),
                                                            ),
                                                            Text(
                                                              "Stock Management, Evaluations",
                                                              style: TextStyle(
                                                                fontSize: 14,
                                                                color:
                                                                    AppColors
                                                                        .grey_semi,
                                                                fontFamily:
                                                                    "JakartaMedium",
                                                              ),
                                                            ),
                                                          ],
                                                        ),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ),
                                          ] else ...[
                                            if (filteredItems.isNotEmpty) ...[
                                              Container(
                                                margin: EdgeInsets.only(
                                                  left: 10,
                                                  bottom: 5,
                                                  top: 10,
                                                ),
                                                padding: const EdgeInsets.only(
                                                  top: 10,
                                                  bottom: 5,
                                                ),
                                                child: Text(
                                                  "Workforce & Operations",
                                                  style: TextStyle(
                                                    color: AppColors.grey_thick,
                                                    fontSize: 14,
                                                    fontFamily: "JakartaMedium",
                                                  ),
                                                ),
                                              ),
                                              Container(
                                                margin: EdgeInsets.symmetric(
                                                  horizontal: 5,
                                                ),
                                                child: GridView.builder(
                                                  shrinkWrap: true,
                                                  itemCount:
                                                      filteredItems.length,
                                                  gridDelegate:
                                                      SliverGridDelegateWithFixedCrossAxisCount(
                                                        crossAxisCount: 2,
                                                        childAspectRatio:
                                                            2 / 1.1,
                                                      ),
                                                  itemBuilder: (context, ci) {
                                                    return InkResponse(
                                                      onTap: () async {
                                                        HapticFeedback.selectionClick();
                                                        var res;
                                                        switch (filteredItems[ci]['name']) {
                                                          case "Attendance":
                                                            res = await Navigator.push(
                                                              context,
                                                              MaterialPageRoute(
                                                                builder:
                                                                    (context) =>
                                                                        AttendanceScreen(),
                                                                settings:
                                                                    RouteSettings(
                                                                      arguments:
                                                                          'AttendanceScreen',
                                                                    ),
                                                              ),
                                                            );
                                                            break;
                                                          case "ERP":
                                                            bool isGpsEnabled =
                                                                await Geolocator.isLocationServiceEnabled();
                                                            if (isGpsEnabled) {
                                                              if (Platform
                                                                  .isAndroid) {
                                                                res = await Navigator.push(
                                                                  context,
                                                                  MaterialPageRoute(
                                                                    builder:
                                                                        (
                                                                          context,
                                                                        ) => WebErpScreen(
                                                                          erp_url:
                                                                              homescreen.webPageUrl,
                                                                        ),
                                                                  ),
                                                                );
                                                              } else {
                                                                res = await Navigator.push(
                                                                  context,
                                                                  MaterialPageRoute(
                                                                    builder:
                                                                        (
                                                                          context,
                                                                        ) => WebERPIOS(
                                                                          url:
                                                                              homescreen.webPageUrl,
                                                                        ),
                                                                  ),
                                                                );
                                                              }
                                                            } else {
                                                              requestGpsPermission();
                                                            }
                                                            break;
                                                          case "Whizzdom":
                                                            bool isGpsEnabled =
                                                                await Geolocator.isLocationServiceEnabled();
                                                            if (isGpsEnabled) {
                                                              res = await Navigator.push(
                                                                context,
                                                                MaterialPageRoute(
                                                                  builder:
                                                                      (
                                                                        context,
                                                                      ) => WebWhizzdomScreen(
                                                                        whizzdom_url:
                                                                            homescreen.whizzdomPageUrl,
                                                                      ),
                                                                ),
                                                              );
                                                            } else {
                                                              requestGpsPermission();
                                                            }
                                                            break;
                                                          case "Finance":
                                                            res = await Navigator.push(
                                                              context,
                                                              MaterialPageRoute(
                                                                builder:
                                                                    (context) =>
                                                                        Financedashboard(),
                                                                settings:
                                                                    RouteSettings(
                                                                      arguments:
                                                                          'Financedashboard',
                                                                    ),
                                                              ),
                                                            );
                                                            break;
                                                          default:
                                                            print("111");
                                                            break;
                                                        }
                                                        if (res == true) {
                                                          homescreen.DashboardApiFunction(
                                                            context,
                                                          );
                                                        }
                                                      },

                                                      child: Container(
                                                        padding:
                                                            EdgeInsets.symmetric(
                                                              vertical: 5,
                                                              horizontal: 15,
                                                            ),
                                                        margin:
                                                            EdgeInsets.symmetric(
                                                              vertical: 7,
                                                              horizontal: 5,
                                                            ),
                                                        decoration: BoxDecoration(
                                                          color: Colors.white,
                                                          borderRadius:
                                                              BorderRadius.circular(
                                                                14,
                                                              ),
                                                        ),
                                                        child: Row(
                                                          mainAxisAlignment:
                                                              MainAxisAlignment
                                                                  .center,
                                                          crossAxisAlignment:
                                                              CrossAxisAlignment
                                                                  .center,
                                                          children: [
                                                            Expanded(
                                                              flex: 2,
                                                              child: SizedBox(
                                                                child: Column(
                                                                  crossAxisAlignment:
                                                                      CrossAxisAlignment
                                                                          .start,
                                                                  mainAxisAlignment:
                                                                      MainAxisAlignment
                                                                          .center,
                                                                  children: [
                                                                    Text(
                                                                      filteredItems[ci]['name'] ??
                                                                          "-",
                                                                      style: TextStyle(
                                                                        fontSize:
                                                                            14,
                                                                        color:
                                                                            AppColors.app_blue,
                                                                        fontFamily:
                                                                            "JakartaMedium",
                                                                      ),
                                                                    ),
                                                                    Text(
                                                                      filteredItems[ci]['subtitle'] ??
                                                                          "-",
                                                                      style: TextStyle(
                                                                        fontSize:
                                                                            12,
                                                                        color:
                                                                            AppColors.grey_semi,
                                                                        fontFamily:
                                                                            "JakartaMedium",
                                                                      ),
                                                                    ),
                                                                  ],
                                                                ),
                                                              ),
                                                            ),
                                                            SizedBox(width: 10),
                                                            Expanded(
                                                              flex: 1,
                                                              child: SvgPicture.asset(
                                                                filteredItems[ci]['icon'] ??
                                                                    "-",
                                                              ),
                                                            ),
                                                          ],
                                                        ),
                                                      ),
                                                    );
                                                  },
                                                ),
                                              ),

                                              SizedBox(height: 16,),
                                              // Emp contact list
                                              InkResponse(
                                                onTap: () async {
                                                  HapticFeedback.selectionClick();
                                                  var res = await Navigator.push(
                                                    context,
                                                    MaterialPageRoute(
                                                      builder:
                                                          (context) =>
                                                          ContactListScreen(),
                                                    ),
                                                  );
                                                  if (res == true) {
                                                    homescreen.DashboardApiFunction(
                                                      context,
                                                    );
                                                  }
                                                },
                                                child: Container(
                                                  margin: EdgeInsets.symmetric(
                                                    horizontal: 10,
                                                  ),
                                                  padding: EdgeInsets.symmetric(
                                                    vertical: 15,
                                                    horizontal: 15,
                                                  ),
                                                  decoration: BoxDecoration(
                                                    color: Colors.white,
                                                    borderRadius:
                                                    BorderRadius.circular(14),
                                                  ),
                                                  child: Row(
                                                    mainAxisAlignment:
                                                    MainAxisAlignment.center,
                                                    children: [
                                                      Expanded(
                                                        flex: 1,
                                                        child: Container(
                                                          height: 42,
                                                          width: 42,
                                                          decoration: BoxDecoration(
                                                            shape: BoxShape.circle,
                                                            color: const Color(0xFFEDF8FF),
                                                          ),
                                                          child: Center(
                                                            child: SvgPicture.asset(
                                                              "assets/svg/hrm/emp_contact_list.svg",
                                                              color: Color(0xFF1487C9),
                                                              height: 24,
                                                              width: 24,
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                      SizedBox(width: 10),
                                                      Expanded(
                                                        flex: 5,
                                                        child: SizedBox(
                                                          child: Column(
                                                            crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                            children: [
                                                              Text(
                                                                "Employee Contacts",
                                                                style: TextStyle(
                                                                  fontSize: 14,
                                                                  color:
                                                                  AppColors
                                                                      .app_blue,
                                                                  fontFamily:
                                                                  "JakartaMedium",
                                                                ),
                                                              ),
                                                              Text(
                                                                "Contact Details, Whatsapp",
                                                                style: TextStyle(
                                                                  fontSize: 14,
                                                                  color:
                                                                  AppColors
                                                                      .grey_semi,
                                                                  fontFamily:
                                                                  "JakartaMedium",
                                                                ),
                                                              ),
                                                            ],
                                                          ),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                              SizedBox(height: 4,),
                                            ],
                                          ],

                                          // if (filteredItems.isNotEmpty) ...[
                                          //   Container(
                                          //     margin: EdgeInsets.symmetric(
                                          //       horizontal: 10,
                                          //     ),
                                          //     padding: const EdgeInsets.only(
                                          //       top: 10,
                                          //       bottom: 5,
                                          //     ),
                                          //     child: Text(
                                          //       "Workforce & Operations",
                                          //       style: TextStyle(
                                          //         color: AppColors.grey_thick,
                                          //         fontSize: 14,
                                          //         fontFamily: "JakartaMedium",
                                          //       ),
                                          //     ),
                                          //   ),
                                          //   Container(
                                          //     margin: EdgeInsets.symmetric(
                                          //       horizontal: 5,
                                          //     ),
                                          //     child: GridView.builder(
                                          //       shrinkWrap: true,
                                          //       itemCount: filteredItems.length,
                                          //       gridDelegate:
                                          //       SliverGridDelegateWithFixedCrossAxisCount(
                                          //         crossAxisCount: 2,
                                          //         childAspectRatio: 2 / 1.1,
                                          //       ),
                                          //       itemBuilder: (context, ci) {
                                          //         return InkResponse(
                                          //           onTap: () async {
                                          //             var res;
                                          //             switch (filteredItems[ci]['name']) {
                                          //               case "Attendance":
                                          //                 res = await Navigator.push(
                                          //                   context,
                                          //                   MaterialPageRoute(
                                          //                     builder:
                                          //                         (context) =>
                                          //                         AttendanceScreen(),
                                          //                     settings: RouteSettings(
                                          //                       arguments:
                                          //                       'AttendanceScreen',
                                          //                     ),
                                          //                   ),
                                          //                 );
                                          //                 break;
                                          //               case "ERP":
                                          //                 bool isGpsEnabled =
                                          //                 await Geolocator.isLocationServiceEnabled();
                                          //                 if (isGpsEnabled) {
                                          //                   if (Platform.isAndroid) {
                                          //                     res = await Navigator.push(
                                          //                       context,
                                          //                       MaterialPageRoute(
                                          //                         builder:
                                          //                             (
                                          //                             context,
                                          //                             ) => WebErpScreen(
                                          //                           erp_url:
                                          //                           homescreen
                                          //                               .webPageUrl,
                                          //                         ),
                                          //                       ),
                                          //                     );
                                          //                   } else {
                                          //                     res = await Navigator.push(
                                          //                       context,
                                          //                       MaterialPageRoute(
                                          //                         builder:
                                          //                             (
                                          //                             context,
                                          //                             ) => WebERPIOS(
                                          //                           url:
                                          //                           homescreen
                                          //                               .webPageUrl,
                                          //                         ),
                                          //                       ),
                                          //                     );
                                          //                   }
                                          //                 } else {
                                          //                   requestGpsPermission();
                                          //                 }
                                          //                 break;
                                          //               case "Whizzdom":
                                          //                 bool isGpsEnabled =
                                          //                 await Geolocator.isLocationServiceEnabled();
                                          //                 if (isGpsEnabled) {
                                          //                   res = await Navigator.push(
                                          //                     context,
                                          //                     MaterialPageRoute(
                                          //                       builder:
                                          //                           (
                                          //                           context,
                                          //                           ) => WebWhizzdomScreen(
                                          //                         whizzdom_url:
                                          //                         homescreen
                                          //                             .whizzdomPageUrl,
                                          //                       ),
                                          //                     ),
                                          //                   );
                                          //                 } else {
                                          //                   requestGpsPermission();
                                          //                 }
                                          //                 break;
                                          //               case "Finance":
                                          //                 res = await Navigator.push(
                                          //                   context,
                                          //                   MaterialPageRoute(
                                          //                     builder:
                                          //                         (context) =>
                                          //                         Financedashboard(),
                                          //                     settings: RouteSettings(
                                          //                       arguments:
                                          //                       'Financedashboard',
                                          //                     ),
                                          //                   ),
                                          //                 );
                                          //                 break;
                                          //               default:
                                          //                 print("111");
                                          //                 break;
                                          //             }
                                          //             if (res == true) {
                                          //               homescreen.DashboardApiFunction(
                                          //                 context,
                                          //               );
                                          //             }
                                          //           },
                                          //
                                          //           child: Container(
                                          //             padding: EdgeInsets.symmetric(
                                          //               vertical: 5,
                                          //               horizontal: 15,
                                          //             ),
                                          //             margin: EdgeInsets.symmetric(
                                          //               vertical: 7,
                                          //               horizontal: 5,
                                          //             ),
                                          //             decoration: BoxDecoration(
                                          //               color: Colors.white,
                                          //               borderRadius:
                                          //               BorderRadius.circular(14),
                                          //             ),
                                          //             child: Row(
                                          //               mainAxisAlignment:
                                          //               MainAxisAlignment.center,
                                          //               crossAxisAlignment:
                                          //               CrossAxisAlignment.center,
                                          //               children: [
                                          //                 Expanded(
                                          //                   flex: 2,
                                          //                   child: SizedBox(
                                          //                     child: Column(
                                          //                       crossAxisAlignment:
                                          //                       CrossAxisAlignment
                                          //                           .start,
                                          //                       mainAxisAlignment:
                                          //                       MainAxisAlignment
                                          //                           .center,
                                          //                       children: [
                                          //                         Text(
                                          //                           filteredItems[ci]['name'] ??
                                          //                               "-",
                                          //                           style: TextStyle(
                                          //                             fontSize: 14,
                                          //                             color:
                                          //                             AppColors
                                          //                                 .app_blue,
                                          //                             fontFamily:
                                          //                             "JakartaMedium",
                                          //                           ),
                                          //                         ),
                                          //                         Text(
                                          //                           filteredItems[ci]['subtitle'] ??
                                          //                               "-",
                                          //                           style: TextStyle(
                                          //                             fontSize: 12,
                                          //                             color:
                                          //                             AppColors
                                          //                                 .grey_semi,
                                          //                             fontFamily:
                                          //                             "JakartaMedium",
                                          //                           ),
                                          //                         ),
                                          //                       ],
                                          //                     ),
                                          //                   ),
                                          //                 ),
                                          //                 SizedBox(width: 10),
                                          //                 Expanded(
                                          //                   flex: 1,
                                          //                   child: SvgPicture.asset(
                                          //                     filteredItems[ci]['icon'] ??
                                          //                         "-",
                                          //                   ),
                                          //                 ),
                                          //               ],
                                          //             ),
                                          //           ),
                                          //         );
                                          //       },
                                          //     ),
                                          //   ),
                                          // ],
                                          if (coreFilteredItems.isNotEmpty) ...[
                                            Container(
                                              margin: EdgeInsets.only(
                                                left: 10,
                                                bottom: 5,
                                                top: 10,
                                              ),
                                              padding: const EdgeInsets.only(
                                                top: 10,
                                                bottom: 5,
                                              ),
                                              child: Text(
                                                "Core Functionalities",
                                                style: TextStyle(
                                                  color: AppColors.grey_thick,
                                                  fontSize: 14,
                                                  fontFamily: "JakartaMedium",
                                                ),
                                              ),
                                            ),
                                            Container(
                                              margin: EdgeInsets.symmetric(
                                                horizontal: 5,
                                              ),
                                              child: GridView.builder(
                                                shrinkWrap: true,
                                                itemCount:
                                                    coreFilteredItems.length,
                                                physics:
                                                    NeverScrollableScrollPhysics(),
                                                gridDelegate:
                                                    SliverGridDelegateWithFixedCrossAxisCount(
                                                      crossAxisCount: 2,
                                                      childAspectRatio: 2 / 1.1,
                                                    ),
                                                itemBuilder: (context, ci) {
                                                  return InkResponse(
                                                    onTap: () async {
                                                      HapticFeedback.selectionClick();
                                                      var res;
                                                      switch (coreFilteredItems[ci]['name']) {
                                                        case "Gen Tracker":
                                                          res = await Navigator.push(
                                                            context,
                                                            MaterialPageRoute(
                                                              builder:
                                                                  (context) =>
                                                                      Gentrackerdashboard(),
                                                              settings:
                                                                  RouteSettings(
                                                                    arguments:
                                                                        'Gentrackerdashboard',
                                                                  ),
                                                            ),
                                                          );
                                                          // res = await Navigator.push(
                                                          //   context,
                                                          //   MaterialPageRoute(
                                                          //     builder:
                                                          //         (context) => Scanentergeneratoridscreen(
                                                          //       from: "Generator Details",
                                                          //     ),
                                                          //     settings: RouteSettings(
                                                          //       name: 'Scanentergeneratoridscreen'
                                                          //     )
                                                          //   ),
                                                          // );
                                                          break;
                                                        case "Service":
                                                          res = await Navigator.push(
                                                            context,
                                                            MaterialPageRoute(
                                                              builder:
                                                                  (context) =>
                                                                      Serviceengineerdashboard(),
                                                            ),
                                                          );
                                                          break;
                                                        case "Orders":
                                                          res = await Navigator.push(
                                                            context,
                                                            MaterialPageRoute(
                                                              builder:
                                                                  (context) =>
                                                                      Ordermoduledashboard(),
                                                            ),
                                                          );
                                                        case "CRM":
                                                          res = await Navigator.push(
                                                            context,
                                                            MaterialPageRoute(
                                                              builder:
                                                                  (context) =>
                                                                      CrmdashboardScreen(),
                                                              settings:
                                                                  RouteSettings(
                                                                    name:
                                                                        'CrmdashboardScreen',
                                                                  ),
                                                            ),
                                                          );
                                                        case "HRM":
                                                          res = await Navigator.push(
                                                            context,
                                                            MaterialPageRoute(
                                                              builder:
                                                                  (context) =>
                                                                      HrmdashboardScreen(),
                                                              settings:
                                                                  RouteSettings(
                                                                    name:
                                                                        'CrmdashboardScreen',
                                                                  ),
                                                            ),
                                                          );
                                                        default:
                                                          print("111");
                                                          break;
                                                      }
                                                      if (res == true) {
                                                        homescreen.DashboardApiFunction(
                                                          context,
                                                        );
                                                      }
                                                    },

                                                    child: Container(
                                                      padding:
                                                          EdgeInsets.symmetric(
                                                            vertical: 5,
                                                            horizontal: 15,
                                                          ),
                                                      margin:
                                                          EdgeInsets.symmetric(
                                                            vertical: 7,
                                                            horizontal: 5,
                                                          ),
                                                      decoration: BoxDecoration(
                                                        color: Colors.white,
                                                        borderRadius:
                                                            BorderRadius.circular(
                                                              14,
                                                            ),
                                                      ),
                                                      child: Row(
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .center,
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .center,
                                                        children: [
                                                          Expanded(
                                                            flex: 2,
                                                            child: SizedBox(
                                                              child: Column(
                                                                crossAxisAlignment:
                                                                    CrossAxisAlignment
                                                                        .start,
                                                                mainAxisAlignment:
                                                                    MainAxisAlignment
                                                                        .center,
                                                                children: [
                                                                  Text(
                                                                    coreFilteredItems[ci]['name'] ??
                                                                        "-",
                                                                    style: TextStyle(
                                                                      fontSize:
                                                                          14,
                                                                      color:
                                                                          AppColors
                                                                              .app_blue,
                                                                      fontFamily:
                                                                          "JakartaMedium",
                                                                    ),
                                                                  ),
                                                                  Text(
                                                                    coreFilteredItems[ci]['subtitle'] ??
                                                                        "-",
                                                                    style: TextStyle(
                                                                      fontSize:
                                                                          12,
                                                                      color:
                                                                          AppColors
                                                                              .grey_semi,
                                                                      fontFamily:
                                                                          "JakartaMedium",
                                                                    ),
                                                                  ),
                                                                ],
                                                              ),
                                                            ),
                                                          ),
                                                          SizedBox(width: 10),
                                                          Expanded(
                                                            flex: 1,
                                                            child: SvgPicture.asset(
                                                              coreFilteredItems[ci]['icon'] ??
                                                                  "-",
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  );
                                                },
                                              ),
                                            ),
                                          ],
                                        ],
                                      ),
                                    ),
                                    SizedBox(height: 12),
                                    Align(
                                      alignment: Alignment.bottomCenter,
                                      child: Container(
                                        height: 40,
                                        alignment: Alignment.bottomCenter,
                                        margin: EdgeInsets.only(
                                          bottom: bottomPadding,
                                        ),
                                        child: Image.asset(
                                          fit: BoxFit.scaleDown,
                                          "assets/images/horizontal_logo.png",
                                        ),
                                      ),
                                    ),
                                    SizedBox(height: 10),
                                    // Expanded(
                                    //   flex: 10,
                                    //   child: Container(
                                    //     padding: EdgeInsets.only(
                                    //       left: 20,
                                    //       right: 20,
                                    //       top: 0,
                                    //       bottom: 10,
                                    //     ),
                                    //     margin: EdgeInsets.only(top: 10),
                                    //     child: GridView.builder(
                                    //       itemCount: filteredItems.length,
                                    //       gridDelegate:
                                    //           SliverGridDelegateWithFixedCrossAxisCount(
                                    //             crossAxisCount: 2,
                                    //             crossAxisSpacing: 10,
                                    //             mainAxisSpacing: 10,
                                    //           ),
                                    //       itemBuilder: (context, index) {
                                    //         final item = filteredItems[index];
                                    //         return InkResponse(
                                    //           onTap: () async {
                                    //             var res;
                                    //             switch (item['name']) {
                                    //               case "Attendance":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             AttendanceScreen(),
                                    //                     settings: RouteSettings(
                                    //                       arguments: 'AttendanceScreen',
                                    //                     ),
                                    //                   ),
                                    //                 );
                                    //                 break;
                                    //               case "ERP":
                                    //                 bool isGpsEnabled =
                                    //                     await Geolocator.isLocationServiceEnabled();
                                    //                 if (isGpsEnabled) {
                                    //                   if (Platform.isAndroid) {
                                    //                     res = await Navigator.push(
                                    //                       context,
                                    //                       MaterialPageRoute(
                                    //                         builder:
                                    //                             (context) => WebErpScreen(
                                    //                               erp_url:
                                    //                                   homescreen
                                    //                                       .webPageUrl,
                                    //                             ),
                                    //                       ),
                                    //                     );
                                    //                   } else {
                                    //                     res = await Navigator.push(
                                    //                       context,
                                    //                       MaterialPageRoute(
                                    //                         builder:
                                    //                             (context) => WebERPIOS(
                                    //                               url:
                                    //                                   homescreen
                                    //                                       .webPageUrl,
                                    //                             ),
                                    //                       ),
                                    //                     );
                                    //                   }
                                    //                 } else {
                                    //                   requestGpsPermission();
                                    //                 }
                                    //
                                    //                 break;
                                    //               case "Gen Tracker":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             Gentrackerdashboard(),
                                    //                     settings: RouteSettings(
                                    //                       arguments:
                                    //                           'Gentrackerdashboard',
                                    //                     ),
                                    //                   ),
                                    //                 );
                                    //                 break;
                                    //               case "Service Engineer":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             Serviceengineerdashboard(),
                                    //                   ),
                                    //                 );
                                    //                 break;
                                    //               case "Nearby":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             Nearbygenerators(),
                                    //                   ),
                                    //                 );
                                    //
                                    //                 break;
                                    //               case "Inventory":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             InventoryScreen(),
                                    //                   ),
                                    //                 );
                                    //                 break;
                                    //               case "Whizzdom":
                                    //                 bool isGpsEnabled =
                                    //                     await Geolocator.isLocationServiceEnabled();
                                    //                 if (isGpsEnabled) {
                                    //                   res = await Navigator.push(
                                    //                     context,
                                    //                     MaterialPageRoute(
                                    //                       builder:
                                    //                           (
                                    //                             context,
                                    //                           ) => WebWhizzdomScreen(
                                    //                             whizzdom_url:
                                    //                                 homescreen
                                    //                                     .whizzdomPageUrl,
                                    //                           ),
                                    //                     ),
                                    //                   );
                                    //                 } else {
                                    //                   requestGpsPermission();
                                    //                 }
                                    //                 break;
                                    //               case "Common":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             Commondashboard(),
                                    //                   ),
                                    //                 );
                                    //                 break;
                                    //               case "Finance":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             Financedashboard(),
                                    //                     settings: RouteSettings(
                                    //                       arguments: 'Financedashboard',
                                    //                     ),
                                    //                   ),
                                    //                 );
                                    //                 break;
                                    //               case "Orders":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             Ordermoduledashboard(),
                                    //                   ),
                                    //                 );
                                    //               case "CRM":
                                    //                 res = await Navigator.push(
                                    //                   context,
                                    //                   MaterialPageRoute(
                                    //                     builder:
                                    //                         (context) =>
                                    //                             CrmdashboardScreen(),
                                    //                     settings: RouteSettings(
                                    //                       name: 'CrmdashboardScreen',
                                    //                     ),
                                    //                   ),
                                    //                 );
                                    //               default:
                                    //                 print("111");
                                    //                 break;
                                    //             }
                                    //             if (res == true) {
                                    //               homescreen.DashboardApiFunction(
                                    //                 context,
                                    //               );
                                    //             }
                                    //           },
                                    //           child: Container(
                                    //             decoration: BoxDecoration(
                                    //               color: Colors.white,
                                    //               borderRadius: BorderRadius.circular(30),
                                    //             ),
                                    //             child: Column(
                                    //               crossAxisAlignment:
                                    //                   CrossAxisAlignment.center,
                                    //               mainAxisAlignment:
                                    //                   MainAxisAlignment.center,
                                    //               children: [
                                    //                 SvgPicture.asset(
                                    //                   item['icon']!,
                                    //                   height: 45,
                                    //                 ),
                                    //                 SizedBox(height: 10),
                                    //                 Text(item['name']!),
                                    //               ],
                                    //             ),
                                    //           ),
                                    //         );
                                    //       },
                                    //     ),
                                    //   ),
                                    // ),
                                  ],
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                    // floatingActionButtonLocation: FloatingActionButtonLocation.centerFloat,
                    // floatingActionButton:
                  ),
                ),
              ),
            );
          },
        )
        : NoNetwork(context);
  }

  Future<void> _showProfileBottomSheet(BuildContext context) {
    // final profileNotifier = Provider.of<ProfileNotifer>(context, listen: false);

    // profileNotifier.fetchJobDescription(
    //   Provider.of<HomescreenNotifier>(context, listen: false),
    //   context,
    // );
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,

      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Container(
                margin: EdgeInsets.only(
                  bottom: 15,
                  left: 15,
                  right: 15,
                  top: 30,
                ),
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: Consumer3<
                  HomescreenNotifier,
                  ProfileNotifer,
                  LogoutNotifier
                >(
                  builder: (context, home, profile, logout, child) {
                    return SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Padding(
                            padding: const EdgeInsets.symmetric(
                              horizontal: 5.0,
                            ),
                            child: Row(
                              children: [
                                SizedBox(
                                  height: 35,
                                  child: Image.asset(
                                    "assets/images/gen_horiz_logo.png",
                                  ),
                                ),
                                Spacer(),
                                InkResponse(
                                  onTap: () {
                                    HapticFeedback.selectionClick();
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder: (context) => Scannerlogin(),
                                      ),
                                    );
                                  },
                                  child: SizedBox(
                                    height: 25,
                                    width: 25,
                                    child: SvgPicture.asset(
                                      "assets/svg/scanner.svg",
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          SizedBox(height: 15),
                          Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 5,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(30),
                              gradient: LinearGradient(
                                colors: [
                                  AppColors.profile_card_gradient1,
                                  AppColors.profile_card_gradient2,
                                ],
                              ),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Padding(
                                  padding: EdgeInsets.all(10),
                                  child: SizedBox(
                                    width: 70,
                                    height: 70,
                                    child: ClipRRect(
                                      borderRadius: BorderRadius.circular(50),
                                      child: CachedNetworkImage(
                                        cacheKey: profile.profileImage,
                                        fit: BoxFit.cover,
                                        imageUrl: "${profile.profileImage}",
                                        useOldImageOnUrlChange: false,
                                        placeholder:
                                            (context, url) =>
                                                CircularProgressIndicator.adaptive(),
                                        errorWidget:
                                            (context, url, error) =>
                                                Icon(Icons.error),
                                      ),
                                    ),
                                  ),
                                ),
                                Text(
                                  "${profile.employeeName}",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontFamily: "JakartaSemiBold",
                                    fontSize: 18,
                                  ),
                                ),
                                Text(
                                  "${profile.employeeEmail}",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.semi_black,
                                    fontSize: 14,
                                  ),
                                ),
                                Container(
                                  padding: const EdgeInsets.symmetric(
                                    horizontal: 20,
                                    vertical: 15,
                                  ),
                                  alignment: Alignment.center,
                                  child: ListView.builder(
                                    shrinkWrap: true,
                                    physics:
                                        const NeverScrollableScrollPhysics(),
                                    itemCount: 5,
                                    itemBuilder: (context, index) {
                                      final textHeadings = [
                                        "Company",
                                        "Branch",
                                        "Designation",
                                        "Employee ID",
                                        "Mobile Number",
                                      ];

                                      final textValues = [
                                        profile.company,
                                        profile.branch,
                                        profile.designation,
                                        profile.employeeeID,
                                        profile.mobileNUmber,
                                      ];

                                      final itemText =
                                          textValues[index]?.toString() ?? "-";

                                      return Padding(
                                        padding: const EdgeInsets.symmetric(
                                          vertical: 10,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            /// Heading
                                            Expanded(
                                              flex: 1,
                                              child: Text(
                                                textHeadings[index],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  fontFamily: "JakartaMedium",
                                                  color: AppColors.app_blue,
                                                ),
                                              ),
                                            ),

                                            /// Value + "View" (only for Designation row)
                                            Expanded(
                                              flex: 1,
                                              child: Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Text(
                                                    itemText,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.semi_black,
                                                    ),
                                                  ),
                                                    if (index == 2) // only for Designation
                                                      InkWell(
                                                        onTap:
                                                            index == 2
                                                                ? () async {
                                                                  /// now navigate to job desc screen
                                                                  final profileNotifier =
                                                                      Provider.of<
                                                                        ProfileNotifer
                                                                      >(
                                                                        context,
                                                                        listen:
                                                                            false,
                                                                      );

                                                                  await profileNotifier.fetchJobDescription(
                                                                    Provider.of<
                                                                      HomescreenNotifier
                                                                    >(
                                                                      context,
                                                                      listen:
                                                                          false,
                                                                    ),
                                                                    context,
                                                                  );

                                                                  if (profileNotifier
                                                                              .response !=
                                                                          null &&
                                                                      profileNotifier
                                                                              .response!
                                                                              .jobDescription !=
                                                                          null &&
                                                                      profileNotifier
                                                                              .response!
                                                                              .jobDescription!
                                                                              .jobDescription !=
                                                                          null &&
                                                                      profileNotifier
                                                                              .response!
                                                                              .jobDescription!
                                                                              .jobDescription !=
                                                                          "") {
                                                                    Navigator.push(
                                                                      context,
                                                                      MaterialPageRoute(
                                                                        builder:
                                                                            (
                                                                              context,
                                                                            ) => JobDescriptionScreen(
                                                                              htmlData:
                                                                                  profileNotifier.response!.jobDescription!.jobDescription ??
                                                                                  "<p>No description</p>",
                                                                              title:
                                                                                  profileNotifier.response!.jobDescription!.name ??
                                                                                  "Job Description",
                                                                              designation:
                                                                                  itemText,
                                                                            ),
                                                                      ),
                                                                    );
                                                                  } else {
                                                                    ScaffoldMessenger.of(
                                                                      context,
                                                                    ).showSnackBar(
                                                                      SnackBar(
                                                                        content: Text(
                                                                          profileNotifier.errorMessage ??
                                                                              "Failed to fetch job description",
                                                                        ),
                                                                      ),
                                                                    );
                                                                  }
                                                                }
                                                                : null,
                                                        child: Row(
                                                          children: [
                                                            Text(
                                                              "View",
                                                              style: TextStyle(
                                                                fontSize: 14,
                                                                fontWeight:
                                                                    FontWeight
                                                                        .w600,
                                                                color:
                                                                    Colors.blue,
                                                              ),
                                                            ),
                                                            Icon(
                                                              Icons.play_arrow,
                                                              size: 18,
                                                              color: Color(
                                                                0xFF1487C9,
                                                              ),
                                                            ),
                                                          ],
                                                        ),
                                                      ),
                                                ],
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    },
                                  ),
                                ),
                              ],
                            ),
                          ),
                          SizedBox(height: 10),
                          InkWell(
                            onTap: () {
                              HapticFeedback.selectionClick();
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              _showLogoutBottomSheet(context);
                              //  Navigator.push(context,MaterialPageRoute(builder: (context)=>Profile()));
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(15.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Logout",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),

                          Text(
                            profile.releaseNotes,
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.grey_thick,
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLogoutBottomSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,

      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Container(
                margin: EdgeInsets.only(
                  bottom: 15,
                  left: 15,
                  right: 15,
                  top: 30,
                ),
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: Consumer3<
                  HomescreenNotifier,
                  ProfileNotifer,
                  LogoutNotifier
                >(
                  builder: (context, home, profile, logout, child) {
                    return SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(
                                "Are you sure you want \nto logout ?",
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  color: AppColors.semi_black,
                                  fontSize: 18,
                                ),
                              ),
                            ],
                          ),
                          SizedBox(height: 20),
                          InkWell(
                            onTap:
                                logout.logoutButtonClicked
                                    ? null
                                    : () {
                                      HapticFeedback.selectionClick();
                                      // LoginApiFunction();
                                      logout.logoutButtonClicked = true;
                                      var f = FocusScope.of(context);

                                      if (!f.hasPrimaryFocus) {
                                        f.unfocus();
                                      }
                                      logout.LogoutApiFunction(home, context);
                                      //  Navigator.push(context,MaterialPageRoute(builder: (context)=>Profile()));
                                    },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(15.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Yes, Logout",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontFamily: "JakartaMedium",
                                  ),
                                ),
                              ),
                            ),
                          ),

                          InkWell(
                            onTap: () {
                              HapticFeedback.selectionClick();
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              Navigator.pop(context);
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),

                              child: Center(
                                child: Text(
                                  "Cancel",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontFamily: "JakartaMedium",
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            );
          },
        );
      },
    );
  }
}
