class leaveApplicationLIstResponse {
  List<RequestList>? requestList;
  String? error;
  String? message;
  int? sessionExists;

  leaveApplicationLIstResponse({
    this.requestList,
    this.error,
    this.message,
    this.sessionExists,
  });

  leaveApplicationLIstResponse.fromJson(Map<String, dynamic> json) {
    if (json['request_list'] != null) {
      requestList = <RequestList>[];
      json['request_list'].forEach((v) {
        requestList!.add(RequestList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requestList != null) {
      data['request_list'] = requestList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class RequestList {
  String? id;
  String? appliedDate;
  String? fromPeriod;
  String? toPeriod;
  String? status;
  String? leaveType;
  String? rowColor;
  String? employeeName;

  RequestList({
    this.id,
    this.appliedDate,
    this.fromPeriod,
    this.toPeriod,
    this.status,
  });

  RequestList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    appliedDate = json['applied_date'];
    fromPeriod = json['from_period'];
    toPeriod = json['to_period'];
    status = json['status'];
    leaveType = json["leave_type"];
    rowColor = json["row_colur"];
    employeeName = json["employee_name"];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['applied_date'] = appliedDate;
    data['from_period'] = fromPeriod;
    data['to_period'] = toPeriod;
    data['status'] = status;
    data["leave_type"] = leaveType;
    data["row_colur"] = rowColor;
    data["employee_name"] = employeeName;
    return data;
  }
}
