class generatorComplaintResponse {
  int? error;
  List<C_List>? list;
  int? sessionExists;

  generatorComplaintResponse({this.error, this.list, this.sessionExists});

  generatorComplaintResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['list'] != null) {
      list = <C_List>[];
      json['list'].forEach((v) {
        list!.add(C_List.fromJson(v));
      });
    }
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (list != null) {
      data['list'] = list!.map((v) => v.toJson()).toList();
    }
    data['session_exists'] = sessionExists;
    return data;
  }
}

class C_List {
  String? compId;
  String? compType;
  String? compStatus;
  String? compRegdate;
  String? complaintNote;
  String? techName;
  String? createdBy;

  C_List({
    this.compId,
    this.compType,
    this.compStatus,
    this.compRegdate,
    this.complaintNote,
    this.techName,
    this.createdBy,
  });

  C_List.fromJson(Map<String, dynamic> json) {
    compId = json['comp_id'];
    compType = json['comp_type'];
    compStatus = json['comp_status'];
    compRegdate = json['comp_regdate'];
    complaintNote = json['complaint_note'];
    techName = json['tech_name'];
    createdBy = json['created_by'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['comp_id'] = compId;
    data['comp_type'] = compType;
    data['comp_status'] = compStatus;
    data['comp_regdate'] = compRegdate;
    data['complaint_note'] = complaintNote;
    data['tech_name'] = techName;
    data['created_by'] = createdBy;
    return data;
  }
}
