class SubmitProspectListFilterResponse {
  List<AccountsList>? accountsList;
  String? error;
  String? message;

  SubmitProspectListFilterResponse({
    this.accountsList,
    this.error,
    this.message,
  });

  SubmitProspectListFilterResponse.fromJson(Map<String, dynamic> json) {
    if (json['accounts_list'] != null) {
      accountsList = <AccountsList>[];
      json['accounts_list'].forEach((v) {
        accountsList!.add(AccountsList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accountsList != null) {
      data['accounts_list'] = accountsList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class AccountsList {
  String? gstNumber;
  String? adate;
  String? accman;
  String? mob1;
  String? cname;
  String? address;
  String? aid;
  String? aname;
  String? age;

  AccountsList({
    this.gstNumber,
    this.adate,
    this.accman,
    this.mob1,
    this.cname,
    this.address,
    this.aid,
    this.aname,
    this.age,
  });

  AccountsList.fromJson(Map<String, dynamic> json) {
    gstNumber = json['gst_number'];
    adate = json['adate'];
    accman = json['accman'];
    mob1 = json['mob1'];
    cname = json['cname'];
    address = json['address'];
    aid = json['aid'];
    aname = json['aname'];
    age = json['age'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['gst_number'] = gstNumber;
    data['adate'] = adate;
    data['accman'] = accman;
    data['mob1'] = mob1;
    data['cname'] = cname;
    data['address'] = address;
    data['aid'] = aid;
    data['aname'] = aname;
    data['age'] = age;
    return data;
  }
}
