class TodayVisitResponse {
  List<Visitlist>? list;
  int? error;
  int? sessionExists;

  TodayVisitResponse({this.list, this.error, this.sessionExists});

  TodayVisitResponse.fromJson(Map<String, dynamic> json) {
    if (json['list'] != null) {
      list = <Visitlist>[];
      json['list'].forEach((v) {
        list!.add(Visitlist.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (list != null) {
      data['list'] = list!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Visitlist {
  String? genId;
  String? complaintId;
  String? address;
  String? loc;
  String? mobileNo;
  String? followupId;
  String? companyName;
  String? contactName;
  String? productName;
  String? complaintCategory;
  String? visitDatetime;

  Visitlist({
    this.genId,
    this.complaintId,
    this.address,
    this.loc,
    this.mobileNo,
    this.followupId,
    this.companyName,
    this.contactName,
    this.productName,
    this.complaintCategory,
    this.visitDatetime,
  });

  Visitlist.fromJson(Map<String, dynamic> json) {
    genId = json['gen_id'];
    complaintId = json['complaint_id'];
    address = json['address'];
    loc = json['loc'];
    mobileNo = json['mobile_no'];
    followupId = json['followup_id'];
    companyName = json['company_name'];
    contactName = json['contact_name'];
    productName = json['product_name'];
    complaintCategory = json['complaint_category'];
    visitDatetime = json['visit_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['gen_id'] = genId;
    data['complaint_id'] = complaintId;
    data['address'] = address;
    data['loc'] = loc;
    data['mobile_no'] = mobileNo;
    data['followup_id'] = followupId;
    data['company_name'] = companyName;
    data['contact_name'] = contactName;
    data['product_name'] = productName;
    data['complaint_category'] = complaintCategory;
    data['visit_datetime'] = visitDatetime;
    return data;
  }
}
