class ProfileResponse {
  String? totpSecret;
  String? empId;
  String? empName;
  String? emailId;
  String? branchName;
  String? mobileNo;
  String? designation;
  String? company;
  String? profilePic;
  int? sessionExists;

  ProfileResponse({
    this.totpSecret,
    this.empId,
    this.empName,
    this.emailId,
    this.branchName,
    this.mobileNo,
    this.designation,
    this.company,
    this.profilePic,
    this.sessionExists,
  });

  ProfileResponse.fromJson(Map<String, dynamic> json) {
    totpSecret = json['totp_secret'];
    empId = json['emp_id'];
    empName = json['emp_name'];
    emailId = json['email_id'];
    branchName = json['branch_name'];
    mobileNo = json['mobile_no'];
    designation = json['designation'];
    company = json['company'];
    profilePic = json['profile_pic'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['totp_secret'] = totpSecret;
    data['emp_id'] = empId;
    data['emp_name'] = empName;
    data['email_id'] = emailId;
    data['branch_name'] = branchName;
    data['mobile_no'] = mobileNo;
    data['designation'] = designation;
    data['company'] = company;
    data['profile_pic'] = profilePic;
    data['session_exists'] = sessionExists;
    return data;
  }
}
