import 'dart:io';

import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/PaymentDetailsProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:pin_code_fields/pin_code_fields.dart';
import 'package:provider/provider.dart';

import '../../Models/TechnicianLoadNumbersResponse.dart';
import '../../Utils/dropdownTheme.dart';

class Paymentdetails extends StatefulWidget {
  final accountName, referenceID, name, genId;

  const Paymentdetails({
    super.key,
    required this.accountName,
    required this.name,
    required this.genId,
    required this.referenceID,
  });

  @override
  State<Paymentdetails> createState() => _PaymentdetailsState();
}

class _PaymentdetailsState extends State<Paymentdetails> {
  Dropdowntheme ddtheme = Dropdowntheme();

  List<FocusNode> focusNodes = List.generate(7, (index) => FocusNode());
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      Future.microtask(() {
        var provider = Provider.of<Paymentdetailsprovider>(
          context,
          listen: false,
        );
        provider.LoadNumbersAPI(
          context,
          widget.accountName,
          widget.referenceID,
          widget.genId,
        );
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Paymentdetailsprovider>(
      builder: (context, provider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: RefreshIndicator.adaptive(
            color: AppColors.app_blue,
            onRefresh: () async {
              provider.LoadNumbersAPI(
                context,
                widget.accountName,
                widget.referenceID,
                widget.genId,
              );
            },
            child: SafeArea(
              top: false,
              bottom: Platform.isIOS ? false : true,
              child: Scaffold(
                resizeToAvoidBottomInset: true,
                appBar: appbarNew(context, "Payment Details", 0xFFFFFFFF),
                backgroundColor: AppColors.scaffold_bg_color,
                body: SingleChildScrollView(
                  child: RefreshIndicator.adaptive(
                    color: AppColors.app_blue,
                    onRefresh: () async {
                      provider.LoadNumbersAPI(
                        context,
                        widget.accountName,
                        widget.referenceID,
                        widget.genId,
                      );
                    },
                    child: Container(
                      padding: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 10,
                      ),
                      margin: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 10,
                      ),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(20),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            padding: EdgeInsets.symmetric(vertical: 5),
                            child: Text(
                              "${widget.name}",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                          SizedBox(height: 10),
                          Padding(
                            padding: const EdgeInsets.only(bottom: 5.0),
                            child: Text("Phone Number"),
                          ),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Contacts>(
                                    isExpanded: true,
                                    hint: const Row(
                                      children: [
                                        Expanded(
                                          child: Text(
                                            'Select Phone Number',
                                            style: TextStyle(fontSize: 14),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                      ],
                                    ),
                                    items: [
                                      ...provider.contactsDropDown.map((
                                        contacts,
                                      ) {
                                        return DropdownMenuItem<Contacts>(
                                          value: contacts,
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                contacts.name ?? "",
                                                maxLines: 1,
                                                style: const TextStyle(
                                                  fontSize: 12,
                                                ),
                                                overflow: TextOverflow.ellipsis,
                                              ),
                                              Text(
                                                contacts.mob1 ?? "",
                                                style: const TextStyle(
                                                  fontSize: 12,
                                                ),
                                                overflow: TextOverflow.ellipsis,
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                      DropdownMenuItem<Contacts>(
                                        onTap: () {},
                                        value: null,
                                        // No value associated with the button
                                        enabled: false,
                                        // To disable selecting this item
                                        child: InkWell(
                                          onTap: () {
                                            Navigator.pop(context);
                                            _addContactSheet(context);
                                          },
                                          child: Container(
                                            height: 45,
                                            decoration: BoxDecoration(
                                              border: Border.all(
                                                color: AppColors.app_blue,
                                                width: 0.5,
                                              ),
                                              borderRadius:
                                                  BorderRadius.circular(12),
                                            ),
                                            padding: const EdgeInsets.symmetric(
                                              vertical: 5,
                                              horizontal: 14,
                                            ),
                                            child: Row(
                                              mainAxisAlignment:
                                                  MainAxisAlignment.center,
                                              children: const [
                                                Text(
                                                  'Add Contact',
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: Colors.blue,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                    // value: provider.selectContact,
                                    value:
                                        provider.contactsDropDown.contains(
                                              provider.selectContact,
                                            )
                                            ? provider.selectContact
                                            : null,
                                    // The selected value is now the entire 'Contacts' object
                                    onChanged: (Contacts? value) {
                                      if (value != null) {
                                        if (provider
                                            .contactsDropDown
                                            .isNotEmpty) {
                                          provider.selectContact =
                                              value; // Set the selected contact
                                          provider.contact =
                                              value.name ??
                                              ""; // Update the contact name
                                          provider.contactID =
                                              value.mob1 ??
                                              ""; // Update the contact ID
                                          debugPrint(
                                            "Selected Contact: ${value.name}, Phone: ${value.mob1}",
                                          );
                                        }
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.selectContactError),
                          SizedBox(height: 10),
                          Padding(
                            padding: const EdgeInsets.only(bottom: 5.0),
                            child: Text("Payment Type"),
                          ),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<PaymentModeList>(
                                    isExpanded: true,
                                    hint: const Row(
                                      children: [
                                        Expanded(
                                          child: Text(
                                            'Select Payment Type',
                                            style: TextStyle(fontSize: 14),
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                      ],
                                    ),
                                    items:
                                        provider.paymentModeDropDown
                                            .map(
                                              (paymentMode) => DropdownMenuItem<
                                                PaymentModeList
                                              >(
                                                value: paymentMode,
                                                child: Text(
                                                  paymentMode.name ?? '',
                                                  style: const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    value: provider.selectPaymentMode,
                                    onChanged: (PaymentModeList? value) {
                                      if (value != null) {
                                        if (provider
                                            .paymentModeDropDown
                                            .isNotEmpty) {
                                          provider.selectPaymentMode = value;
                                          print(
                                            "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                          );
                                          provider.PaymentMode = value.name;
                                          provider.paymentModeID = value.id;
                                          print(
                                            "hfjkshfg${provider.paymentModeID}",
                                          );
                                        }
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(context, provider.selectPaymentError),
                          SizedBox(height: 10),
                          Padding(
                            padding: const EdgeInsets.only(bottom: 5.0),
                            child: Text("Amount"),
                          ),
                          Container(
                            height: 50,

                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: AppColors.text_field_color,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller: provider.Amountcontroller,
                                onChanged: (value) {
                                  provider.selectAmountError = null;
                                },
                                keyboardType: TextInputType.numberWithOptions(),
                                textInputAction: TextInputAction.next,
                                decoration: InputDecoration(
                                  hintText: "Enter Amount",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          errorWidget(context, provider.selectAmountError),
                          SizedBox(height: 10),
                          Padding(
                            padding: const EdgeInsets.only(bottom: 5.0),
                            child: Text("Reference Number"),
                          ),
                          Container(
                            height: 50,

                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: AppColors.text_field_color,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller: provider.Referencecontroller,
                                keyboardType: TextInputType.text,
                                onChanged: (value) {
                                  provider.ReferenceError = null;
                                },
                                decoration: InputDecoration(
                                  hintText: "Enter Reference Number",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          errorWidget(context, provider.ReferenceError),
                          SizedBox(height: 10),
                          InkResponse(
                            onTap: () {
                              _showAttachmentSheet(context);
                            },
                            child: Container(
                              margin: EdgeInsets.symmetric(vertical: 10),
                              height: 45,
                              width: MediaQuery.of(context).size.width,
                              decoration: BoxDecoration(
                                color: Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(12),
                                border: Border.all(
                                  color: AppColors.app_blue,
                                  width: 0.5,
                                ),
                              ),
                              child: Center(
                                child: Text(
                                  "Reference Document",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ),
                            ),
                          ),
                          if (provider.imagePicked == 1 &&
                              provider.imagePath != null) ...[
                            Padding(
                              padding: const EdgeInsets.symmetric(
                                vertical: 4.0,
                              ),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Expanded(
                                    flex: 5,
                                    child: Text(
                                      "${provider.imagePath}",
                                      style: TextStyle(
                                        color: AppColors.semi_black,
                                        fontSize: 11,
                                        fontWeight: FontWeight.w600,
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 1,
                                    child: InkResponse(
                                      onTap: () {
                                        provider.imagePicked = 0;
                                        provider.imagePath = null;
                                        provider.imageFilePath = null;
                                      },
                                      child: SvgPicture.asset(
                                        "assets/svg/ic_close.svg",
                                        width: 15,
                                        height: 15,
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                          errorWidget(context, provider.imageError),
                        ],
                      ),
                    ),
                  ),
                ),
                floatingActionButtonLocation:
                    FloatingActionButtonLocation.centerFloat,
                floatingActionButton: InkWell(
                  onTap: () {
                    provider.PaymentUpdateAPI(
                      context,
                      provider.Referencecontroller.text,
                      provider.Amountcontroller.text,
                    );
                  },
                  child: Container(
                    alignment: Alignment.center,
                    height: 45,
                    margin: EdgeInsets.only(
                      left: 5.0,
                      right: 5.0,
                      top: 5.0,
                      bottom: 5.0,
                    ),
                    decoration: BoxDecoration(
                      color: AppColors.app_blue, //1487C9
                      borderRadius: BorderRadius.circular(15.0),
                    ),
                    child: Center(
                      child: Text(
                        "Send OTP",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize: 15,
                          fontFamily: "JakartaMedium",
                          color: Colors.white,
                        ),
                      ),
                    ),
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Paymentdetailsprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromGallery(
                                  context,
                                  provider.Referencecontroller.text,
                                  provider.Amountcontroller.text,
                                );
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Select photo from gallery"),
                              ),
                            ),
                            SizedBox(height: 10),
                            InkWell(
                              onTap: () {
                                Navigator.of(context).pop(false);
                                provider.imgFromCamera(
                                  context,
                                  provider.Referencecontroller.text,
                                  provider.Amountcontroller.text,
                                );
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> showOTPSheetSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Paymentdetailsprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Enter OTP",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            Column(
                              children: [
                                Container(
                                  alignment: Alignment.center,

                                  height: 50,
                                  margin: EdgeInsets.only(
                                    left: 5.0,
                                    right: 5.0,
                                  ),
                                  child: PinCodeTextField(
                                    appContext: context,
                                    pastedTextStyle: TextStyle(
                                      fontWeight: FontWeight.bold,
                                    ),
                                    length: 4,
                                    blinkWhenObscuring: true,

                                    animationType: AnimationType.fade,
                                    // validator: (v) {
                                    //   if (v!.length < 3) {
                                    //     return "I'm from validator";
                                    //   } else {
                                    //     return null;
                                    //   }
                                    // },
                                    pinTheme: PinTheme(
                                      shape: PinCodeFieldShape.underline,
                                      borderRadius: BorderRadius.circular(16),
                                      fieldHeight: 60,
                                      fieldWidth: 60,
                                      activeFillColor:
                                          AppColors.text_field_color,
                                      activeColor: AppColors.app_blue,
                                      selectedColor: AppColors.text_field_color,
                                      selectedFillColor:
                                          AppColors.text_field_color,
                                      inactiveFillColor:
                                          AppColors.text_field_color,
                                      inactiveColor: AppColors.text_field_color,
                                      fieldOuterPadding: EdgeInsets.only(
                                        left: 5,
                                        right: 5,
                                      ),
                                      inactiveBorderWidth: 0,
                                      activeBorderWidth: 0.5,
                                    ),
                                    enableActiveFill: true,
                                    keyboardType: TextInputType.number,
                                    boxShadows: const [
                                      BoxShadow(
                                        offset: Offset(0, 1),
                                        color: Colors.black12,
                                        blurRadius: 10,
                                      ),
                                    ],
                                    onCompleted: (String enteredCode) {
                                      provider.enteredOtp = enteredCode;
                                      // clearText = true;
                                      provider.OTPVerifyAPI(context);

                                      debugPrint("Completed");
                                    },
                                    // onTap: () {
                                    //   print("Pressed");
                                    // },
                                    onChanged: (String enteredCode) {
                                      debugPrint(enteredCode);

                                      provider.enteredOtp = enteredCode;
                                    },
                                    onSubmitted: (String enteredCode) {
                                      provider.enteredOtp = enteredCode;
                                      // clearText = true;
                                      // Verify_otp();
                                    },
                                    enablePinAutofill: true,
                                    useExternalAutoFillGroup: true,
                                    beforeTextPaste: (text) {
                                      debugPrint("Allowing to paste $text");
                                      //if you return true then it will show the paste confirmation dialog. Otherwise if false, then nothing will happen.
                                      //but you can show anything you want here, like your pop up saying wrong paste format or etc
                                      return true;
                                    },
                                  ),
                                ),
                                SizedBox(height: 15),
                                Container(
                                  alignment: Alignment.center,
                                  height: 45,
                                  margin: EdgeInsets.only(
                                    left: 5.0,
                                    right: 5.0,
                                    top: 5.0,
                                    bottom: 5.0,
                                  ),
                                  child: InkResponse(
                                    onTap: () {
                                      provider.ResendOtpAPI(context);
                                    },
                                    child: Center(
                                      child: Text(
                                        "Resend",
                                        style: TextStyle(
                                          fontWeight: FontWeight.w300,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),

                                InkResponse(
                                  onTap: () {
                                    Navigator.of(context).pop(false);
                                    provider.OTPVerifyAPI(context);
                                  },
                                  child: Container(
                                    alignment: Alignment.center,
                                    height: 45,
                                    margin: EdgeInsets.only(
                                      left: 5.0,
                                      right: 5.0,
                                      top: 5.0,
                                      bottom: 5.0,
                                    ),
                                    decoration: BoxDecoration(
                                      color: AppColors.app_blue, //1487C9
                                      borderRadius: BorderRadius.circular(15.0),
                                    ),
                                    child: Center(
                                      child: Text(
                                        "Submit",
                                        textAlign: TextAlign.center,
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _addContactSheet(BuildContext context) {
    final controllersNames = [
      "Name",
      "Designation",
      "Mobile Number",
      "Alternate Mobile Number",
      "Telephone Number",
      "Email ID",
    ];

    final hintTextNames = [
      "Enter Name",
      "Enter Designation",
      "Enter Mobile Number",
      "Enter Alternate Mobile Number",
      "Enter Telephone Number",
      "Enter Email ID",
    ];
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Paymentdetailsprovider>(
                builder: (context, provider, child) {
                  final controllers = [
                    provider.nameController,
                    provider.designationController,
                    provider.mobController,
                    provider.altMobController,
                    provider.telController,
                    provider.emailController,
                  ];
                  final Errors = [
                    provider.nameError,
                    provider.designationError,
                    provider.mobError,
                    provider.altMobError,
                    provider.telError,
                    provider.emailError,
                  ];
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                          MediaQuery.of(
                            context,
                          ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            SizedBox(height: 15),
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Add Contact",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),

                            ...List.generate(controllers.length, (index) {
                              return Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text(controllersNames[index]),
                                  Container(
                                    height: 50,
                                    margin: EdgeInsets.symmetric(vertical: 5),
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                      color: AppColors.text_field_color,
                                      borderRadius: BorderRadius.circular(14),
                                    ),
                                    child: Padding(
                                      padding: const EdgeInsets.fromLTRB(
                                        10.0,
                                        0.0,
                                        10,
                                        0,
                                      ),
                                      child: TextFormField(
                                        controller: controllers[index],
                                        focusNode: focusNodes[index],
                                        onChanged: (value) {
                                          Errors[index] = null;
                                        },
                                        maxLength:
                                            [
                                                  "Mobile Number",
                                                  "Alternate Mobile Number",
                                                ].contains(
                                                  controllersNames[index],
                                                )
                                                ? 10
                                                : 228,
                                        maxLines: 1,

                                        keyboardType:
                                            [
                                                  "Mobile Number",
                                                  "Alternate Mobile Number",
                                                  "Mobile Number",
                                                ].contains(
                                                  controllersNames[index],
                                                )
                                                ? TextInputType.numberWithOptions()
                                                : TextInputType.text,
                                        textInputAction:
                                            index == 5
                                                ? TextInputAction.done
                                                : TextInputAction.next,
                                        decoration: InputDecoration(
                                          counterText: "",
                                          hintText: hintTextNames[index],
                                          hintStyle: TextStyle(
                                            fontWeight: FontWeight.w400,
                                            color: Color(0xFFB4BEC0),
                                            fontSize: 14,
                                          ),

                                          enabledBorder: InputBorder.none,
                                          focusedBorder: InputBorder.none,
                                        ),
                                      ),
                                    ),
                                  ),
                                  errorWidget(context, Errors[index]),
                                ],
                              );
                            }),

                            InkWell(
                              onTap: () {
                                provider.AddContactAPIFunction(
                                  context,
                                  widget.accountName,
                                  widget.genId == ""
                                      ? widget.referenceID
                                      : widget.genId,
                                  widget.accountName,
                                  widget.referenceID,
                                  widget.genId,
                                );
                              },
                              child: Container(
                                alignment: Alignment.center,
                                height: 45,
                                margin: EdgeInsets.only(
                                  left: 5.0,
                                  right: 5.0,
                                  top: 5.0,
                                  bottom: 5.0,
                                ),
                                decoration: BoxDecoration(
                                  color: AppColors.app_blue, //1487C9
                                  borderRadius: BorderRadius.circular(14.0),
                                ),
                                child: Center(
                                  child: Text(
                                    "Submit",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(color: Colors.white),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((_) {
        Future.microtask(() {
          var provider = Provider.of<Paymentdetailsprovider>(
            context,
            listen: false,
          );
          provider.LoadNumbersAPI(
            context,
            widget.accountName,
            widget.referenceID,
            widget.genId,
          );
        });
      });
    });
  }
}
