import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/crmProvider/crmDashboardProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/screens/crm/LeadDetailsByMode.dart';
import 'package:generp/screens/crm/followUpUpdateScreen.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Utils/commonWidgets.dart';

class Pendingtasksdetails extends StatefulWidget {
  final detailIndex;

  const Pendingtasksdetails({super.key, required this.detailIndex});

  @override
  State<Pendingtasksdetails> createState() => _PendingtasksdetailsState();
}

class _PendingtasksdetailsState extends State<Pendingtasksdetails> {
  FocusNode focusNode = FocusNode();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((event) {
      setState(() => _source = event);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Crmdashboardprovider>(context, listen: false);
      prov.accessPagesAPIFunction(context);
      prov.crmDashboardAPIFunction(context);
      prov.crmPendingTasksAPIFunction(context);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Crmdashboardprovider>(
      builder: (context, provider, child) {
        var task = provider.pendingTasksLists[widget.detailIndex];
        final subHeadings = [task.aname.toString(), task.appdate ?? "-"];
        final belowSubHeads = [task.conmob.toString(), task.anote ?? "-"];
        final belowHeads = ["Mobile Number", "Note"];
        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: AppBar(
            automaticallyImplyLeading: false,
            // elevation: 2.0,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () {
                      HapticFeedback.selectionClick();
                      Navigator.pop(context, true);
                    },
                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  InkResponse(
                    onTap: () {
                      HapticFeedback.selectionClick();
                      Navigator.pop(context, true);
                    },
                    child: Text(
                      "Pending Tasks",
                      style: TextStyle(
                        fontSize: 16,
                        height: 1.1,
                        fontFamily: "JakartaSemiBold",
                        color: AppColors.semi_black,
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
          body:
              (provider.pendingTasksLists[widget.detailIndex] != null)
                  ? SizedBox(
                    child: Column(
                      children: [
                        InkResponse(
                          onTap: () async {
                            await Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) => LeadDetailsByMode(
                                      mode: "Executive",
                                      pageTitleName: "Lead Details",
                                      leadId: task.leadid,
                                    ),
                              ),
                            );
                          },
                          child: Container(
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(15),
                            ),
                            margin: EdgeInsets.symmetric(
                              vertical: 5,
                              horizontal: 10,
                            ),
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                ...List.generate(subHeadings.length, (j) {
                                  return Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 3,
                                      horizontal: 0,
                                    ),

                                    child: Column(
                                      children: [
                                        Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                subHeadings[j],
                                                style: TextStyle(
                                                  decoration:
                                                      j == 0
                                                          ? TextDecoration
                                                              .underline
                                                          : TextDecoration.none,
                                                  height: j == 0 ? 1 : 1.5,
                                                  decorationStyle:
                                                      TextDecorationStyle
                                                          .dotted,
                                                  decorationColor: Color(
                                                    0xFF676767,
                                                  ),
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color:
                                                      j == 0
                                                          ? AppColors.semi_black
                                                          : AppColors.grey_semi,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                                SizedBox(height: 10),
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: [
                                    Expanded(flex: 1, child: Text("Details")),
                                    Expanded(
                                      flex: 5,
                                      child: DottedLine(
                                        dashGapLength: 4,
                                        dashGapColor: Colors.white,
                                        dashColor: AppColors.grey_semi,
                                        dashLength: 2,
                                        lineThickness: 0.5,
                                      ),
                                    ),
                                  ],
                                ),
                                SizedBox(height: 10),
                                ...List.generate(belowHeads.length, (i) {
                                  return Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 3,
                                      horizontal: 0,
                                    ),

                                    child: Column(
                                      children: [
                                        Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                belowHeads[i],
                                                style: TextStyle(
                                                  color: AppColors.semi_black,
                                                  fontSize: 14,
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              child: InkResponse(
                                                onTap:
                                                    belowHeads[i] ==
                                                            "Mobile Number"
                                                        ? () {
                                                          HapticFeedback.selectionClick();
                                                          launch(
                                                            'tel://${belowSubHeads[i]}',
                                                          );
                                                        }
                                                        : null,
                                                child: Padding(
                                                  padding: const EdgeInsets.all(
                                                    4.0,
                                                  ),
                                                  child: Text(
                                                    belowSubHeads[i],
                                                    style: TextStyle(
                                                      decoration:
                                                          belowHeads[i] ==
                                                                  "Mobile Number"
                                                              ? TextDecoration
                                                                  .underline
                                                              : TextDecoration
                                                                  .none,

                                                      decorationStyle:
                                                          TextDecorationStyle
                                                              .dotted,
                                                      decorationColor: Color(
                                                        0xFF676767,
                                                      ),
                                                      color:
                                                          AppColors.grey_semi,
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                              ],
                            ),
                          ),
                        ),

                        SizedBox(height: 150),
                      ],
                    ),
                  )
                  : Emptywidget(context),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
          floatingActionButton: InkResponse(
            onTap: () async {
              HapticFeedback.selectionClick();
              await Navigator.push(
                context,
                MaterialPageRoute(
                  builder:
                      (context) => Followupupdatescreen(
                        leadID: task.leadid,
                        from: "Pending Tasks",
                      ),
                ),
              );
            },
            child: Container(
              height: 45,
              alignment: Alignment.center,
              margin: EdgeInsets.symmetric(horizontal: 10),
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
              decoration: BoxDecoration(
                color: AppColors.app_blue,
                borderRadius: BorderRadius.circular(15),
              ),
              child: Text(
                "Follow up Update",
                style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",
                  color: Colors.white,
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
