class GetDistrictOnStateResponse {
  String? error;
  List<Districts>? districts;
  String? message;

  GetDistrictOnStateResponse({this.error, this.districts, this.message});

  GetDistrictOnStateResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['districts'] != null) {
      districts = <Districts>[];
      json['districts'].forEach((v) {
        districts!.add(Districts.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (districts != null) {
      data['districts'] = districts!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class Districts {
  String? id;
  String? state;
  String? district;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Districts({
    this.id,
    this.state,
    this.district,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Districts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    state = json['state'];
    district = json['district'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['state'] = state;
    data['district'] = district;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
