class TechnicianLoadNumbersResponse {
  List<PaymentModeList>? paymentModeList;
  List<Contacts>? contacts;
  int? error;
  int? sessionExists;

  TechnicianLoadNumbersResponse({
    this.paymentModeList,
    this.contacts,
    this.error,
    this.sessionExists,
  });

  TechnicianLoadNumbersResponse.fromJson(Map<String, dynamic> json) {
    if (json['payment_mode_list'] != null) {
      paymentModeList = <PaymentModeList>[];
      json['payment_mode_list'].forEach((v) {
        paymentModeList!.add(PaymentModeList.fromJson(v));
      });
    }
    if (json['contacts'] != null) {
      contacts = <Contacts>[];
      json['contacts'].forEach((v) {
        contacts!.add(Contacts.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (paymentModeList != null) {
      data['payment_mode_list'] =
          paymentModeList!.map((v) => v.toJson()).toList();
    }
    if (contacts != null) {
      data['contacts'] = contacts!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class PaymentModeList {
  String? id;
  String? name;

  PaymentModeList({this.id, this.name});

  PaymentModeList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class Contacts {
  String? mob1;
  String? name;

  Contacts({this.mob1, this.name});

  Contacts.fromJson(Map<String, dynamic> json) {
    mob1 = json['mob1'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['mob1'] = mob1;
    data['name'] = name;
    return data;
  }
}
