import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Models/crmModels/GetDistrictOnStateResponse.dart';
import 'package:generp/Models/crmModels/GetSegmentOnTeamResponse.dart';
import 'package:generp/Models/crmModels/GetSourceOnReferenceResponse.dart';
import 'package:generp/Models/crmModels/GetSubLocOnDistrictResponse.dart';
import 'package:generp/Models/crmModels/LeadListViewResponse.dart';
import 'package:generp/Notifiers/crmProvider/LeadListProvider.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:provider/provider.dart';
import 'package:generp/screens/screensExports.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../../Utils/dropdownTheme.dart';
import '../commonDateRangeFilter.dart';

class Leadlistbymode extends StatefulWidget {
  final pageTitleName;
  final mode;
  final filter;

  const Leadlistbymode({
    super.key,
    required this.pageTitleName,
    required this.mode,
    this.filter,
  });

  @override
  State<Leadlistbymode> createState() => _LeadlistbymodeState();
}

class _LeadlistbymodeState extends State<Leadlistbymode> {
  Dropdowntheme ddtheme = Dropdowntheme();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  final ScrollController _scrollController = ScrollController();

  @override
  void initState() {
    super.initState();

    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });

    WidgetsBinding.instance.addPostFrameCallback((_) {
      final provider = Provider.of<Leadlistprovider>(context, listen: false);

      provider.resetPagination();
      if (widget.filter != null) {
        provider.crmLeadListAPIFunction(
          context,
          widget.mode,
          widget.filter!.status,
          widget.filter!.openStatus,
          "",
          "",
          "",
          "",
          "",
        );
      } else {
        provider.crmLeadListAPIFunction(
          context,
          widget.mode,
          "",
          "",
          "",
          "",
          "",
          "",
          "",
        );
      }

      _scrollController.addListener(() {
        if (_scrollController.position.pixels >=
            _scrollController.position.maxScrollExtent - 200) {
          provider.loadMore(
            context,
            widget.mode,
            widget.filter?.status ?? "",
            widget.filter?.openStatus ?? "",
            "",
            "",
            "",
            "",
            "",
          );
        }
      });
    });
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _connectivity.disposeStream();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Leadlistprovider>(
      builder: (context, provider, child) {
        final crmLists = provider.crmLeadList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageTitleName,
            provider.resetForm,
            Row(
              children: [
                InkResponse(
                  onTap: () async {
                    HapticFeedback.selectionClick();
                    final provider = Provider.of<Leadlistprovider>(context, listen: false);
                    // If lists are empty, fetch required data first (this will populate sources, teams, states, employees)
                    if (provider.sourcesList.isEmpty || provider.teamsList.isEmpty || provider.employeesList.isEmpty) {
                      await provider.crmLeadListViewAPIFunction(context, widget.mode);
                    }
                    _showFilterSheetNew(context);
                  },
                  child: SvgPicture.asset(
                    "assets/svg/filter_ic.svg",
                    height: 25,
                  ),
                ),

              ],
            ),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              provider.isLoading
                  ? Center(
                    child: CircularProgressIndicator.adaptive(
                      valueColor: AlwaysStoppedAnimation<Color>(
                        AppColors.app_blue,
                      ),
                    ),
                  )
                  : crmLists.isNotEmpty
                  ? Scrollbar(
                    controller: _scrollController,
                    child: ListView.builder(
                      controller: _scrollController,
                      itemCount:
                          crmLists.length + (provider.hasMoreData ? 1 : 0),
                      itemBuilder: (context, index) {
                        if (index == crmLists.length) {
                          return provider.isLoadingMore
                              ? const Padding(
                                padding: EdgeInsets.all(16),
                                child: Center(
                                  child: CircularProgressIndicator(),
                                ),
                              )
                              : const SizedBox.shrink();
                        }

                        final lead = crmLists[index];
                        return InkResponse(
                          onTap: () async {
                            HapticFeedback.selectionClick();
                            Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) => LeadDetailsByMode(
                                      pageTitleName: widget.pageTitleName,
                                      mode: widget.mode,
                                      leadId:
                                          provider.crmLeadList[index].leadid,
                                    ),
                              ),
                            ).then((_) async {
                              final provider = Provider.of<Leadlistprovider>(context, listen: false);

                              provider.resetPagination();
                              if (widget.filter != null) {
                                provider.crmLeadListAPIFunction(
                                  context,
                                  widget.mode,
                                  widget.filter!.status,
                                  widget.filter!.openStatus,
                                  "",
                                  "",
                                  "",
                                  "",
                                  "",
                                );
                              } else {
                                provider.crmLeadListAPIFunction(
                                  context,
                                  widget.mode,
                                  "",
                                  "",
                                  "",
                                  "",
                                  "",
                                  "",
                                  "",
                                );
                              }
                            });
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16),
                            ),
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: SizedBox(
                                        height: 50,
                                        width: 35,
                                        child: SvgPicture.asset(
                                          "assets/svg/crm/lead_details_list_ic.svg",
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 6,
                                      child: SizedBox(
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              crmLists[index].company!,
                                              maxLines: 1,
                                              overflow: TextOverflow.ellipsis,
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                            Text(
                                              crmLists[index].product ?? "-",
                                              maxLines: 1,
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 12,
                                                color: AppColors.grey_semi,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                            Expanded(
                              flex: 1,
                              child: InkResponse(
                                onTap: () {
                                  HapticFeedback.selectionClick();
                                  _showContactOptions(context, crmLists[index].mob1);
                                },
                                child: SizedBox(
                                  height: 35,
                                  width: 35,
                                  child: SvgPicture.asset(
                                    "assets/svg/crm/lead_list_call_ic.svg",
                                  ),
                                ),
                              ),
                            ),
                                  ],
                                ),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }

  Future<void> _showFilterSheetNew(BuildContext context) {
    List<bool> isSelected = List.generate(
      9,
      (index) => index == 0 ? true : false,
    );

    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Padding(
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: Consumer<Leadlistprovider>(
                  builder: (context, provider, child) {
                    // 🔹 Initialize filter selections from widget.filter only once
                    if (provider.selectedLeadStatus == null &&
                        widget.filter?.status != null &&
                        widget.filter!.status!.toString().isNotEmpty) {
                      provider.selectedLeadStatus = widget.filter!.status;
                    }

                    if (provider.selectedOpenStatus == null &&
                        widget.filter?.openStatus != null &&
                        widget.filter!.openStatus!.toString().isNotEmpty) {
                      provider.selectedOpenStatus = widget.filter!.openStatus;
                    }

                    int selectedIndex = isSelected.indexWhere(
                          (element) => element == true,
                    );
                    final headings = [
                      "Lead Status",
                      "Open/Close Status",
                      "Mobile Number",
                      "Company Name",
                      "Source",
                      "Reference",
                      "Team",
                      "Segment",
                    ];
                    if (widget.mode != "executive") {
                      headings.add("Employee");
                    }
                    // int selectedIndex = isSelected.indexWhere(
                    //   (element) => element == true,
                    // );
                    // final headings = [
                    //   "Lead Status",
                    //   "Open/Close Status",
                    //   "Mobile Number",
                    //   "Company Name",
                    //   "Source",
                    //   "Reference",
                    //   "Team",
                    //   "Segment",
                    // ];
                    if (widget.mode != "executive") {
                      headings.add("Employee");
                    }
                    return SizedBox(
                      height: MediaQuery.of(context).size.height * 0.7,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Padding(
                            padding: EdgeInsets.only(left: 15),
                            child: Text(
                              "Filter",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 18,
                                fontFamily: "JakartaSemiBold",
                              ),
                            ),
                          ),
                          const SizedBox(height: 20),
                          Expanded(
                            child: Container(
                              decoration: BoxDecoration(
                                border: Border(
                                  top: BorderSide(
                                    color: const Color(0xFFA5DAF9),
                                  ),
                                  bottom: BorderSide(
                                    color: const Color(0xFFA5DAF9),
                                  ),
                                ),
                              ),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 3,
                                    child: Column(
                                      children: List.generate(headings.length, (
                                        jj,
                                      ) {
                                        return Expanded(
                                          child: InkResponse(
                                            onTap: () {
                                              setState(() {
                                                isSelected = List.generate(
                                                  headings.length,
                                                  (index) => false,
                                                );
                                                isSelected[jj] = true;
                                              });
                                            },
                                            child: Container(
                                              padding:
                                                  const EdgeInsets.symmetric(
                                                    vertical: 7.5,
                                                    horizontal: 10,
                                                  ),
                                              decoration: BoxDecoration(
                                                border: Border(
                                                  left:
                                                      isSelected[jj]
                                                          ? BorderSide(
                                                            color:
                                                                AppColors
                                                                    .app_blue,
                                                            width: 5.0,
                                                          )
                                                          : const BorderSide(
                                                            color:
                                                                Colors
                                                                    .transparent,
                                                          ),
                                                  bottom:
                                                      jj == headings.length - 1
                                                          ? const BorderSide(
                                                            color:
                                                                Colors
                                                                    .transparent,
                                                          )
                                                          : const BorderSide(
                                                            color: Color(
                                                              0xFFA5DAF9,
                                                            ),
                                                          ),
                                                ),
                                                color: const Color(0xFFE6F6FF),
                                              ),
                                              child: Row(
                                                children: [
                                                  Expanded(
                                                    child: Text(
                                                      headings[jj],
                                                      textAlign:
                                                          TextAlign.center,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                      ),
                                                    ),
                                                  ),
                                                  if (_isFilterSelected(
                                                    provider,
                                                    jj,
                                                  )) ...[
                                                    Container(
                                                      margin: EdgeInsets.only(
                                                        left: 5,
                                                      ),
                                                      width: 8,
                                                      height: 8,
                                                      decoration: BoxDecoration(
                                                        color: Colors.green,
                                                        shape: BoxShape.circle,
                                                      ),
                                                    ),
                                                  ],
                                                ],
                                              ),
                                            ),
                                          ),
                                        );
                                      }),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 5,
                                    child: SingleChildScrollView(
                                      padding: const EdgeInsets.symmetric(
                                        horizontal: 10,
                                        vertical: 5,
                                      ),
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        mainAxisSize: MainAxisSize.min,
                                        children: [
                                          if (selectedIndex == 0) ...[
                                            ...provider.leadStatusList.map((status,) {// here i want to do that i want to show selected from widget.filter!.status,
                                              return SizedBox(
                                                height: 35,
                                                child: CheckboxListTile(
                                                  activeColor: AppColors.app_blue,
                                                  controlAffinity: ListTileControlAffinity.leading,
                                                  checkboxShape: CircleBorder(
                                                    side: BorderSide(
                                                      width: 0.5,
                                                    ),
                                                  ),
                                                  title: Text(
                                                    status ?? 'Unknown Status',
                                                    style: const TextStyle(
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                  value:
                                                      provider
                                                          .selectedLeadStatus ==
                                                      status,
                                                  onChanged: (bool? value) {
                                                    setState(() {
                                                      provider.selectedLeadStatus =
                                                          value == true
                                                              ? status
                                                              : null;
                                                    });
                                                  },
                                                  contentPadding:
                                                      EdgeInsets.zero,
                                                ),
                                              );
                                            }),
                                          ] else if (selectedIndex == 1) ...[
                                            ...provider.openStatusList.map((
                                              status,
                                            ) {
                                              return SizedBox(
                                                height: 35,
                                                child: CheckboxListTile(
                                                  activeColor:
                                                      AppColors.app_blue,
                                                  controlAffinity:
                                                      ListTileControlAffinity
                                                          .leading,
                                                  checkboxShape: CircleBorder(
                                                    side: BorderSide(
                                                      width: 0.5,
                                                    ),
                                                  ),
                                                  title: Text(// same here widget.filter!.openStatus,
                                                    status ?? 'Unknown Status',
                                                    style: const TextStyle(
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                  value:
                                                      provider
                                                          .selectedOpenStatus ==
                                                      status,
                                                  onChanged: (bool? value) {
                                                    setState(() {
                                                      provider.selectedOpenStatus =
                                                          value == true
                                                              ? status
                                                              : null;
                                                    });
                                                  },
                                                  contentPadding:
                                                      EdgeInsets.zero,
                                                ),
                                              );
                                            }),
                                          ] else if (selectedIndex == 2) ...[
                                            textControllerWidget(
                                              context,
                                              provider.mobileNumberController,
                                              "Mobile Number",
                                              "Enter Mobile Number",
                                              provider.onChangedMobileNum,
                                              TextInputType.number,
                                              false,
                                              FilteringTextInputFormatter
                                                  .digitsOnly,
                                            ),
                                          ] else if (selectedIndex == 3) ...[
                                            textControllerWidget(
                                              context,
                                              provider.companyNameController,
                                              "Company Name",
                                              "Enter Company Name",
                                              provider.onChangedCompanyName,
                                              TextInputType.text,
                                              false,
                                              null,
                                            ),
                                          ] else if (selectedIndex == 4) ...[
                                            if (provider.sourcesList.isEmpty)
                                              errorWidget(
                                                context,
                                                "No Sources Available",
                                              )
                                            else
                                              ...provider.sourcesList.map((
                                                source,
                                              ) {
                                                if (source.id == null ||
                                                    source.name == null) {
                                                  return SizedBox.shrink();
                                                }
                                                return SizedBox(
                                                  height: 35,
                                                  child: CheckboxListTile(
                                                    activeColor:
                                                        AppColors.app_blue,
                                                    controlAffinity:
                                                        ListTileControlAffinity
                                                            .leading,
                                                    checkboxShape: CircleBorder(
                                                      side: BorderSide(
                                                        width: 0.5,
                                                      ),
                                                    ),
                                                    title: Text(
                                                      source.name!,
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                    value:
                                                        provider
                                                            .selectedSource ==
                                                        source,
                                                    onChanged: (bool? value) {
                                                      setState(() {
                                                        if (value == true) {
                                                          provider.selectedSource =
                                                              source;
                                                        } else {
                                                          provider.selectedSource =
                                                              null;
                                                          provider
                                                              .referencesList
                                                              .clear();
                                                          provider.selectedReference =
                                                              null;
                                                          provider.selectedReferenceId =
                                                              null;
                                                          provider.selectedReferenceValue =
                                                              null;
                                                        }
                                                        provider.crmLeadListSourceOnReferenceAPIFunction(
                                                          context,
                                                          widget.mode,
                                                          provider
                                                              .selectedSourceId,
                                                        );
                                                      });
                                                    },
                                                    contentPadding:
                                                        EdgeInsets.zero,
                                                  ),
                                                );
                                              }),
                                          ] else if (selectedIndex == 5) ...[
                                            if (provider
                                                .referencesList
                                                .isEmpty) ...[
                                              errorWidget(
                                                context,
                                                "Please Select Source First",
                                              ),
                                            ] else ...[
                                              ...provider.referencesList.map((
                                                reference,
                                              ) {
                                                if (reference.id == null ||
                                                    reference.name == null) {
                                                  return SizedBox.shrink();
                                                }
                                                return SizedBox(
                                                  height: 35,
                                                  child: CheckboxListTile(
                                                    activeColor:
                                                        AppColors.app_blue,
                                                    controlAffinity:
                                                        ListTileControlAffinity
                                                            .leading,
                                                    checkboxShape: CircleBorder(
                                                      side: BorderSide(
                                                        width: 0.5,
                                                      ),
                                                    ),
                                                    title: Text(
                                                      reference.name!,
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                    value:
                                                        provider
                                                            .selectedReference ==
                                                        reference,
                                                    onChanged: (bool? value) {
                                                      setState(() {
                                                        provider.selectedReference =
                                                            value == true
                                                                ? reference
                                                                : null;
                                                      });
                                                    },
                                                    contentPadding:
                                                        EdgeInsets.zero,
                                                  ),
                                                );
                                              }),
                                            ],
                                          ] else if (selectedIndex == 6) ...[
                                            if (provider.teamsList.isEmpty)
                                              errorWidget(
                                                context,
                                                "No Teams Available",
                                              )
                                            else
                                              ...provider.teamsList.map((team) {
                                                if (team.id == null ||
                                                    team.name == null) {
                                                  return SizedBox.shrink();
                                                }
                                                return SizedBox(
                                                  height: 35,
                                                  child: CheckboxListTile(
                                                    activeColor:
                                                        AppColors.app_blue,
                                                    controlAffinity:
                                                        ListTileControlAffinity
                                                            .leading,
                                                    checkboxShape: CircleBorder(
                                                      side: BorderSide(
                                                        width: 0.5,
                                                      ),
                                                    ),
                                                    title: Text(
                                                      team.name!,
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                    value:
                                                        provider.selectedTeam ==
                                                        team,
                                                    onChanged: (bool? value) {
                                                      setState(() {
                                                        if (value == true) {
                                                          provider.selectedTeam =
                                                              team;
                                                        } else {
                                                          provider.selectedTeam =
                                                              null;
                                                          provider.segmentsList
                                                              .clear();
                                                          provider.selectedSegment =
                                                              null;
                                                          provider.selectedSegmentId =
                                                              null;
                                                          provider.selectedSegmentValue =
                                                              null;
                                                        }
                                                        provider
                                                            .crmLeadListSegmentOnTeamAPIFunction(
                                                              context,
                                                              widget.mode,
                                                              provider
                                                                  .selectedTeamId,
                                                            );
                                                      });
                                                    },
                                                    contentPadding:
                                                        EdgeInsets.zero,
                                                  ),
                                                );
                                              }),
                                          ] else if (selectedIndex == 7) ...[
                                            if (provider
                                                .segmentsList
                                                .isEmpty) ...[
                                              errorWidget(
                                                context,
                                                "Please Select Team First",
                                              ),
                                            ] else ...[
                                              ...provider.segmentsList.map((
                                                segment,
                                              ) {
                                                if (segment.id == null ||
                                                    segment.name == null) {
                                                  return SizedBox.shrink();
                                                }
                                                return SizedBox(
                                                  height: 35,
                                                  child: CheckboxListTile(
                                                    activeColor:
                                                        AppColors.app_blue,
                                                    controlAffinity:
                                                        ListTileControlAffinity
                                                            .leading,
                                                    checkboxShape: CircleBorder(
                                                      side: BorderSide(
                                                        width: 0.5,
                                                      ),
                                                    ),
                                                    title: Text(
                                                      segment.name!,
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                    value:
                                                        provider
                                                            .selectedSegment ==
                                                        segment,
                                                    onChanged: (bool? value) {
                                                      setState(() {
                                                        provider.selectedSegment =
                                                            value == true
                                                                ? segment
                                                                : null;
                                                      });
                                                    },
                                                    contentPadding:
                                                        EdgeInsets.zero,
                                                  ),
                                                );
                                              }),
                                            ],
                                          ] else if (widget.mode !=
                                              "executive") ...[
                                            if (provider.employeesList.isEmpty)
                                              errorWidget(
                                                context,
                                                "No Employees Available",
                                              )
                                            else
                                              ...provider.employeesList.map((
                                                employee,
                                              ) {
                                                if (employee.id == null ||
                                                    employee.name == null) {
                                                  return SizedBox.shrink();
                                                }
                                                return SizedBox(
                                                  height: 35,
                                                  child: CheckboxListTile(
                                                    activeColor:
                                                        AppColors.app_blue,
                                                    controlAffinity:
                                                        ListTileControlAffinity
                                                            .leading,
                                                    checkboxShape: CircleBorder(
                                                      side: BorderSide(
                                                        width: 0.5,
                                                      ),
                                                    ),
                                                    title: Text(
                                                      employee.name!,
                                                      style: const TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                    value:
                                                        provider
                                                            .selectedEmployee ==
                                                        employee,
                                                    onChanged: (bool? value) {
                                                      setState(() {
                                                        provider.selectedEmployee =
                                                            value == true
                                                                ? employee
                                                                : null;
                                                      });
                                                    },
                                                    contentPadding:
                                                        EdgeInsets.zero,
                                                  ),
                                                );
                                              }),
                                          ],
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                          Padding(
                            padding: const EdgeInsets.symmetric(
                              horizontal: 15,
                              vertical: 20,
                            ),
                            child: InkResponse(
                              onTap: () {
                                provider.crmLeadListAPIFunction(
                                  context,
                                  widget.mode,
                                  provider.selectedLeadStatus,
                                  provider.selectedOpenStatus,
                                  provider.selectedSourceId,
                                  provider.selectedReferenceId,
                                  provider.selectedTeamId,
                                  provider.selectedSegmentId,
                                  provider.selectedAlphabet,
                                );
                                Navigator.pop(context);
                              },
                              child: Container(
                                height: 45,
                                alignment: Alignment.center,
                                decoration: BoxDecoration(
                                  color: AppColors.app_blue,
                                  borderRadius: BorderRadius.circular(15),
                                ),
                                child: const Text(
                                  "Search",
                                  style: TextStyle(
                                    fontSize: 15,
                                    fontFamily: "JakartaMedium",
                                    color: Colors.white,
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            );
          },
        );
      },
    );
  }

  void _showContactOptions(BuildContext context, String? phoneNumber) {
    if (phoneNumber == null || phoneNumber.isEmpty) {
      ScaffoldMessenger.of(context).showSnackBar(
        const SnackBar(content: Text("No phone number available")),
      );
      return;
    }

    showModalBottomSheet(
      context: context,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(top: Radius.circular(20)),
      ),
      backgroundColor: Colors.white,
      builder: (BuildContext context) {
        return Padding(
          padding: const EdgeInsets.symmetric(vertical: 16, horizontal: 20),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Container(
                width: 40,
                height: 4,
                decoration: BoxDecoration(
                  color: Colors.grey.shade400,
                  borderRadius: BorderRadius.circular(10),
                ),
              ),
              const SizedBox(height: 16),
              Text(
                "Contact Options",
                style: TextStyle(
                  fontSize: 18,
                  color: AppColors.app_blue,
                  fontFamily: "JakartaMedium",
                ),
              ),
              const SizedBox(height: 20),

              // --- Call Option ---
              ListTile(
                leading: const Icon(Icons.phone, color: Colors.green),
                title: const Text("Call", style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",

                )
                ),
                onTap: () async {
                  Navigator.pop(context);
                  final uri = Uri.parse("tel:$phoneNumber");
                  await launchUrl(uri, mode: LaunchMode.externalApplication);
                },
              ),

              // --- WhatsApp Option ---
              ListTile(
                leading: SvgPicture.asset(
                  "assets/svg/whatsapp_ic.svg",
                  width: 23,
                  height: 23,
                ),
                title: const Text("WhatsApp", style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",
                )
                ),
                onTap: () async {
                  Navigator.pop(context);
                  final message = Uri.encodeComponent("Hello, I’d like to connect with you.");
                  final whatsappUri = Uri.parse("https://wa.me/$phoneNumber?text=$message");

                  if (await canLaunchUrl(whatsappUri)) {
                    await launchUrl(whatsappUri, mode: LaunchMode.externalApplication);
                  } else {
                    ScaffoldMessenger.of(context).showSnackBar(
                      const SnackBar(content: Text("WhatsApp not installed or invalid number")),
                    );
                  }
                },
              ),
            ],
          ),
        );
      },
    );
  }


  bool _isFilterSelected(Leadlistprovider provider, int index) {
    switch (index) {
      case 0:
        return provider.selectedLeadStatus != null;
      case 1:
        return provider.selectedOpenStatus != null;
      case 2:
        return provider.mobileNumberController.text.isNotEmpty;
      case 3:
        return provider.companyNameController.text.isNotEmpty;
      case 4:
        return provider.selectedSource != null;
      case 5:
        return provider.selectedReference != null;
      case 6:
        return provider.selectedTeam != null;
      case 7:
        return provider.selectedSegment != null;
      case 8:
        return provider.selectedEmployee != null;
      default:
        return false;
    }
  }
}
