class paymentListByModeResponse {
  String? error;
  List<OrderList>? orderList;
  String? message;

  paymentListByModeResponse({this.error, this.orderList, this.message});

  paymentListByModeResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['order_list'] != null) {
      orderList = <OrderList>[];
      json['order_list'].forEach((v) {
        orderList!.add(OrderList.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (orderList != null) {
      data['order_list'] = orderList!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class OrderList {
  String? attachment;
  String? paymentId;
  String? orderNumber;
  String? status;
  String? ename;
  String? aname;
  String? approvalEmployee;
  String? paymentType;
  String? refId;
  String? refType;
  String? refNo;
  String? approvalStatus;
  String? paymentDate;
  String? approvalEmpId;
  String? adjustedAmount;
  String? description;
  String? amount;
  String? datetime;

  OrderList({
    this.attachment,
    this.paymentId,
    this.orderNumber,
    this.status,
    this.ename,
    this.aname,
    this.approvalEmployee,
    this.paymentType,
    this.refId,
    this.refType,
    this.refNo,
    this.approvalStatus,
    this.paymentDate,
    this.approvalEmpId,
    this.adjustedAmount,
    this.description,
    this.amount,
    this.datetime,
  });

  OrderList.fromJson(Map<String, dynamic> json) {
    attachment = json['attachment'];
    paymentId = json['payment_id'];
    orderNumber = json['order_number'];
    status = json['status'];
    ename = json['ename'];
    aname = json['aname'];
    approvalEmployee = json['approval_employee'];
    paymentType = json['payment_type'];
    refId = json['ref_id'];
    refType = json['ref_type'];
    refNo = json['ref_no'];
    approvalStatus = json['approval_status'];
    paymentDate = json['payment_date'];
    approvalEmpId = json['approval_emp_id'];
    adjustedAmount = json['adjusted_amount'];
    description = json['description'];
    amount = json['amount'];
    datetime = json['datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['attachment'] = attachment;
    data['payment_id'] = paymentId;
    data['order_number'] = orderNumber;
    data['status'] = status;
    data['ename'] = ename;
    data['aname'] = aname;
    data['approval_employee'] = approvalEmployee;
    data['payment_type'] = paymentType;
    data['ref_id'] = refId;
    data['ref_type'] = refType;
    data['ref_no'] = refNo;
    data['approval_status'] = approvalStatus;
    data['payment_date'] = paymentDate;
    data['approval_emp_id'] = approvalEmpId;
    data['adjusted_amount'] = adjustedAmount;
    data['description'] = description;
    data['amount'] = amount;
    data['datetime'] = datetime;
    return data;
  }
}
