class crmPendingTasksResponse {
  List<PendingTasks>? pendingTasks;
  String? error;
  String? message;

  crmPendingTasksResponse({this.pendingTasks, this.error, this.message});

  crmPendingTasksResponse.fromJson(Map<String, dynamic> json) {
    if (json['pending_tasks'] != null) {
      pendingTasks = <PendingTasks>[];
      json['pending_tasks'].forEach((v) {
        pendingTasks!.add(PendingTasks.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (pendingTasks != null) {
      data['pending_tasks'] = pendingTasks!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class PendingTasks {
  String? conmob;
  String? aname;
  String? appdate;
  String? atype;
  String? anote;
  String? leadid;
  String? lstatus;
  String? lempid;
  String? aid;

  PendingTasks({
    this.conmob,
    this.aname,
    this.appdate,
    this.atype,
    this.anote,
    this.leadid,
    this.lstatus,
    this.lempid,
    this.aid,
  });

  PendingTasks.fromJson(Map<String, dynamic> json) {
    conmob = json['conmob'];
    aname = json['aname'];
    appdate = json['appdate'];
    atype = json['atype'];
    anote = json['anote'];
    leadid = json['leadid'];
    lstatus = json['lstatus'];
    lempid = json['lempid'];
    aid = json['aid'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['conmob'] = conmob;
    data['aname'] = aname;
    data['appdate'] = appdate;
    data['atype'] = atype;
    data['anote'] = anote;
    data['leadid'] = leadid;
    data['lstatus'] = lstatus;
    data['lempid'] = lempid;
    data['aid'] = aid;
    return data;
  }
}
