class GetSubLocOnDistrictResponse {
  String? error;
  List<SubLocations>? subLocations;
  String? message;

  GetSubLocOnDistrictResponse({this.error, this.subLocations, this.message});

  GetSubLocOnDistrictResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['sub_locations'] != null) {
      subLocations = <SubLocations>[];
      json['sub_locations'].forEach((v) {
        subLocations!.add(SubLocations.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (subLocations != null) {
      data['sub_locations'] = subLocations!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class SubLocations {
  String? id;
  String? districtId;
  String? subLocality;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  SubLocations({
    this.id,
    this.districtId,
    this.subLocality,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  SubLocations.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    districtId = json['district_id'];
    subLocality = json['sub_locality'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['district_id'] = districtId;
    data['sub_locality'] = subLocality;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
