class GetSegmentOnTeamResponse {
  String? error;
  List<Segments>? segments;
  String? message;

  GetSegmentOnTeamResponse({this.error, this.segments, this.message});

  GetSegmentOnTeamResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['segments'] != null) {
      segments = <Segments>[];
      json['segments'].forEach((v) {
        segments!.add(Segments.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (segments != null) {
      data['segments'] = segments!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class Segments {
  String? id;
  String? teamId;
  String? name;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Segments({
    this.id,
    this.teamId,
    this.name,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Segments.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    teamId = json['team_id'];
    name = json['name'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['team_id'] = teamId;
    data['name'] = name;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
