import 'dart:io';

import 'package:dotted_line/dotted_line.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/ordersProvider/editPaymentProvider.dart';
import 'package:generp/Notifiers/ordersProvider/paymentsProvider.dart';
import 'package:generp/Utils/dropdownTheme.dart';
import 'package:generp/screens/order/editAdjustedOrderList.dart';
import 'package:provider/provider.dart';
import '../../Models/ordersModels/EditPaymentDetailsAdjustedOrdersViewResponse.dart'
    show EditPaidList;

import '../../Models/ordersModels/paymentDetailsByModeFilterResponse.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../finance/FileViewer.dart';
import 'editPaymentDetailsByMode.dart';
import 'ordersDetailsByModes.dart';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:generp/Utils/commonServices.dart';

class Paymentdetailsbymode extends StatefulWidget {
  final pageTitleName;
  final paymentId;
  final mode;

  const Paymentdetailsbymode({
    super.key,
    required this.pageTitleName,
    required this.paymentId,
    required this.mode,
  });

  @override
  State<Paymentdetailsbymode> createState() => _PaymentdetailsbymodeState();
}

class _PaymentdetailsbymodeState extends State<Paymentdetailsbymode> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;
  Dropdowntheme ddtheme = Dropdowntheme();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Paymentsprovider>(context, listen: false);
      provider.paymentsDetailsByModeAPIFunction(
        context,
        widget.paymentId,
        widget.mode,
      );
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  Color getDecorationColor(value) {
    var color = AppColors.approved_bg_color;
    switch (value) {
      case 'Registered':
        return AppColors.requested_bg_color;
      case 'Level 1 Approved':
        return AppColors.approved_bg_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_bg_color;
      case 'Level 2 Approved':
        return AppColors.approved_bg_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_bg_color;
      case 'Sales Order Registered':
        return AppColors.processed_bg_color;
      case 'Dispatched':
        return AppColors.approved_bg_color;
    }
    return color;
  }

  Color getTextColor(value) {
    var color = AppColors.approved_text_color;
    switch (value) {
      case 'Registered':
        return AppColors.requested_text_color;
      case 'Level 1 Approved':
        return AppColors.approved_text_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_text_color;
      case 'Level 2 Approved':
        return AppColors.approved_text_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_text_color;
      case 'Sales Order Registered':
        return AppColors.processed_text_color;
      case 'Dispatched':
        return AppColors.approved_text_color;
    }
    return color;
  }

  getText(value) {
    var text = "R";
    switch (value) {
      case 'Registered':
        return "R";
      case 'Level 1 Approved':
        return "L1A";
      case 'Level 1 Rejected':
        return "L1R";
      case 'Level 2 Approved':
        return "L2A";
      case 'Level 2 Rejected':
        return "L2R";
      case 'Sales Order Registered':
        return "SOR";
      case 'Dispatched':
        return "D";
    }
    return text;
  }

  //All","Registered","Level 1 Approved","Level 2 Approved","Level 1 Rejected",
  // Level 2 Rejected","Level 2 Rejected Final","Sales Order Registered","Dispatched"

  double getSize(value) {
    var text = "A";
    switch (value) {
      case 'Registered':
        return 16.0;
      case 'Level 1 Approved':
        return 13.0;
      case 'Level 1 Rejected':
        return 13.0;
      case 'Level 2 Approved':
        return 13.0;
      case 'Level 2 Rejected':
        return 13.0;
      case 'Processed':
        return 16.0;
      case 'Sales Order Registered':
        return 13.0;
      case 'Dispatched':
        return 16.0;
    }
    return 18.0;
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Paymentsprovider>(
                  context,
                  listen: false,
                ).resetAll();

                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer2<Paymentsprovider, Editpaymentprovider>(
      builder: (context, provider, editProvider, child) {
        var paymentDetails = provider.paymentDetails;
        var adjustList = provider.paidLists;
        final headings2 = [
          "Payment Type",
          "Payment Reference Number",
          "Payment Date",
          "Adjusted Amount",
          "Amount",
        ];
        final subHeadings2 = [
          paymentDetails.paymentType ?? "-",
          paymentDetails.refNo ?? "-",
          paymentDetails.paymentDate ?? "-",
          paymentDetails.adjustedAmount ?? "-",
          paymentDetails.amount ?? "-",
        ];

        final headings3 = [
          "Entered By",
          "Approved Employee",
          "Created Datetime",
          "Description",
        ];
        final subHeadings3 = [
          paymentDetails.enteredEmpName ?? "-",
          paymentDetails.approvalEmployee ?? "-",
          paymentDetails.datetime ?? "-",
          paymentDetails.description ?? "-",
        ];

        final sections = [
          if (provider.showMoreDetails) ...[
            {
              "title": "payment Details",
              "headings": headings2,
              "subHeadings": subHeadings2,
            },

            {
              "title": "Other Details",
              "headings": headings3,
              "subHeadings": subHeadings3,
            },
          ],
        ];
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageTitleName,
            provider.resetAll,
            SizedBox.shrink(),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Column(
              children: [
                Card(
                  margin: EdgeInsets.symmetric(horizontal: 0, vertical: 2),
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(30),
                      bottomRight: Radius.circular(30),
                    ),
                  ),
                  elevation: 2,
                  child: Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.only(
                        bottomLeft: Radius.circular(30),
                        bottomRight: Radius.circular(30),
                      ),
                    ),
                    // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                    child: Column(
                      children: [
                        Row(
                          children: [
                            Expanded(
                              flex: 1,
                              child: Container(
                                height: 45,
                                width: 45,
                                padding: EdgeInsets.all(7.5),
                                decoration: BoxDecoration(
                                  color: Color(0xFFE6F6FF),
                                  shape: BoxShape.circle,
                                  // borderRadius: BorderRadius.circular(8),
                                ),
                                child: SvgPicture.asset(
                                  "assets/svg/fin_ic.svg",
                                ),
                              ),
                            ),
                            SizedBox(width: 10),
                            Expanded(
                              flex: 4,
                              child: SizedBox(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    InkResponse(
                                      onTap: () {},
                                      child: Padding(
                                        padding: const EdgeInsets.only(
                                          top: 8.0,
                                          bottom: 4,
                                        ),
                                        child: Text(
                                          paymentDetails.accountName == ""
                                              ? "-"
                                              : paymentDetails.accountName ??
                                                  "-",
                                          style: TextStyle(
                                            decoration:
                                                TextDecoration.underline,
                                            decorationStyle:
                                                TextDecorationStyle.dotted,
                                            decorationColor:
                                                AppColors.grey_thick,
                                            height: 1.2,
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                    ),
                                    Text(
                                      paymentDetails.amount == ""
                                          ? "-"
                                          : "₹${paymentDetails.amount}",
                                      style: TextStyle(
                                        fontFamily: "JakartaRegular",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),

                            Expanded(
                              flex: 2,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  horizontal: 5,
                                  vertical: 10,
                                ),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: getDecorationColor(
                                    paymentDetails.status ?? "-",
                                  ),
                                ),
                                child: Center(
                                  child: Text(
                                    paymentDetails.status ?? "-",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: getTextColor(
                                        paymentDetails.status,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ),
                            if (paymentDetails.status == "Registered") ...[
                              Expanded(
                                flex: 1,
                                child: InkResponse(
                                  onTap: () async {
                                    var res = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (
                                              context,
                                            ) => Editpaymentdetailsbymode(
                                              pageTitleName:
                                                  "Edit Payment (${widget.mode})",
                                              mode: widget.mode,
                                              values: {
                                                "payment_id":
                                                    provider
                                                        .paymentDetails
                                                        .paymentId,
                                                "description":
                                                    provider
                                                        .paymentDetails
                                                        .description,
                                                "amount":
                                                    provider
                                                        .paymentDetails
                                                        .amount,
                                                "payment_mode":
                                                    provider
                                                        .paymentDetails
                                                        .paymentType,
                                                "pay_ref":
                                                    provider
                                                        .paymentDetails
                                                        .refNo,
                                                "pay_received_date":
                                                    provider
                                                        .paymentDetails
                                                        .paymentDate,
                                              },
                                            ),
                                        settings: RouteSettings(
                                          name: 'Editorderaccountdetails',
                                        ),
                                      ),
                                    );
                                    if (res == true) {
                                      provider.paymentsDetailsByModeAPIFunction(
                                        context,
                                        widget.paymentId,
                                        widget.mode,
                                      );
                                    }
                                  },
                                  child: Container(
                                    height: 32,
                                    width: 30,
                                    padding: EdgeInsets.all(8.0),
                                    child: SvgPicture.asset(
                                      "assets/svg/crm/lead_details_edit_ic.svg",
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ],
                        ),
                        SizedBox(height: 10),
                        Column(
                          children: List.generate(sections.length, (
                            sectionIndex,
                          ) {
                            final section = sections[sectionIndex];
                            final title = section["title"] as String;
                            final headings =
                                section["headings"] as List<String>;
                            final subHeadings =
                                section["subHeadings"] as List<String>;

                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Container(
                                  padding: EdgeInsets.symmetric(vertical: 4),
                                  child: Row(
                                    children: [
                                      Expanded(
                                        flex: 3,
                                        child: Text(
                                          title,
                                          style: TextStyle(
                                            fontSize: 14,
                                            fontFamily: "JakartaSemiBold",
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        flex: 6,
                                        child: DottedLine(
                                          dashGapLength: 4,
                                          dashGapColor: Colors.white,
                                          dashColor: AppColors.grey_semi,
                                          dashLength: 2,
                                          lineThickness: 0.5,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),

                                Column(
                                  children: List.generate(headings.length, (j) {
                                    return Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              headings[j],
                                              style: TextStyle(
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: InkResponse(
                                              onTap:
                                                  subHeadings[j] == "View"
                                                      ? () {}
                                                      : null,
                                              child: Text(
                                                subHeadings[j].isEmpty
                                                    ? "-"
                                                    : subHeadings[j],
                                                textAlign: TextAlign.right,
                                                style: TextStyle(
                                                  fontSize: 14,

                                                  decoration:
                                                      subHeadings[j] == "View"
                                                          ? TextDecoration
                                                              .underline
                                                          : TextDecoration.none,
                                                  decorationColor:
                                                      AppColors.app_blue,
                                                  color:
                                                      subHeadings[j] == "View"
                                                          ? AppColors.app_blue
                                                          : Color(0xFF818181),
                                                ),
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  }),
                                ),
                              ],
                            );
                          }),
                        ),

                        InkResponse(
                          onTap: () async {
                            provider.showMoreDetails =
                                !provider.showMoreDetails;
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(vertical: 5),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  provider.showMoreDetails
                                      ? "Hide Details"
                                      : "View Details",
                                  style: TextStyle(
                                    fontFamily: "JakartaMedium",
                                    fontSize: 14,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                                Transform.flip(
                                  flipY:
                                      provider.showMoreDetails ? true : false,
                                  child: SvgPicture.asset(
                                    "assets/svg/arrow_dropdown.svg",
                                    height: 25,
                                    width: 20,
                                    color: AppColors.app_blue,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                        SizedBox(height: 10),
                      ],
                    ),
                  ),
                ),

                if (adjustList.isNotEmpty) ...[
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(top: 10, left: 10, right: 10),
                    child: Row(
                      children: [
                        Text(
                          "Adjusted Order List",
                          style: TextStyle(
                            fontSize: 14,
                            color: AppColors.grey_thick,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                        Spacer(),
                        InkResponse(
                          onTap: () async {
                            await editProvider
                                .editPaymentDetailsAdjustedOrdersViewAPIFunction(
                                  context,
                                  paymentDetails.paymentId,
                                );
                            Future.delayed(Duration(milliseconds: 500), () {
                              _showAddAdjustedOrderSheet(
                                context,
                                paymentDetails.paymentId,
                                widget.mode,
                              );
                            });
                          },
                          child: Padding(
                            padding: const EdgeInsets.all(8.0),
                            child: Text(
                              textAlign: TextAlign.right,
                              "+ Add Order",
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                  ListView.builder(
                    scrollDirection: Axis.vertical,
                    shrinkWrap: true,
                    physics: NeverScrollableScrollPhysics(),
                    itemCount: adjustList.length,
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),

                    itemBuilder: (context, lp) {
                      return InkResponse(
                        onTap: () async {
                          // await Navigator.push(
                          //   context,
                          //   MaterialPageRoute(
                          //     builder:
                          //         (context) => Editadjustedorderlist(
                          //           mode: widget.mode,
                          //           pageTitleName:
                          //               "Edit Adjusted Order List (${widget.mode})",
                          //
                          //           values: {
                          //             "account_id":
                          //                 provider.paymentDetails.accId,
                          //             "payment_id":
                          //                 provider.paymentDetails.paymentId,
                          //             "orders":
                          //                 provider.paidLists
                          //                     .map(
                          //                       (order) => {
                          //                         "order_number":
                          //                             order.orderNumber,
                          //                         "amount":
                          //                             order.adjustedAmount,
                          //                       },
                          //                     )
                          //                     .toList(),
                          //           },
                          //         ),
                          //   ),
                          // );

                          await editProvider
                              .editPaymentDetailsAdjustedOrdersViewAPIFunction(
                                context,
                                paymentDetails.paymentId,
                                lp,
                              );
                          print("adjusted Order ID: ${adjustList[lp].id}");
                          print(
                            "adjusted selectedPaidOrderId ID: ${editProvider.editselectedPaidOrderId}",
                          );
                          Future.delayed(Duration(milliseconds: 500), () {
                            _showEditAdjustedOrderSheet(
                              context,
                              paymentDetails.paymentId,
                              widget.mode,
                            );
                          });
                        },
                        child: Container(
                          width: MediaQuery.of(context).size.width * 0.9,
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 12,
                          ),

                          margin: EdgeInsets.symmetric(
                            horizontal: 5,
                            // vertical: 10,
                          ),

                          child: Column(
                            children: [
                              Row(
                                children: [
                                  Expanded(
                                    flex: 1,
                                    child: SvgPicture.asset(
                                      "assets/svg/crm/product_details_ic.svg",
                                    ),
                                  ),
                                  SizedBox(width: 10),
                                  Expanded(
                                    flex: 6,
                                    child: InkResponse(
                                      onTap: () {
                                        Navigator.push(
                                          context,
                                          MaterialPageRoute(
                                            builder:
                                                (context) =>
                                                    Ordersdetailsbymodes(
                                                      pageTitleName:
                                                          "CRM Order Details",
                                                      mode: widget.mode,
                                                      orderId:
                                                          adjustList[lp].id,
                                                    ),
                                          ),
                                        );
                                      },
                                      child: Padding(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3.0,
                                        ),
                                        child: Text(
                                          adjustList[lp].orderNumber ?? "-",
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            decoration:
                                                TextDecoration.underline,
                                            decorationColor:
                                                AppColors.semi_black,
                                            decorationStyle:
                                                TextDecorationStyle.dashed,
                                            height: 1.5,
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                              Container(
                                padding: EdgeInsets.symmetric(vertical: 7.5),
                                child: Row(
                                  children: [
                                    Expanded(
                                      flex: 4,
                                      child: Text(
                                        "Payment Details",
                                        style: TextStyle(
                                          fontSize: 14,
                                          fontFamily: "JakartaSemiBold",
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      flex: 6,
                                      child: DottedLine(
                                        dashGapLength: 4,
                                        dashGapColor: Colors.white,
                                        dashColor: AppColors.grey_semi,
                                        dashLength: 2,
                                        lineThickness: 0.5,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              ...List.generate(4, (j) {
                                final heads = [
                                  "Order Amount",
                                  "Paid Amount",
                                  "Balance Amount",
                                  "Adjusted Amount",
                                ];
                                final subHeads = [
                                  adjustList[lp].totalAmount ?? "-",
                                  adjustList[lp].paidAmount ?? "-",
                                  adjustList[lp].balanceAmount ?? "-",
                                  adjustList[lp].adjustedAmount ?? "-",
                                ];
                                return Container(
                                  padding: EdgeInsets.symmetric(vertical: 3),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: Text(
                                          textAlign: TextAlign.left,
                                          heads[j],
                                          style: TextStyle(
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        child: Text(
                                          textAlign: TextAlign.right,
                                          subHeads[j] == "" ? "-" : subHeads[j],
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(0xFF818181),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              }),
                            ],
                          ),
                        ),
                      );
                    },
                  ),
                ] else ...[
                  InkResponse(
                    onTap: () async {
                      await editProvider
                          .editPaymentDetailsAdjustedOrdersViewAPIFunction(
                            context,
                            paymentDetails.paymentId,
                          );
                      Future.delayed(Duration(milliseconds: 500), () {
                        _showAddAdjustedOrderSheet(
                          context,
                          paymentDetails.paymentId,
                          widget.mode,
                        );
                      });
                    },
                    child: Container(
                      height: 50,
                      margin: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 10,
                      ),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(16),
                      ),
                      child: Center(
                        child: Text(
                          textAlign: TextAlign.right,
                          "+ Add Order",
                          style: TextStyle(
                            fontFamily: "JakartaMedium",
                            fontSize: 14,
                            color: AppColors.app_blue,
                          ),
                        ),
                      ),
                    ),
                  ),
                ],
              ],
            ),
          ),
          bottomNavigationBar:
              widget.mode == "self"
                  ? SizedBox.shrink()
                  : Container(
                    alignment: Alignment.bottomCenter,
                    height: 65,
                    decoration: BoxDecoration(color: Colors.white),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        if (!["self", "admin"].contains(widget.mode)) ...[
                          Expanded(
                            child: InkResponse(
                              onTap: () {
                                _showLevelApprovalRejectionSheet(
                                  context,
                                  "Reject",
                                );
                              },
                              child: Container(
                                // decoration: BoxDecoration(
                                //   borderRadius: BorderRadius.circular(8),
                                //   color: Color(0xFFFFEFEF),
                                //   border: Border.all(
                                //     color: Color(0xFFED3424),
                                //     width: 0.5,
                                //   ),
                                // ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SvgPicture.asset(
                                      "assets/svg/finance/level_reject_ic.svg",
                                    ),
                                    SizedBox(width: 10),
                                    Center(
                                      child: Text(
                                        "Reject",
                                        style: TextStyle(
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          SizedBox(width: 10),
                          SvgPicture.asset(
                            "assets/svg/crm/vertical_line_ic.svg",
                          ),
                          SizedBox(width: 10),

                          Expanded(
                            child: InkResponse(
                              onTap: () {
                                // provider
                                //     .approveRejectPaymentRequestAPIFunction(
                                //   context,
                                //   provider.requestsDetails.id,
                                // );
                                _showLevelApprovalRejectionSheet(
                                  context,
                                  "Approve",
                                );
                              },
                              child: Container(
                                // decoration: BoxDecoration(
                                //   borderRadius: BorderRadius.circular(8),
                                //   color: Color(0xFFE7FFE5),
                                //   border: Border.all(
                                //     color: Color(0xFF0D9C00),
                                //     width: 0.5,
                                //   ),
                                // ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SvgPicture.asset(
                                      "assets/svg/finance/level_approve_ic.svg",
                                    ),
                                    SizedBox(width: 10),
                                    Center(
                                      child: Text(
                                        "Approve",
                                        style: TextStyle(
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                        ] else if (widget.mode == "admin") ...[
                          SvgPicture.asset(
                            "assets/svg/crm/vertical_line_ic.svg",
                          ),
                          SizedBox(width: 10),
                          Expanded(
                            child: InkResponse(
                              onTap: () {
                                _showLevelDeletionSheet(context);
                              },
                              child: Container(
                                // decoration: BoxDecoration(
                                //   borderRadius: BorderRadius.circular(8),
                                //   color: Color(0xFFFFEFEF),
                                //   border: Border.all(
                                //     color: Color(0xFFED3424),
                                //     width: 0.5,
                                //   ),
                                // ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SvgPicture.asset(
                                      "assets/svg/finance/level_delete_ic.svg",
                                    ),
                                    SizedBox(width: 10),
                                    Center(
                                      child: Text(
                                        "Delete",
                                        style: TextStyle(
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                        ],
                      ],
                    ),
                  ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Paymentsprovider>(
      builder: (context, provider, child) {
        var paymentDetails = provider.paymentDetails;
        var adjustList = provider.paidLists;
        return WillPopScope(
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2(
                context,
                widget.pageTitleName,
                provider.resetAll,
                paymentDetails.status == "Registered"
                    ? InkResponse(
                      onTap: () {
                        _showOptionsSheet(context);
                      },
                      child: SvgPicture.asset(
                        "assets/svg/ic_more.svg",
                        height: 30,
                      ),
                    )
                    : SizedBox(width: 0),
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body: SingleChildScrollView(
                child: Column(
                  children: [
                    Container(
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(16),
                      ),
                      margin: EdgeInsets.symmetric(
                        vertical: 10,
                        horizontal: 10,
                      ),
                      padding: EdgeInsets.symmetric(
                        vertical: 10,
                        horizontal: 10,
                      ),
                      child: Column(
                        children: [
                          Row(
                            children: [
                              Expanded(
                                flex: 1,
                                child: Container(
                                  height: 50,
                                  width: 35,
                                  padding: EdgeInsets.all(8.0),
                                  decoration: BoxDecoration(
                                    color: Color(0xFFFFF3CE),
                                    borderRadius: BorderRadius.circular(8),
                                  ),
                                  child: SvgPicture.asset(
                                    "assets/svg/fin_ic.svg",
                                  ),
                                ),
                              ),
                              SizedBox(width: 10),
                              Expanded(
                                flex: 4,
                                child: SizedBox(
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        paymentDetails.accountName ?? "-",
                                        style: TextStyle(
                                          fontFamily: "JakartaMedium",
                                          fontSize: 14,
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                      Text(
                                        "₹${paymentDetails.amount}",
                                        style: TextStyle(
                                          fontFamily: "JakartaMedium",
                                          fontSize: 14,
                                          color: AppColors.app_blue,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                              Expanded(
                                flex: 2,
                                child: Container(
                                  padding: EdgeInsets.symmetric(
                                    horizontal: 5,
                                    vertical: 10,
                                  ),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(8),
                                    color: Color(0xFFE3FFE0),
                                  ),
                                  child: Center(
                                    child: Text(
                                      paymentDetails.status ?? "-",
                                      textAlign: TextAlign.center,
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: Color(0xFF0D9C00),
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                          Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                          ...List.generate(provider.subHeadings.length, (j) {
                            return Container(
                              padding: EdgeInsets.symmetric(vertical: 7),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Expanded(
                                    child: Text(
                                      provider.Headings[j],
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.semi_black,
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    child: InkResponse(
                                      onTap: () {
                                        if (provider.Headings[j] ==
                                            "Attachment") {
                                          Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) => Fileviewer(
                                                    fileName:
                                                        paymentDetails
                                                            .attachmentViewFileName!,
                                                    fileUrl:
                                                        paymentDetails
                                                            .attachmentDirFilePath!,
                                                  ),
                                            ),
                                          );
                                        }
                                      },
                                      child: Text(
                                        provider.Headings[j] == "Attachment"
                                            ? "View"
                                            : provider.subHeadings[j],
                                        style: TextStyle(
                                          fontSize: 14,
                                          color:
                                              provider.Headings[j] ==
                                                      "Attachment"
                                                  ? AppColors.app_blue
                                                  : Color(0xFF818181),
                                          decoration:
                                              provider.Headings[j] ==
                                                      "Attachment"
                                                  ? TextDecoration.underline
                                                  : TextDecoration.none,
                                          decorationColor:
                                              provider.Headings[j] ==
                                                      "Attachment"
                                                  ? AppColors.app_blue
                                                  : AppColors.white,
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          }),
                        ],
                      ),
                    ),

                    Container(
                      alignment: Alignment.topLeft,
                      padding: EdgeInsets.symmetric(
                        vertical: 5,
                        horizontal: 10,
                      ),
                      child: Text(
                        "Adjusted Order List",
                        style: TextStyle(
                          fontSize: 14,
                          color: AppColors.grey_thick,
                        ),
                      ),
                    ),
                    ListView.builder(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: NeverScrollableScrollPhysics(),
                      itemCount: adjustList.length,
                      padding: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 10,
                      ),

                      itemBuilder: (context, index) {
                        return Container(
                          margin: EdgeInsets.symmetric(vertical: 5),
                          padding: EdgeInsets.symmetric(
                            horizontal: 15,
                            vertical: 10,
                          ),
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(20),
                          ),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: List.generate(7, (j) {
                              final textheads = [
                                "Order Number",
                                "Order Amount",
                                "Paid Amount",
                                "Balance Amount",
                                "Adjusted Amount",
                                "DateTime",
                                "Actions",
                              ];
                              final textSubheads = [
                                "${adjustList[index].orderNumber}",
                                "${adjustList[index].totalAmount}",
                                "${adjustList[index].paidAmount}",
                                "${adjustList[index].balanceAmount}",
                                "${adjustList[index].adjustedAmount}",
                                "${adjustList[index].datetime}",
                                "View",
                              ];
                              return Container(
                                padding: EdgeInsets.symmetric(
                                  vertical: 6,
                                  horizontal: 0,
                                ),
                                child: Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: Text(
                                        textheads[j].toString(),
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                    ),
                                    Expanded(
                                      child: InkResponse(
                                        onTap: () {
                                          if (textheads[j] == "Actions") {
                                            Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                builder:
                                                    (
                                                      context,
                                                    ) => Ordersdetailsbymodes(
                                                      pageTitleName:
                                                          "CRM Order Details",
                                                      mode: widget.mode,
                                                      orderId:
                                                          adjustList[index].id,
                                                    ),
                                              ),
                                            );
                                          }
                                        },
                                        child: SizedBox(
                                          // height:45,
                                          width:
                                              MediaQuery.of(
                                                context,
                                              ).size.width *
                                              0.75,
                                          child: Text(
                                            textSubheads[j],
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                            style: TextStyle(
                                              color:
                                                  textheads[j] == "Actions"
                                                      ? AppColors.app_blue
                                                      : Color(0xFF818181),
                                              decoration:
                                                  textheads[j] == "Actions"
                                                      ? TextDecoration.underline
                                                      : TextDecoration.none,
                                              decorationColor:
                                                  textheads[j] == "Actions"
                                                      ? AppColors.app_blue
                                                      : AppColors.white,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                          ),
                        );
                      },
                    ),
                  ],
                ),
              ),
              bottomNavigationBar:
                  widget.mode == "self"
                      ? Container(height: 0)
                      : Container(
                        margin: EdgeInsets.symmetric(horizontal: 10),
                        alignment: Alignment.bottomCenter,
                        height: 60,
                        child: Container(
                          margin: EdgeInsets.only(bottom: 10),
                          alignment: Alignment.center,
                          height: 45,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              if (!["self", "admin"].contains(widget.mode)) ...[
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      _showLevelApprovalRejectionSheet(
                                        context,
                                        "Reject",
                                      );
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFFFEFEF),
                                        border: Border.all(
                                          color: Color(0xFFED3424),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Reject",
                                          style: TextStyle(
                                            color: Color(0xFFED3424),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),

                                SizedBox(width: 10),

                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      // provider
                                      //     .approveRejectPaymentRequestAPIFunction(
                                      //   context,
                                      //   provider.requestsDetails.id,
                                      // );
                                      _showLevelApprovalRejectionSheet(
                                        context,
                                        "Approve",
                                      );
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFE7FFE5),
                                        border: Border.all(
                                          color: Color(0xFF0D9C00),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Approve",
                                          style: TextStyle(
                                            color: Color(0xFF0D9C00),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ] else if (widget.mode == "admin") ...[
                                Expanded(
                                  child: InkResponse(
                                    onTap: () {
                                      _showLevelDeletionSheet(context);
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(8),
                                        color: Color(0xFFFFEFEF),
                                        border: Border.all(
                                          color: Color(0xFFED3424),
                                          width: 0.5,
                                        ),
                                      ),
                                      child: Center(
                                        child: Text(
                                          "Delete",
                                          style: TextStyle(
                                            color: Color(0xFFED3424),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ],
                          ),
                        ),
                      ),
            ),
          ),

          onWillPop: () {
            return onBackPressed(context);
          },
        );
      },
    );
  }

  Future<void> _showOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Paymentsprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(2, (index) {
                            final assetnames = ["ic_edit", "ic_edit"];
                            final Headingnames = [
                              "Edit Payment Details",
                              "Edit Adjusted Order",
                            ];
                            return ListTile(
                              onTap: () async {
                                var res;
                                switch (index) {
                                  case 0:
                                    res = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (
                                              context,
                                            ) => Editpaymentdetailsbymode(
                                              pageTitleName:
                                                  "Edit Payment (${widget.mode})",
                                              mode: widget.mode,
                                              values: {
                                                "payment_id":
                                                    provider
                                                        .paymentDetails
                                                        .paymentId,
                                                "description":
                                                    provider
                                                        .paymentDetails
                                                        .description,
                                                "amount":
                                                    provider
                                                        .paymentDetails
                                                        .amount,
                                                "payment_mode":
                                                    provider
                                                        .paymentDetails
                                                        .paymentType,
                                                "pay_ref":
                                                    provider
                                                        .paymentDetails
                                                        .refNo,
                                                "pay_received_date":
                                                    provider
                                                        .paymentDetails
                                                        .paymentDate,
                                              },
                                            ),
                                      ),
                                    );
                                    break;
                                  case 1:
                                    res = await Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Editadjustedorderlist(
                                              mode: widget.mode,
                                              pageTitleName:
                                                  "Edit Adjusted Order List (${widget.mode})",

                                              values: {
                                                "account_id":
                                                    provider
                                                        .paymentDetails
                                                        .accId,
                                                "payment_id":
                                                    provider
                                                        .paymentDetails
                                                        .paymentId,
                                                "orders":
                                                    provider.paidLists
                                                        .map(
                                                          (order) => {
                                                            "order_number":
                                                                order
                                                                    .orderNumber,
                                                            "amount":
                                                                order
                                                                    .adjustedAmount,
                                                          },
                                                        )
                                                        .toList(),
                                              },
                                            ),
                                      ),
                                    );
                                    break;
                                }
                                if (res == true) {
                                  provider.paymentsDetailsByModeAPIFunction(
                                    context,
                                    widget.paymentId,
                                    widget.mode,
                                  );
                                }
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/${assetnames[index]}.svg",
                              ),
                              title: Text(
                                Headingnames[index],
                                style: TextStyle(fontFamily: "JakartaMedium"),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLevelApprovalRejectionSheet(BuildContext context, type) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Paymentsprovider>(
                builder: (context, provider, child) {
                  final details = provider.paymentDetails;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              type == "Approve"
                                  ? "Payment Approval"
                                  : "Payment Reject",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),
                          Padding(
                            padding: const EdgeInsets.only(
                              bottom: 5.0,
                              top: 8.0,
                            ),
                            child: Text("Remarks"),
                          ),
                          Container(
                            height: 150,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                              color: Color(0xFFE9E9E9),
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.fromLTRB(
                                10.0,
                                0.0,
                                10,
                                0,
                              ),
                              child: TextFormField(
                                controller:
                                    provider.approvalRejectionController,
                                readOnly: true,
                                keyboardType: TextInputType.text,
                                maxLines: 60,
                                onChanged: provider.onChangeApprovalRejection,
                                style: TextStyle(
                                  color: Color(0xFF818181),
                                  fontSize: 14,
                                ),
                                decoration: InputDecoration(
                                  hintText: "Write Remarks",
                                  hintStyle: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: Color(0xFFB4BEC0),
                                    fontSize: 14,
                                  ),

                                  enabledBorder: InputBorder.none,
                                  focusedBorder: InputBorder.none,
                                ),
                              ),
                            ),
                          ),
                          if (provider.approvalRejectionError != null) ...[
                            Container(
                              alignment: Alignment.topLeft,
                              margin: EdgeInsets.only(top: 2.5, left: 25),
                              child: Text(
                                "${provider.approvalRejectionError}",
                                style: TextStyle(
                                  color: Colors.red,
                                  fontSize: 10,
                                ),
                              ),
                            ),
                          ],
                          InkWell(
                            onTap: () {
                              provider.paymentApprovalRejectionAPIFunction(
                                context,
                                provider.paymentDetails.paymentId,
                                type,
                              );
                            },

                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showLevelDeletionSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Paymentsprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Align(
                            alignment: Alignment.topLeft,
                            child: Text(
                              "Delete Payment",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontSize: 16,
                              ),
                            ),
                          ),

                          InkWell(
                            onTap: () {
                              _confirmDeletionSheet(context);
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _confirmDeletionSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,

      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Container(
                margin: EdgeInsets.only(
                  bottom: 15,
                  left: 15,
                  right: 15,
                  top: 30,
                ),
                padding: EdgeInsets.only(
                  bottom: MediaQuery.of(context).viewInsets.bottom,
                ),
                child: Consumer<Paymentsprovider>(
                  builder: (context, provider, child) {
                    return SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(
                                "Are you sure you want \nto Delete the Payment ?",
                                textAlign: TextAlign.center,
                                style: TextStyle(
                                  fontFamily: "JakartaMedium",
                                  color: AppColors.semi_black,
                                  fontSize: 18,
                                ),
                              ),
                            ],
                          ),
                          SizedBox(height: 20),
                          InkWell(
                            onTap: () {
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              provider.paymentDeletionAPIFunction(
                                context,
                                provider.paymentDetails.paymentId,
                              );
                              //  Navigator.push(context,MaterialPageRoute(builder: (context)=>Profile()));
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue, //1487C9
                                borderRadius: BorderRadius.circular(15.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Yes, Logout",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontFamily: "JakartaMedium",
                                  ),
                                ),
                              ),
                            ),
                          ),

                          InkWell(
                            onTap: () {
                              // LoginApiFunction();

                              var f = FocusScope.of(context);

                              if (!f.hasPrimaryFocus) {
                                f.unfocus();
                              }
                              Navigator.pop(context);
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),

                              child: Center(
                                child: Text(
                                  "Cancel",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontFamily: "JakartaMedium",
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            );
          },
        );
      },
    );
  }

  Future<void> _showAddAdjustedOrderSheet(
    BuildContext context,
    paymentId,
    mode,
  ) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Editpaymentprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            "Add Order",
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.app_blue,
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                          SizedBox(height: 10),
                          TextWidget(context, "Order"),
                          Row(
                            children: [
                              Expanded(
                                child: DropdownButtonHideUnderline(
                                  child: DropdownButton2<EditPaidList>(
                                    isExpanded: true,
                                    hint: Text(
                                      'Select Account Type',
                                      style: TextStyle(fontSize: 14),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                    items:
                                        provider.paidList
                                            .map(
                                              (ord) => DropdownMenuItem<
                                                EditPaidList
                                              >(
                                                value: ord,
                                                child: Text(
                                                  "(Order Number: ${ord.orderNumber}) + (Order Amount: ${ord.orderAmount}) + (Balance Amount: ${ord.balanceAmount})" ??
                                                      '',
                                                  style: const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    // value:
                                    //     editProvider
                                    //         .selectedPaidList,
                                    value:
                                        provider.editselectedPaidList != null
                                            ? provider.paidList.firstWhere(
                                              (product) =>
                                                  product.orderId ==
                                                  provider
                                                      .editselectedPaidOrderId,
                                              orElse:
                                                  () => provider.paidList[0],
                                            )
                                            : null,
                                    // value:editProvider.paidList.firstWhere(
                                    //       (
                                    //       ord,
                                    //       ) =>
                                    //   ord.orderId ==
                                    //       editProvider.selectedPaidOrderIDs[index],
                                    //   orElse:
                                    //       () =>
                                    //   editProvider.paidList[0],
                                    // ),
                                    onChanged: (EditPaidList? value) {
                                      if (value != null) {
                                        if (provider.paidList.isNotEmpty) {
                                          provider.editselectedPaidList = value;
                                          provider.editselectedPaidOrderId =
                                              value.orderId;
                                          print(
                                            "Selected Complaint Type: ${provider.editselectedPaidOrderId}, ID: ${value.orderNumber}",
                                          );
                                        }
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ),
                            ],
                          ),

                          if (provider.selectedAccountError != null) ...[
                            errorWidget(context, provider.selectedAccountError),
                          ],
                          SizedBox(width: 10),
                          Row(
                            children: [
                              Expanded(
                                flex: 2,
                                child: textControllerWidget(
                                  context,
                                  provider.adjustedAddAmountController,
                                  "Order Amount",
                                  "Enter Order Amount",
                                  provider.onChnageAmountController,
                                  TextInputType.number,
                                  false,
                                  FilteringTextInputFormatter.digitsOnly,
                                  null,
                                  null,
                                  TextInputAction.next,
                                ),
                              ),
                            ],
                          ),
                          if (provider.adjustedAddAmountError != null) ...[
                            errorWidget(
                              context,
                              provider.adjustedAddAmountError,
                            ),
                          ],
                          SizedBox(height: 10),

                          InkResponse(
                            onTap:
                                provider.submitLoading
                                    ? null
                                    : () {
                                      provider.submitLoading = true;
                                      provider
                                          .paymentsDetailsAddAdjustedOrderModeAPIFunction(
                                            context,
                                            paymentId,
                                            provider.editselectedPaidOrderId,
                                            mode,
                                          );
                                    },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: const EdgeInsets.symmetric(
                                horizontal: 0,
                                vertical: 15,
                              ),
                              padding: const EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child:
                                  provider.submitLoading
                                      ? CircularProgressIndicator.adaptive(
                                        valueColor:
                                            AlwaysStoppedAnimation<Color>(
                                              AppColors.white,
                                            ),
                                      )
                                      : const Text(
                                        "Submit",
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<Paymentsprovider>(context, listen: false);

        provider.paymentsDetailsByModeAPIFunction(
          context,
          widget.paymentId,
          widget.mode,
        );
      });
    });
  }

  Future<void> _showEditAdjustedOrderSheet(
    BuildContext context,
    paymentId,
    mode,
  ) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Editpaymentprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            "Edit Order",
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.app_blue,
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                          SizedBox(height: 10),
                          TextWidget(context, "Order"),

                          Row(
                            children: [
                              Expanded(
                                child: DropdownButtonHideUnderline(
                                  child: DropdownButton2<EditPaidList>(
                                    isExpanded: true,
                                    hint: Text(
                                      'Select Account Type',
                                      style: TextStyle(fontSize: 14),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                    items:
                                        provider.paidList
                                            .map(
                                              (ord) => DropdownMenuItem<
                                                EditPaidList
                                              >(
                                                value: ord,
                                                child: Text(
                                                  "(Order Number: ${ord.orderNumber}) + (Order Amount: ${ord.orderAmount}) + (Balance Amount: ${ord.balanceAmount})" ??
                                                      '',
                                                  style: const TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    // value:
                                    //     editProvider
                                    //         .selectedPaidList,
                                    value:
                                        provider.editselectedPaidList != null
                                            ? provider.paidList.firstWhere(
                                              (product) =>
                                                  product.orderId ==
                                                  provider
                                                      .editselectedPaidOrderId,
                                            )
                                            : null,
                                    // value:editProvider.paidList.firstWhere(
                                    //       (
                                    //       ord,
                                    //       ) =>
                                    //   ord.orderId ==
                                    //       editProvider.selectedPaidOrderIDs[index],
                                    //   orElse:
                                    //       () =>
                                    //   editProvider.paidList[0],
                                    // ),
                                    onChanged: (EditPaidList? value) {
                                      if (value != null) {
                                        if (provider.paidList.isNotEmpty) {
                                          provider.editselectedPaidList = value;
                                          provider.editselectedPaidOrderId =
                                              value.orderId;
                                          print(
                                            "Selected Complaint Type: ${value.orderId}, ID: ${value.orderNumber}",
                                          );
                                        }
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ),
                            ],
                          ),

                          if (provider.selectedAccountError != null) ...[
                            errorWidget(context, provider.selectedAccountError),
                          ],
                          SizedBox(width: 10),
                          Row(
                            children: [
                              Expanded(
                                flex: 2,
                                child: textControllerWidget(
                                  context,
                                  provider.adjustedAddAmountController,
                                  "Order Amount",
                                  "Enter Order Amount",
                                  provider.onChnageAmountController,
                                  TextInputType.number,
                                  false,
                                  FilteringTextInputFormatter.digitsOnly,
                                  null,
                                  null,
                                  TextInputAction.next,
                                ),
                              ),
                            ],
                          ),
                          if (provider.adjustedAddAmountError != null) ...[
                            errorWidget(
                              context,
                              provider.adjustedAddAmountError,
                            ),
                          ],
                          SizedBox(height: 10),

                          InkResponse(
                            onTap:
                                provider.submitLoading
                                    ? null
                                    : () {
                                      provider.submitLoading = true;
                                      provider
                                          .paymentsDetailsEditAdjustedOrderModeAPIFunction(
                                            context,
                                            provider.paidList
                                                .firstWhere(
                                                  (product) =>
                                                      product.orderId ==
                                                      provider
                                                          .editselectedPaidOrderId,
                                                )
                                                .orderPaymentId,
                                            provider.editselectedPaidOrderId,
                                            mode,
                                            paymentId,
                                          );
                                    },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: const EdgeInsets.symmetric(
                                horizontal: 0,
                                vertical: 15,
                              ),
                              padding: const EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child:
                                  provider.submitLoading
                                      ? CircularProgressIndicator.adaptive(
                                        valueColor:
                                            AlwaysStoppedAnimation<Color>(
                                              AppColors.white,
                                            ),
                                      )
                                      : const Text(
                                        "Submit",
                                        style: TextStyle(
                                          fontSize: 15,
                                          fontFamily: "JakartaMedium",
                                          color: Colors.white,
                                        ),
                                      ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        final provider = Provider.of<Paymentsprovider>(context, listen: false);

        provider.paymentsDetailsByModeAPIFunction(
          context,
          widget.paymentId,
          widget.mode,
        );
      });
    });
  }
}
