import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:generp/Notifiers/crmProvider/crmDashboardProvider.dart';
import 'package:generp/Utils/GlobalConstants.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/crm/pendingTasksDetails.dart';
import 'package:provider/provider.dart';

import 'followUpUpdateScreen.dart';

class Followuplistontype extends StatefulWidget {
  final type;
  const Followuplistontype({super.key, required this.type});

  @override
  State<Followuplistontype> createState() => _FollowuplistontypeState();
}

class _FollowuplistontypeState extends State<Followuplistontype> {
  FocusNode focusNode = FocusNode();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((event) {
      setState(() => _source = event);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Crmdashboardprovider>(context, listen: false);
      prov.crmDashboardFollowUpAPIFunction(context, widget.type);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Crmdashboardprovider>(
      builder: (context, provider, child) {
        var followUps = provider.dashboardFollowUps;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: AppBar(
            automaticallyImplyLeading: false,
            // elevation: 2.0,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () => Navigator.pop(context, true),
                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  InkResponse(
                    onTap: () => Navigator.pop(context, true),
                    child: Text(
                      "Follow Up (${widget.type})",
                      style: TextStyle(
                        fontSize: 16,
                        height: 1.1,
                        fontFamily: "JakartaSemiBold",
                        color: AppColors.semi_black,
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
          body:
              (followUps.isNotEmpty)
                  ? SingleChildScrollView(
                    physics: AlwaysScrollableScrollPhysics(),
                    child: Column(
                      children: [
                        SizedBox(
                          width: double.infinity,
                          child: ListView.builder(
                            physics: NeverScrollableScrollPhysics(),
                            shrinkWrap: true,
                            padding: EdgeInsets.symmetric(
                              vertical: 5,
                              horizontal: 10,
                            ),
                            itemCount: followUps.length,
                            itemBuilder: (context, index) {
                              final subHeadings = [
                                followUps[index].aname ?? "-",
                                followUps[index].appdate ?? "-",
                                followUps[index].anote ?? "-",
                              ];
                              return InkResponse(
                                onTap: () async {
                                  var res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => Followupupdatescreen(
                                            leadID: followUps[index].leadid,
                                            mode: "",
                                          ),
                                      settings: RouteSettings(
                                        name: 'Followupupdatescreen',
                                      ),
                                    ),
                                  );
                                  if (routeSettingName ==
                                      "Followupupdatescreen") {
                                    provider.crmDashboardFollowUpAPIFunction(
                                      context,
                                      widget.type,
                                    );
                                  }
                                },
                                child: Container(
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(15),
                                  ),
                                  margin: EdgeInsets.symmetric(vertical: 3),
                                  padding: EdgeInsets.symmetric(
                                    horizontal: 10,
                                    vertical: 5,
                                  ),
                                  child: Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3,
                                          horizontal: 0,
                                        ),

                                        child: Column(
                                          children: [
                                            Row(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Expanded(
                                                  child: Text(
                                                    "${followUps[index].aname}",
                                                    maxLines: 1,
                                                    overflow:
                                                        TextOverflow.visible,
                                                    style: TextStyle(
                                                      decoration:
                                                          TextDecoration
                                                              .underline,
                                                      height: 1,
                                                      decorationStyle:
                                                          TextDecorationStyle
                                                              .dotted,
                                                      decorationColor: Color(
                                                        0xFF676767,
                                                      ),
                                                      color:
                                                          AppColors.semi_black,
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  child: Text(
                                                    "${followUps[index].appdate}",
                                                    textAlign: TextAlign.right,
                                                    maxLines: 1,
                                                    style: TextStyle(
                                                      color:
                                                          AppColors.grey_semi,
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ),
                                            SizedBox(height: 10),
                                            Container(
                                              padding: EdgeInsets.symmetric(
                                                vertical: 10,
                                                horizontal: 10,
                                              ),
                                              decoration: BoxDecoration(
                                                borderRadius:
                                                    BorderRadius.circular(16),
                                                gradient: LinearGradient(
                                                  colors: [
                                                    Color(0xFFFFFFFF),
                                                    Color(0xFFE8F7FF),
                                                  ],
                                                ),
                                              ),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  Expanded(
                                                    child: Text(
                                                      "Remarks",
                                                      maxLines: 1,
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                      style: TextStyle(
                                                        color:
                                                            AppColors.app_blue,
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                                  Expanded(
                                                    child: Text(
                                                      "${followUps[index].anote}",
                                                      textAlign:
                                                          TextAlign.right,
                                                      maxLines: 1,
                                                      style: TextStyle(
                                                        color:
                                                            AppColors
                                                                .semi_black,
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              );
                            },
                          ),
                        ),

                        SizedBox(height: 150),
                      ],
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }
}
