import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:http/http.dart';
import 'GlobalConstants.dart';
import 'app_colors.dart';
import 'package:app_settings/app_settings.dart';

PreferredSizeWidget appbar(BuildContext context, title) {
  return AppBar(
    automaticallyImplyLeading: false,
    elevation: 2.0,
    title: SizedBox(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          InkResponse(
            onTap: () => Navigator.pop(context, true),
            child: SvgPicture.asset("assets/svg/app_bar_back.svg", height: 25),
          ),
          InkResponse(
            onTap: () => Navigator.pop(context, true),
            child: Text(
              title,
              style: TextStyle(
                fontSize: 16,
                height: 1.1,
                fontFamily: "JakartaSemiBold",
                color: AppColors.semi_black,
              ),
            ),
          ),
        ],
      ),
    ),
    shape: RoundedRectangleBorder(
      borderRadius: BorderRadius.vertical(
        bottom: Radius.circular(30), // Adjust the radius as needed
      ),
    ),
  );
}

PreferredSizeWidget appbarNew(BuildContext context, title, int color) {
  return AppBar(
    backgroundColor: Color(color),
    automaticallyImplyLeading: false,
    title: SizedBox(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          InkResponse(
            onTap: () => Navigator.pop(context, true),
            child: SvgPicture.asset(
              "assets/svg/appbar_back_button.svg",
              height: 25,
            ),
          ),
          SizedBox(width: 10),
          InkResponse(
            onTap: () => Navigator.pop(context, true),
            child: Text(
              title,
              style: TextStyle(
                fontSize: 16,
                height: 1.1,
                fontFamily: "JakartaSemiBold",
                color: AppColors.semi_black,
              ),
            ),
          ),
        ],
      ),
    ),
    // shape: RoundedRectangleBorder(
    //   borderRadius: BorderRadius.vertical(
    //     bottom: Radius.circular(30), // Adjust the radius as needed
    //   ),
    // ),
  );
}

PreferredSizeWidget appbar2(BuildContext context, title, reset, widget) {
  return AppBar(
    automaticallyImplyLeading: false,
    elevation: 2.0,
    title: SizedBox(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          InkResponse(
            onTap: () {
              reset();
              Navigator.pop(context, true);
            },
            child: SvgPicture.asset("assets/svg/app_bar_back.svg", height: 25),
          ),
          Expanded(
            flex: 4,
            child: InkResponse(
              onTap: () {
                reset();
                Navigator.pop(context, true);
              },
              child: Text(
                title,
                overflow: TextOverflow.ellipsis,
                maxLines: 1,
                style: TextStyle(
                  fontSize: 16,
                  height: 1.1,
                  fontFamily: "JakartaSemiBold",
                  color: AppColors.semi_black,
                ),
              ),
            ),
          ),
          Spacer(),
          widget,
        ],
      ),
    ),
    shape: RoundedRectangleBorder(
      borderRadius: BorderRadius.vertical(
        bottom: Radius.circular(30), // Adjust the radius as needed
      ),
    ),
  );
}

PreferredSizeWidget appbar2New(
  BuildContext context,
  title,
  reset,
  widget,
  int color,
) {
  return AppBar(
    backgroundColor: Color(color),
    automaticallyImplyLeading: false,
    // elevation: 2.0,
    title: SizedBox(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          InkResponse(
            onTap: () {
              HapticFeedback.selectionClick();
              if (reset != null) {
                reset();
              }
              Navigator.pop(context, true);
            },
            child: SvgPicture.asset(
              "assets/svg/appbar_back_button.svg",
              height: 25,
            ),
          ),
          SizedBox(width: 10),
          Expanded(
            flex: 4,
            child: InkResponse(
              onTap: () {
                HapticFeedback.selectionClick();
                if (reset != null) {
                  reset();
                }
                Navigator.pop(context, true);
              },
              child: Text(
                title,
                overflow: TextOverflow.ellipsis,
                maxLines: 1,
                style: TextStyle(
                  fontSize: 16,
                  height: 1.1,
                  fontFamily: "JakartaSemiBold",
                  color: AppColors.semi_black,
                ),
              ),
            ),
          ),
          Spacer(),
          widget,
        ],
      ),
    ),
    // shape: RoundedRectangleBorder(
    //   borderRadius: BorderRadius.vertical(
    //     bottom: Radius.circular(30), // Adjust the radius as needed
    //   ),
    // ),
  );
}

Future<bool> onBackPressed(BuildContext context) async {
  Navigator.pop(context, true);
  return true;
}

Widget Emptywidget(BuildContext context) {
  return SizedBox(
    height: MediaQuery.of(context).size.height * 0.8,
    child: Center(child: Text("No Data Available")),
  );
}

Widget TextWidget(context, text) {
  return Padding(
    padding: const EdgeInsets.only(bottom: 5.0, top: 8.0),
    child: Text(text),
  );
}

Widget errorWidget(context, text) {
  if (text != null) {
    return Text(text!, style: TextStyle(color: Colors.red, fontSize: 12));
  } else {
    return SizedBox(height: 10);
  }
}

Widget textControllerWidget(
  context,
  controller,
  textHead,
  hintText,
  Function(String)? onChanged,
  inputtype,
  readonly,
  inputFormatters, [
  focusNode,
  focusNode2,
  textInputAction,
  maxLength,
]) {
  return Column(
    crossAxisAlignment: CrossAxisAlignment.start,
    children: [
      if (textHead != "") ...[
        Padding(
          padding: const EdgeInsets.only(bottom: 5.0, top: 8.0),
          child: Text(textHead),
        ),
      ],
      Container(
        height:
            hintText == "Enter Description" || hintText == "Write Feedback"
                ? 150
                : 50,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: readonly ? Color(0xFFD7D7D7) : AppColors.text_field_color,
          borderRadius: BorderRadius.circular(14),
        ),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(10.0, 0.0, 10, 0),
          child: TextFormField(
            maxLength: maxLength,
            controller: controller,
            readOnly: readonly,
            keyboardType: inputtype,
            maxLines:
                hintText == "Enter Description" || hintText == "Write Feedback"
                    ? 60
                    : 1,
            onChanged: onChanged,
            focusNode: focusNode,
            onTapUpOutside: (event) {
              if (focusNode != null) {
                if (focusNode.hasFocus) {
                  focusNode.unfocus();
                }
              }
            },
            textInputAction: textInputAction,
            onEditingComplete: () {
              if (focusNode != null) {
                focusNode.unfocus();
              }
              if (focusNode2 != null) {
                focusNode2.requestFocus();
              }
            },
            inputFormatters:
                inputFormatters != null
                    ? [FilteringTextInputFormatter.digitsOnly]
                    : [],
            style: TextStyle(
              color: readonly ? Color(0xFF9e9e9e) : AppColors.semi_black,
            ),
            decoration: InputDecoration(
              counterText: "",
              hintText: hintText,
              hintStyle: TextStyle(
                fontWeight: FontWeight.w400,
                color: Color(0xFFB4BEC0),
                fontSize: 14,
              ),

              enabledBorder: InputBorder.none,
              focusedBorder: InputBorder.none,
            ),
          ),
        ),
      ),
    ],
  );
}

NoNetwork(context) {
  return Container(
    decoration: BoxDecoration(color: AppColors.scaffold_bg_color),
    height: MediaQuery.of(context).size.height,
    child: Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        // Image.asset('assets/images/no_wifi.png', width: 100, height: 100),
        SizedBox(height: 10),
        Center(
          child: Text(
            "You are Offline",
            style: TextStyle(fontSize: 16, color: AppColors.semi_black),
          ),
        ),
        SizedBox(height: 10),
        Text(
          "No connection was found.",
          textAlign: TextAlign.center,
          style: TextStyle(fontSize: 12, color: AppColors.grey_semi),
          overflow: TextOverflow.ellipsis,
        ),
        Text(
          "Make you sure you’ve\n turn on your internet connection",
          textAlign: TextAlign.center,
          style: TextStyle(fontSize: 12, color: AppColors.grey_semi),
          overflow: TextOverflow.ellipsis,
        ),
        SizedBox(height: 40),
        TextButton(
          onPressed: () async {
            await AppSettings.openAppSettings(type: AppSettingsType.wifi);
          },
          style: TextButton.styleFrom(foregroundColor: Colors.white),
          child: Container(
            height: 45,
            width: 150,
            decoration: BoxDecoration(
              color: AppColors.app_blue,
              borderRadius: BorderRadius.all(Radius.circular(10)),
            ),
            child: Center(
              child: Text(
                "Try Again",
                style: TextStyle(color: Colors.white, fontSize: 12),
              ),
            ),
          ),
        ),
      ],
    ),
  );
}

Widget textControllerReadonlyWidget(
  context,
  controller,
  hintText,
  Function(String)? onChanged,
) {
  return Column(
    crossAxisAlignment: CrossAxisAlignment.start,
    children: [
      Padding(
        padding: const EdgeInsets.only(bottom: 5.0, top: 8.0),
        child: Text(hintText),
      ),
      Container(
        height: hintText == "Enter Description" ? 150 : 50,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: Color(0xFFD7D7D7),
          borderRadius: BorderRadius.circular(14),
        ),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(10.0, 0.0, 10, 0),
          child: TextFormField(
            controller: controller,
            readOnly: true,
            keyboardType: TextInputType.text,
            maxLines: hintText == "Enter Description" ? 60 : 1,
            onChanged: onChanged,
            style: TextStyle(color: Color(0xFF9E9E9E), fontSize: 14),
            decoration: InputDecoration(
              hintText: hintText,
              hintStyle: TextStyle(
                fontWeight: FontWeight.w400,
                color: Color(0xFFB4BEC0),
                fontSize: 14,
              ),

              enabledBorder: InputBorder.none,
              focusedBorder: InputBorder.none,
            ),
          ),
        ),
      ),
    ],
  );
}

class MyNavigatorObserver extends NavigatorObserver {
  @override
  void didPush(Route route, Route? previousRoute) {
    super.didPush(route, previousRoute);
    // Called when a route has been pushed onto the navigator.
    didPushed = "true";
    routeSettingName = route.settings.name.toString();
    print('Route pushed: ${route.settings.name}');
    print('didPushed: $didPushed');
  }

  @override
  void didPop(Route route, Route? previousRoute) {
    super.didPop(route, previousRoute);
    didPopped = "true";
    routeSettingName = route.settings.name.toString();
    // Called when a route has been popped off the navigator.
    print('Route popped: ${route.settings.name}');
    print('didPopped: $didPopped');
  }
}
