class crmProspectDetailsResponse {
  List<Leads>? leads;
  List<Contacts>? contacts;
  List<Orders>? orders;
  List<Payments>? payments;
  String? error;
  AccountDetails? accountDetails;
  String? message;
  String? showTransfeLeadButton;

  crmProspectDetailsResponse({
    this.leads,
    this.contacts,
    this.orders,
    this.payments,
    this.error,
    this.accountDetails,
    this.message,
    this.showTransfeLeadButton,
  });

  crmProspectDetailsResponse.fromJson(Map<String, dynamic> json) {
    if (json['leads'] != null) {
      leads = <Leads>[];
      json['leads'].forEach((v) {
        leads!.add(Leads.fromJson(v));
      });
    }
    if (json['contacts'] != null) {
      contacts = <Contacts>[];
      json['contacts'].forEach((v) {
        contacts!.add(Contacts.fromJson(v));
      });
    }
    if (json['orders'] != null) {
      orders = <Orders>[];
      json['orders'].forEach((v) {
        orders!.add(Orders.fromJson(v));
      });
    }
    if (json['payments'] != null) {
      payments = <Payments>[];
      json['payments'].forEach((v) {
        payments!.add(Payments.fromJson(v));
      });
    }
    error = json['error'];
    showTransfeLeadButton = json['show_transfer_lead_button'];
    accountDetails =
        json['account_details'] != null
            ? AccountDetails.fromJson(json['account_details'])
            : null;
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (leads != null) {
      data['leads'] = leads!.map((v) => v.toJson()).toList();
    }
    if (contacts != null) {
      data['contacts'] = contacts!.map((v) => v.toJson()).toList();
    }
    if (orders != null) {
      data['orders'] = orders!.map((v) => v.toJson()).toList();
    }
    if (payments != null) {
      data['payments'] = payments!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    if (accountDetails != null) {
      data['account_details'] = accountDetails!.toJson();
    }
    data['message'] = message;
    data['show_transfer_lead_button'] = showTransfeLeadButton;
    return data;
  }
}

class Leads {
  String? id;
  String? ownerId;
  String? accId;
  String? accManagerId;
  String? status;
  String? openStatus;
  String? date;
  String? closeDate;
  String? closereason;
  String? competitor;
  String? orderGainId;
  String? loc;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Leads({
    this.id,
    this.ownerId,
    this.accId,
    this.accManagerId,
    this.status,
    this.openStatus,
    this.date,
    this.closeDate,
    this.closereason,
    this.competitor,
    this.orderGainId,
    this.loc,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Leads.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    ownerId = json['owner_id'];
    accId = json['acc_id'];
    accManagerId = json['acc_manager_id'];
    status = json['status'];
    openStatus = json['open_status'];
    date = json['date'];
    closeDate = json['close_date'];
    closereason = json['closereason'];
    competitor = json['competitor'];
    orderGainId = json['order_gain_id'];
    loc = json['loc'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['owner_id'] = ownerId;
    data['acc_id'] = accId;
    data['acc_manager_id'] = accManagerId;
    data['status'] = status;
    data['open_status'] = openStatus;
    data['date'] = date;
    data['close_date'] = closeDate;
    data['closereason'] = closereason;
    data['competitor'] = competitor;
    data['order_gain_id'] = orderGainId;
    data['loc'] = loc;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}

class Contacts {
  String? id;
  String? accId;
  String? name;
  String? salutationName;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? type;
  String? designation;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Contacts({
    this.id,
    this.accId,
    this.name,
    this.salutationName,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.type,
    this.designation,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Contacts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accId = json['acc_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    type = json['type'];
    designation = json['designation'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['acc_id'] = accId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['type'] = type;
    data['designation'] = designation;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}

class Orders {
  String? id;
  String? orderNumber;
  String? orderNumberHash;
  String? accId;
  String? refType;
  String? refId;
  String? salesPersonEmpId;
  String? enteredEmpId;
  String? dispatchStateId;
  String? dispatchDistrictId;
  String? dispatchSubLocationId;
  String? dispatchPincode;
  String? dispatchAddress;
  String? basicAmount;
  String? cgstAmount;
  String? sgstAmount;
  String? igstAmount;
  String? paidAmount;
  String? totalAmount;
  String? status;
  String? orderReceivedDate;
  String? scheduledDispatchDate;
  String? otp;
  String? note;
  String? poViewFileName;
  String? poDirFilePath;
  String? unloadingScope;
  String? freightScope;
  String? erectionScope;
  String? saleOrderNumber;
  String? invoiceNumber;
  String? vehicleNumber;
  String? driverName;
  String? driverMobileNumber;
  String? tpcApplicable;
  String? requestedTpcAmount;
  String? level1TpcApprovedAmount;
  String? level2TpcApprovedAmount;
  String? tpcPaymentMode;
  String? tpcPaymentReferenceNo;
  String? tpcPaymentAttachmentDirFilePath;
  String? tpcPaymentAttachementViewFileName;
  String? tpcStatus;
  String? tpcAgentId;
  String? isExist;
  String? createdDatetime;
  String? updatedDatetime;

  Orders({
    this.id,
    this.orderNumber,
    this.orderNumberHash,
    this.accId,
    this.refType,
    this.refId,
    this.salesPersonEmpId,
    this.enteredEmpId,
    this.dispatchStateId,
    this.dispatchDistrictId,
    this.dispatchSubLocationId,
    this.dispatchPincode,
    this.dispatchAddress,
    this.basicAmount,
    this.cgstAmount,
    this.sgstAmount,
    this.igstAmount,
    this.paidAmount,
    this.totalAmount,
    this.status,
    this.orderReceivedDate,
    this.scheduledDispatchDate,
    this.otp,
    this.note,
    this.poViewFileName,
    this.poDirFilePath,
    this.unloadingScope,
    this.freightScope,
    this.erectionScope,
    this.saleOrderNumber,
    this.invoiceNumber,
    this.vehicleNumber,
    this.driverName,
    this.driverMobileNumber,
    this.tpcApplicable,
    this.requestedTpcAmount,
    this.level1TpcApprovedAmount,
    this.level2TpcApprovedAmount,
    this.tpcPaymentMode,
    this.tpcPaymentReferenceNo,
    this.tpcPaymentAttachmentDirFilePath,
    this.tpcPaymentAttachementViewFileName,
    this.tpcStatus,
    this.tpcAgentId,
    this.isExist,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Orders.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    orderNumber = json['order_number'];
    orderNumberHash = json['order_number_hash'];
    accId = json['acc_id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    salesPersonEmpId = json['sales_person_emp_id'];
    enteredEmpId = json['entered_emp_id'];
    dispatchStateId = json['dispatch_state_id'];
    dispatchDistrictId = json['dispatch_district_id'];
    dispatchSubLocationId = json['dispatch_sub_location_id'];
    dispatchPincode = json['dispatch_pincode'];
    dispatchAddress = json['dispatch_address'];
    basicAmount = json['basic_amount'];
    cgstAmount = json['cgst_amount'];
    sgstAmount = json['sgst_amount'];
    igstAmount = json['igst_amount'];
    paidAmount = json['paid_amount'];
    totalAmount = json['total_amount'];
    status = json['status'];
    orderReceivedDate = json['order_received_date'];
    scheduledDispatchDate = json['scheduled_dispatch_date'];
    otp = json['otp'];
    note = json['note'];
    poViewFileName = json['po_view_file_name'];
    poDirFilePath = json['po_dir_file_path'];
    unloadingScope = json['unloading_scope'];
    freightScope = json['freight_scope'];
    erectionScope = json['erection_scope'];
    saleOrderNumber = json['sale_order_number'];
    invoiceNumber = json['invoice_number'];
    vehicleNumber = json['vehicle_number'];
    driverName = json['driver_name'];
    driverMobileNumber = json['driver_mobile_number'];
    tpcApplicable = json['tpc_applicable'];
    requestedTpcAmount = json['requested_tpc_amount'];
    level1TpcApprovedAmount = json['level1_tpc_approved_amount'];
    level2TpcApprovedAmount = json['level2_tpc_approved_amount'];
    tpcPaymentMode = json['tpc_payment_mode'];
    tpcPaymentReferenceNo = json['tpc_payment_reference_no'];
    tpcPaymentAttachmentDirFilePath =
        json['tpc_payment_attachment_dir_file_path'];
    tpcPaymentAttachementViewFileName =
        json['tpc_payment_attachement_view_file_name'];
    tpcStatus = json['tpc_status'];
    tpcAgentId = json['tpc_agent_id'];
    isExist = json['is_exist'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['order_number'] = orderNumber;
    data['order_number_hash'] = orderNumberHash;
    data['acc_id'] = accId;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['sales_person_emp_id'] = salesPersonEmpId;
    data['entered_emp_id'] = enteredEmpId;
    data['dispatch_state_id'] = dispatchStateId;
    data['dispatch_district_id'] = dispatchDistrictId;
    data['dispatch_sub_location_id'] = dispatchSubLocationId;
    data['dispatch_pincode'] = dispatchPincode;
    data['dispatch_address'] = dispatchAddress;
    data['basic_amount'] = basicAmount;
    data['cgst_amount'] = cgstAmount;
    data['sgst_amount'] = sgstAmount;
    data['igst_amount'] = igstAmount;
    data['paid_amount'] = paidAmount;
    data['total_amount'] = totalAmount;
    data['status'] = status;
    data['order_received_date'] = orderReceivedDate;
    data['scheduled_dispatch_date'] = scheduledDispatchDate;
    data['otp'] = otp;
    data['note'] = note;
    data['po_view_file_name'] = poViewFileName;
    data['po_dir_file_path'] = poDirFilePath;
    data['unloading_scope'] = unloadingScope;
    data['freight_scope'] = freightScope;
    data['erection_scope'] = erectionScope;
    data['sale_order_number'] = saleOrderNumber;
    data['invoice_number'] = invoiceNumber;
    data['vehicle_number'] = vehicleNumber;
    data['driver_name'] = driverName;
    data['driver_mobile_number'] = driverMobileNumber;
    data['tpc_applicable'] = tpcApplicable;
    data['requested_tpc_amount'] = requestedTpcAmount;
    data['level1_tpc_approved_amount'] = level1TpcApprovedAmount;
    data['level2_tpc_approved_amount'] = level2TpcApprovedAmount;
    data['tpc_payment_mode'] = tpcPaymentMode;
    data['tpc_payment_reference_no'] = tpcPaymentReferenceNo;
    data['tpc_payment_attachment_dir_file_path'] =
        tpcPaymentAttachmentDirFilePath;
    data['tpc_payment_attachement_view_file_name'] =
        tpcPaymentAttachementViewFileName;
    data['tpc_status'] = tpcStatus;
    data['tpc_agent_id'] = tpcAgentId;
    data['is_exist'] = isExist;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}

class Payments {
  String? id;
  String? accId;
  String? refType;
  String? refId;
  String? description;
  String? amount;
  String? paymentDate;
  String? paymentType;
  String? refNo;
  String? empId;
  String? otp;
  String? attachment;
  String? attachmentDirFilePath;
  String? attachmentViewFileName;
  String? approvalRemarks;
  String? approvalStatus;
  String? approvalEmpId;
  String? approvalDatetime;
  String? status;
  String? isExist;
  String? delEmpId;
  String? delDatetime;
  String? datetime;
  String? employeeName;

  Payments({
    this.id,
    this.accId,
    this.refType,
    this.refId,
    this.description,
    this.amount,
    this.paymentDate,
    this.paymentType,
    this.refNo,
    this.empId,
    this.otp,
    this.attachment,
    this.attachmentDirFilePath,
    this.attachmentViewFileName,
    this.approvalRemarks,
    this.approvalStatus,
    this.approvalEmpId,
    this.approvalDatetime,
    this.status,
    this.isExist,
    this.delEmpId,
    this.delDatetime,
    this.datetime,
    this.employeeName,
  });

  Payments.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accId = json['acc_id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    description = json['description'];
    amount = json['amount'];
    paymentDate = json['payment_date'];
    paymentType = json['payment_type'];
    refNo = json['ref_no'];
    empId = json['emp_id'];
    otp = json['otp'];
    attachment = json['attachment'];
    attachmentDirFilePath = json['attachment_dir_file_path'];
    attachmentViewFileName = json['attachment_view_file_name'];
    approvalRemarks = json['approval_remarks'];
    approvalStatus = json['approval_status'];
    approvalEmpId = json['approval_emp_id'];
    approvalDatetime = json['approval_datetime'];
    status = json['status'];
    isExist = json['is_exist'];
    delEmpId = json['del_emp_id'];
    delDatetime = json['del_datetime'];
    datetime = json['datetime'];
    employeeName = json['employee_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['acc_id'] = accId;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['description'] = description;
    data['amount'] = amount;
    data['payment_date'] = paymentDate;
    data['payment_type'] = paymentType;
    data['ref_no'] = refNo;
    data['emp_id'] = empId;
    data['otp'] = otp;
    data['attachment'] = attachment;
    data['attachment_dir_file_path'] = attachmentDirFilePath;
    data['attachment_view_file_name'] = attachmentViewFileName;
    data['approval_remarks'] = approvalRemarks;
    data['approval_status'] = approvalStatus;
    data['approval_emp_id'] = approvalEmpId;
    data['approval_datetime'] = approvalDatetime;
    data['status'] = status;
    data['is_exist'] = isExist;
    data['del_emp_id'] = delEmpId;
    data['del_datetime'] = delDatetime;
    data['datetime'] = datetime;
    data['employee_name'] = employeeName;
    return data;
  }
}

class AccountDetails {
  String? id;
  String? tempId;
  String? ownerId;
  String? accManagerId;
  String? name;
  String? salutationName;
  String? subLocality;
  String? district;
  String? state;
  String? pincode;
  String? address;
  String? date;
  String? source;
  String? reference;
  String? segment;
  String? team;
  String? gstNumber;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? aage;
  String? accManager;
  String? owner;

  AccountDetails({
    this.id,
    this.tempId,
    this.ownerId,
    this.accManagerId,
    this.name,
    this.salutationName,
    this.subLocality,
    this.district,
    this.state,
    this.pincode,
    this.address,
    this.date,
    this.source,
    this.reference,
    this.segment,
    this.team,
    this.gstNumber,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.aage,
    this.accManager,
    this.owner,
  });

  AccountDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    tempId = json['temp_id'];
    ownerId = json['owner_id'];
    accManagerId = json['acc_manager_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    subLocality = json['sub_locality'];
    district = json['district'];
    state = json['state'];
    pincode = json['pincode'];
    address = json['address'];
    date = json['date'];
    source = json['source'];
    reference = json['reference'];
    segment = json['segment'];
    team = json['team'];
    gstNumber = json['gst_number'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    aage = json['aage'];
    accManager = json['acc_manager'];
    owner = json['owner'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['temp_id'] = tempId;
    data['owner_id'] = ownerId;
    data['acc_manager_id'] = accManagerId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['sub_locality'] = subLocality;
    data['district'] = district;
    data['state'] = state;
    data['pincode'] = pincode;
    data['address'] = address;
    data['date'] = date;
    data['source'] = source;
    data['reference'] = reference;
    data['segment'] = segment;
    data['team'] = team;
    data['gst_number'] = gstNumber;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['aage'] = aage;
    data['acc_manager'] = accManager;
    data['owner'] = owner;
    return data;
  }
}
