import 'dart:io';

import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/crmProvider/crmLeadDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class FollowUpDetails extends StatefulWidget {
  const FollowUpDetails({super.key});

  @override
  State<FollowUpDetails> createState() => _FollowUpDetailsState();
}

class _FollowUpDetailsState extends State<FollowUpDetails> {
  @override
  Widget build(BuildContext context) {
    return Consumer<crmLeadDetailsProvider>(
      builder: (context, provider, child) {
        var followupDetails = provider.followupDetails;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Followup Details"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: SizedBox(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      // TextWidget(context, "Followup Details"),
                      ListView.builder(
                        itemCount: followupDetails.length,
                        shrinkWrap: true,
                        itemBuilder: (context, index) {
                          return Container(
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            padding: EdgeInsets.symmetric(
                              horizontal: 15,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                ...List.generate(4, (j) {
                                  final textheads = [
                                    "Employee Name",
                                    "Date and Time",
                                    "Type",
                                    "Feedback",
                                  ];
                                  final textSubheads = [
                                    followupDetails[index].ename ?? "-",
                                    "${followupDetails[index].fdate ?? "-"}, ${followupDetails[index].finTime ?? "-"}",
                                    followupDetails[index].ftype ?? "-",
                                    followupDetails[index].ffeedback ?? "-",
                                  ];
                                  return Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 6,
                                      horizontal: 0,
                                    ),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Text(
                                            textheads[j].toString(),
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                          ),
                                        ),
                                        Expanded(
                                          child: Text(
                                            textSubheads[j],
                                            maxLines: 2,
                                            overflow: TextOverflow.ellipsis,
                                            style: TextStyle(
                                              color: Color(0xFF818181),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                              ],
                            ),
                          );
                        },
                      ),

                      SizedBox(height: 75),
                    ],
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
