import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:generp/Models/ordersModels/ordersDetailsEditOrderViewResponse.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:image_picker/image_picker.dart';
import 'package:provider/provider.dart';

import '../../Models/commonModels/DistrictsResponse.dart';
import '../../Models/commonModels/SubLocationsResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Editorderprovider extends ChangeNotifier {
  TextEditingController dispatchPincodeController = TextEditingController();
  TextEditingController dispatchAddressController = TextEditingController();
  TextEditingController noteController = TextEditingController();

  String? dispatchAddressError;
  String? dispatchPincodeError;
  String? noteError;
  List<States> _dispatchStates = [];
  List<Districts> _dispatchDistricts = [];
  List<SubLocations> _dispatchSubLocations = [];
  List<String> _unloadingScope = [];
  List<String> _freightScope = [];
  List<String> _erectionScope = [];
  OrderDetails _orderDetails = OrderDetails();

  States? _selectedDispatchStates;
  String? _selectedDispatchStateID;
  String? _selectedDispatchStateName;

  Districts? _selectedDispatchDistricts;
  String? _selectedDispatchDistrictID;
  String? _selectedDispatchDistrictValue;

  SubLocations? _selectedDispatchSubLocations;
  String? _selectedDispatchSubLocID;
  String? _selectedDispatchSubLocValue;

  String? _selectedUnloadingScope;
  String? _selectedFreightScope;
  String? _selectedErectionScope;
  int image_picked = 0;
  String? FileError;
  String? dateError;
  final bool _isLoading = false;
  int _imagePicked = 0;
  File? _image;
  File? _imageName;
  final ImagePicker _picker = ImagePicker();
  bool _submitClicked = false;

  File? get imagePath => _imageName;

  File? get imageFilePath => _image;

  int get imagePicked => _imagePicked;

  List<String> get unloadingScope => _unloadingScope;

  List<String> get freightScope => _freightScope;

  List<String> get erectionScope => _erectionScope;

  String? get selectedUnloadingScope => _selectedUnloadingScope;

  String? get selectedFreightScope => _selectedFreightScope;

  String? get selectedErectionScope => _selectedErectionScope;

  bool get submitClicked => _submitClicked;

  List<States> get dispatchStates => _dispatchStates;

  States? get selecetdDispatchStates => _selectedDispatchStates;

  String? get selectedDispatchStateID => _selectedDispatchStateID;

  String? get selectedDispatchStateName => _selectedDispatchStateName;

  List<Districts> get dispatchDistricts => _dispatchDistricts;

  List<SubLocations> get dispatchSubLocations => _dispatchSubLocations;

  Districts? get selectedDispatchDistricts => _selectedDispatchDistricts;

  String? get selectedDispatchDistrictId => _selectedDispatchDistrictID;

  String? get selectedDispatchDistrictValue => _selectedDispatchDistrictValue;

  SubLocations? get selectedDispatchSubLocations =>
      _selectedDispatchSubLocations;

  String? get selectedDispatchSubLocID => _selectedDispatchSubLocID;

  String? get selectedDispatchSubLocValue => _selectedDispatchSubLocValue;

  OrderDetails get orderDetails => _orderDetails;

  set imagePath(File? value) {
    _imageName = value;
    notifyListeners();
  }

  set imageFilePath(File? value) {
    _image = value;
    notifyListeners();
  }

  set imagePicked(value) {
    _imagePicked = value;
    notifyListeners();
  }

  set selecetdDispatchStates(States? value) {
    _selectedDispatchStates = value;
    _selectedDispatchStateID = value!.id;
    _selectedDispatchStateName = value.name!;
    notifyListeners();
  }

  set selectedDispatchStateID(String? value) {
    _selectedDispatchStateID = value;
    notifyListeners();
  }

  set selectedDispatchStateName(String? value) {
    _selectedDispatchStateName = value;
    notifyListeners();
  }

  set selectedDispatchDistricts(Districts? value) {
    _selectedDispatchDistricts = value;
    _selectedDispatchDistrictID = value!.id;
    _selectedDispatchDistrictValue = value.district;
    // districtError = null;
    notifyListeners();
  }

  set selectedDispatchSubLocations(SubLocations? value) {
    _selectedDispatchSubLocations = value;
    _selectedDispatchSubLocID = value!.id;
    _selectedDispatchSubLocValue = value.subLocality!;
    // localityError = null;
    notifyListeners();
  }

  set selectedDispatchDistrictId(value) {
    _selectedDispatchDistrictID = value;
    notifyListeners();
  }

  set selectedDispatchDistrictValue(value) {
    _selectedDispatchDistrictValue = value;
    notifyListeners();
  }

  set selectedDispatchSubLocID(value) {
    _selectedDispatchSubLocID = value;
    notifyListeners();
  }

  set selectedDispatchSubLocValue(value) {
    _selectedDispatchSubLocValue = value;
    notifyListeners();
  }

  set submitClicked(bool value) {
    _submitClicked = value;
    notifyListeners();
  }

  set selectedUnloadingScope(String? value) {
    _selectedUnloadingScope = value;
    notifyListeners();
  }

  set selectedFreightScope(String? value) {
    _selectedFreightScope = value;
    notifyListeners();
  }

  set selectedErectionScope(String? value) {
    _selectedErectionScope = value;
    notifyListeners();
  }

  Future<void> ordersEditOrderAPIViewFunction(context, orderID) async {
    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.ordersDetailsEditOrderViewAPI(
        provider.empId,
        provider.session,
        orderID,
      );
      if (data != null) {
        if (data.error == "0") {
          _dispatchStates = data.states!;
          _orderDetails = data.orderDetails!;
          _erectionScope = ["Included", "Excluded"];
          _unloadingScope = ["Included", "Excluded"];
          _freightScope = ["Included", "Excluded"];
          if (data.orderDetails!.dispatchStateId != null) {
            getDispatchDistrictAPI(
              context,
              data.orderDetails!.dispatchStateId!,
            );
          }
          if (data.orderDetails!.dispatchDistrictId != null) {
            getDispatchSubLocationAPI(
              context,
              data.orderDetails!.dispatchDistrictId!,
            );
          }

          _selectedDispatchStates = data.states!.firstWhere(
            (e) => e.id == data.orderDetails!.dispatchStateId!,
          );
          _selectedDispatchStateID = data.orderDetails!.dispatchStateId!;
          _selectedDispatchStateName =
              data.states!
                  .firstWhere(
                    (e) => e.id == data.orderDetails!.dispatchStateId!,
                  )
                  .name;
          _selectedDispatchDistrictID = data.orderDetails!.dispatchDistrictId!;
          _selectedDispatchSubLocID = data.orderDetails!.dispatchSubLocationId!;
          dispatchAddressController.text = data.orderDetails!.dispatchAddress!;
          dispatchPincodeController.text = data.orderDetails!.dispatchPincode!;
          noteController.text = data.orderDetails!.note!;
          _selectedUnloadingScope = data.orderDetails!.unloadingScope!;
          _selectedErectionScope = data.orderDetails!.erectionScope!;
          _selectedFreightScope = data.orderDetails!.freightScope!;

          notifyListeners();
        } else {}
      } else {}
    } catch (e) {}
  }

  Future<void> getDispatchDistrictAPI(context, stateID) async {
    try {
      var homeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      _dispatchDistricts.clear();
      notifyListeners();
      final data = await ApiCalling.commonAddAccountViewDistrictAPI(
        homeProv.empId,
        homeProv.session,
        stateID,
      );
      if (data != null) {
        if (data.error == "0") {
          _dispatchDistricts = data.districts!;
          _selectedDispatchDistricts = data.districts!.firstWhere(
            (e) => e.id == orderDetails.dispatchDistrictId!,
          );
          _selectedDispatchDistrictValue =
              data.districts!
                  .firstWhere((e) => e.id == orderDetails.dispatchDistrictId!)
                  .district;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> getDispatchSubLocationAPI(context, districtID) async {
    try {
      var homeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      _dispatchSubLocations.clear();
      notifyListeners();
      final data = await ApiCalling.commonAddAccountViewSubLocationAPI(
        homeProv.empId,
        homeProv.session,
        districtID,
      );
      if (data != null) {
        if (data.error == "0") {
          _dispatchSubLocations = data.subLocations!;
          _selectedDispatchSubLocations = data.subLocations!.firstWhere(
            (e) => e.id == orderDetails.dispatchSubLocationId!,
          );
          _selectedDispatchSubLocValue =
              data.subLocations!
                  .firstWhere(
                    (e) => e.id == orderDetails.dispatchSubLocationId!,
                  )
                  .subLocality;

          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> ordersEditOrderAPISubmitFunction(
    context,
    orderID,
    stateID,
    districtID,
    subLocID,
    unloading,
    freight,
    erection,
  ) async {
    try {
      _submitClicked = true;
      notifyListeners();
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.ordersDetailsEditOrderSubmitAPI(
        provider.empId,
        provider.session,
        orderID,
        _image,
        stateID,
        districtID,
        subLocID,
        dispatchPincodeController.text,
        dispatchAddressController.text,
        unloading,
        freight,
        erection,
        noteController.text,
      );
      if (data != null) {
        if (data.error == "0") {
          _submitClicked = false;
          Navigator.pop(context, true);
          toast(context, data.message);
          notifyListeners();
        } else {
          _submitClicked = false;
          notifyListeners();
        }
      } else {
        _submitClicked = false;
        notifyListeners();
      }
    } catch (e) {
      _submitClicked = false;
      notifyListeners();
    }
  }

  imgFromCamera(context) async {
    // Capture a photo
    try {
      final XFile? galleryImage = await _picker.pickImage(
        source: ImageSource.camera,
        imageQuality: 50,
      );
      debugPrint("added");

      _image = File(galleryImage!.path);
      _imageName = File(galleryImage.name);
      _imagePicked = 1;
      FileError = null;
      notifyListeners();
    } catch (e) {
      debugPrint("mmmm: ${e.toString()}");
    }
  }

  imgFromGallery(context) async {
    // Pick an image
    try {
      final XFile? galleryImage = await _picker.pickImage(
        source: ImageSource.gallery,
      );
      final bytes = (await galleryImage?.readAsBytes())?.lengthInBytes;
      final kb = bytes! / 1024;
      final mb = kb / 1024;

      debugPrint("Jenny: bytes:$bytes, kb:$kb, mb: $mb");

      _image = File(galleryImage!.path);
      _imageName = File(galleryImage.name);
      _imagePicked = 1;
      FileError = null;
      notifyListeners();
      // var file = FlutterImageCompress.compressWithFile(galleryImage!.path);
    } catch (e) {
      debugPrint("mmmm: ${e.toString()}");
    }
  }

  void onChangedDispatchAddress(value) {
    dispatchAddressError = "";
    notifyListeners();
  }

  void onChangedDispatchPincode(value) {
    dispatchPincodeError = "";
    notifyListeners();
  }

  void onChangedNote(value) {
    noteError = "";
    notifyListeners();
  }

  void resetForm() {
    dispatchPincodeController.clear();
    dispatchAddressController.clear();
    noteController.clear();
    _selectedUnloadingScope = null;
    _selectedFreightScope = null;
    _selectedErectionScope = null;

    _selectedDispatchStates = null;
    _selectedDispatchStateID = null;
    _selectedDispatchStateName = null;
    _selectedDispatchDistricts = null;
    _selectedDispatchDistrictID = null;
    _selectedDispatchDistrictValue = null;
    _selectedDispatchSubLocations = null;
    _selectedDispatchSubLocID = null;
    _selectedDispatchSubLocValue = null;

    if (!_dispatchStates.contains(_selectedDispatchStates) &&
        _selectedDispatchStates != null) {
      _selectedDispatchStateID = null;
      _selectedDispatchStateName = null;
    }
    if (!_dispatchDistricts.contains(_selectedDispatchDistricts) &&
        _selectedDispatchDistricts != null) {
      _selectedDispatchDistrictID = null;
      _selectedDispatchDistrictValue = null;
    }
    if (!_dispatchSubLocations.contains(_selectedDispatchSubLocations) &&
        _selectedDispatchSubLocations != null) {
      _selectedDispatchSubLocID = null;
      _selectedDispatchSubLocValue = null;
    }
    if (!_unloadingScope.contains(_selectedUnloadingScope) &&
        _selectedUnloadingScope != null) {
      _selectedUnloadingScope = null;
    }
    if (!_freightScope.contains(_selectedFreightScope) &&
        _selectedFreightScope != null) {
      _selectedFreightScope = null;
    }
    if (!_erectionScope.contains(_selectedErectionScope) &&
        _selectedErectionScope != null) {
      _selectedErectionScope = null;
    }
    notifyListeners();
  }
}
