import 'package:flutter/foundation.dart';
import 'package:generp/Models/financeModels/financeDashboardPagesResponse.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

class Dashboardprovider extends ChangeNotifier {
  List<PagesAccessible> _accessiblePagesList = [];
  List<PagesAccessible> _accessiblePagesList2 = [];

  List<PagesAccessible> get accessiblePagesList => _accessiblePagesList;
  List<PagesAccessible> get accessiblePagesList2 => _accessiblePagesList2;

  Future<void> DashboardPagesAPIFunction(context) async {
    try {
      var provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.financeDashboardPagesAPI(
        provider.empId,
        provider.session,
      );
      if (data != null) {
        if (data.error == "0") {
          _accessiblePagesList = data.pagesAccessible!;
          notifyListeners();
        } else {}
      }
    } catch (e) {}
  }

  Future<void> addFormfinanceFormAccessPagesAPIFunction(context) async {
    try {
      var provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.addFormfinanceFormAccessPagesAPI(
        provider.empId,
        provider.session,
      );
      if (data != null) {
        if (data.error == "0") {
          _accessiblePagesList2 = data.pagesAccessible!;
          notifyListeners();
        } else {}
      }
    } catch (e) {}
  }
}
