class addPaymentRequestionResponse {
  String? error;
  String? message;
  List<Accounts>? accounts;
  List<PaymentModes>? paymentModes;
  List<String>? requestingPurposes;
  List<Employees>? employees;

  addPaymentRequestionResponse({
    this.error,
    this.message,
    this.accounts,
    this.paymentModes,
    this.requestingPurposes,
    this.employees,
  });

  addPaymentRequestionResponse.fromJson(Map<String, dynamic> json) {
    if (json['accounts'] != null) {
      accounts = <Accounts>[];
      json['accounts'].forEach((v) {
        accounts!.add(Accounts.fromJson(v));
      });
    }
    if (json['payment_modes'] != null) {
      paymentModes = <PaymentModes>[];
      json['payment_modes'].forEach((v) {
        paymentModes!.add(PaymentModes.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    if (json['requesting_purposes'] != null) {
      requestingPurposes = json['requesting_purposes'].cast<String>();
    }
    if (json['employees'] != null) {
      employees = <Employees>[];
      json['employees'].forEach((v) {
        employees!.add(Employees.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};

    if (accounts != null) {
      data['accounts'] = accounts!.map((v) => v.toJson()).toList();
    }
    if (paymentModes != null) {
      data['payment_modes'] = paymentModes!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['requesting_purposes'] = requestingPurposes;
    if (employees != null) {
      data['employees'] = employees!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Accounts {
  String? id;
  String? name;

  Accounts({this.id, this.name});

  Accounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class PaymentModes {
  String? id;
  String? name;

  PaymentModes({this.id, this.name});

  PaymentModes.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class Employees {
  String? id;
  String? name;

  Employees({this.id, this.name});

  Employees.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
