import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/VisitDetailsProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Utils/commonServices.dart';
import '../finance/FileViewer.dart';
import 'Followupdetails.dart';
import 'PaymentDetails.dart';
import 'UpdateComplaints.dart';

class Visitdetails extends StatefulWidget {
  final complaintID;
  final from;

  const Visitdetails({super.key, required this.complaintID, this.from});

  @override
  State<Visitdetails> createState() => _VisitdetailsState();
}

class _VisitdetailsState extends State<Visitdetails> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var visitdetails = Provider.of<Visitdetailsprovider>(
        context,
        listen: false,
      );
      visitdetails.showMoreDetails = false;
      visitdetails.LoadVisitDetailsAPI(context, widget.complaintID);
      visitdetails.LoadFollowupListAPI(context, widget.complaintID);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    _connectivity.disposeStream();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold1(context),
              ),
            )
            : _scaffold1(context)
        : NoNetwork(context);
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Visitdetailsprovider>(
      builder: (context, provider, child) {
        var customerDetails = provider.customerDetails;
        var generatorDetails = provider.generatorDetails;
        var complaintDetails = provider.complaintDetailsNew;
        var followups = provider.followUpList;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbarNew(context, "Visit Details", 0xFFFFFFFF),
              backgroundColor: AppColors.scaffold_bg_color,
              body: SizedBox(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Card(
                        margin: EdgeInsets.symmetric(
                          horizontal: 0,
                          vertical: 2,
                        ),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.only(
                            bottomLeft: Radius.circular(30),
                            bottomRight: Radius.circular(30),
                          ),
                        ),
                        elevation: 0,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 15,
                                vertical: 5,
                              ),

                              child: Column(
                                children: [
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                      vertical: 3,
                                      horizontal: 0,
                                    ),
                                    child: Row(
                                      children: [
                                        SvgPicture.asset(
                                          "assets/svg/crm/lead_details_ic.svg",
                                        ),
                                        SizedBox(width: 10),

                                        Expanded(
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                "${customerDetails.cname}",
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontFamily: "JakartaMedium",
                                                  fontSize: 14,
                                                ),
                                              ),
                                              Text(
                                                "${customerDetails.aname}",
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: Color(0xFF818181),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Visibility(
                              visible: provider.showMoreDetails ? true : false,
                              child: Container(
                                padding: EdgeInsets.symmetric(
                                  vertical: 10,
                                  horizontal: 10,
                                ),
                                margin: EdgeInsets.symmetric(
                                  vertical: 0,
                                  horizontal: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: AppColors.white,
                                  borderRadius: BorderRadius.circular(16),
                                ),
                                child: Column(
                                  children: [
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Customer Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),

                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: List.generate(3, (j) {
                                        final textheads = [
                                          "Mobile Number",
                                          "Contact Person Number",
                                          "Mail ID",
                                        ];
                                        final textSubheads = [
                                          customerDetails.mob1 ?? "-",
                                          customerDetails.mob2 ?? "-",
                                          customerDetails.mail ?? "-",
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 6,
                                            horizontal: 0,
                                          ),
                                          child: Row(
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: SizedBox(
                                                  child: Text(
                                                    textheads[j].toString(),
                                                    maxLines: 2,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 5),

                                              Expanded(
                                                flex: 2,
                                                child: InkResponse(
                                                  onTap:
                                                      textheads[j] !=
                                                              "Mobile Number"
                                                          ? null
                                                          : () async {
                                                            final Uri
                                                            phoneUri = Uri(
                                                              scheme: 'tel',
                                                              path:
                                                                  customerDetails
                                                                              .mob1 ==
                                                                          ""
                                                                      ? customerDetails
                                                                          .mob2
                                                                      : provider
                                                                          .customerDetails
                                                                          .mob1,
                                                            );

                                                            if (await canLaunchUrl(
                                                              phoneUri,
                                                            )) {
                                                              await launchUrl(
                                                                phoneUri,
                                                              );
                                                            } else {
                                                              throw 'Could not launch $phoneUri';
                                                            }
                                                          },
                                                  child: SizedBox(
                                                    child: Text(
                                                      textSubheads[j] == ""
                                                          ? "-"
                                                          : textSubheads[j],
                                                      maxLines: 2,
                                                      overflow:
                                                          TextOverflow.ellipsis,
                                                      textAlign:
                                                          TextAlign.right,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        fontFamily:
                                                            "JakartaRegular",
                                                        color:
                                                            textheads[j] ==
                                                                    "Mobile Number"
                                                                ? AppColors
                                                                    .app_blue
                                                                : Color(
                                                                  0xFF818181,
                                                                ),
                                                        decorationColor:
                                                            textheads[j] ==
                                                                    "Mobile Number"
                                                                ? AppColors
                                                                    .app_blue
                                                                : null,
                                                        decoration:
                                                            textheads[j] ==
                                                                    "Mobile Number"
                                                                ? TextDecoration
                                                                    .underline
                                                                : null,
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                    ),

                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 3,
                                            child: Text(
                                              "Generator Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: List.generate(6, (j) {
                                        final textheads = [
                                          "Gen ID",
                                          "Engine Number",
                                          "Address",
                                          "Product Name",
                                          "Engine Model",
                                          "Date Of Supply",
                                        ];
                                        final textSubheads = [
                                          "${generatorDetails.genHashId}",
                                          "${generatorDetails.engineNo}",
                                          "${generatorDetails.address}",
                                          "${generatorDetails.spname}",
                                          "${generatorDetails.engineModel}",
                                          "${complaintDetails.dateOfSupply}",
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 6,
                                            horizontal: 0,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Text(
                                                  textheads[j].toString(),
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    fontFamily:
                                                        "JakartaRegular",
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 5),
                                              Expanded(
                                                flex: 2,
                                                child: SizedBox(
                                                  child: Text(
                                                    textSubheads[j] == ""
                                                        ? "-"
                                                        : textSubheads[j],
                                                    maxLines: 2,
                                                    textAlign: TextAlign.right,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.grey_semi,
                                                      fontFamily:
                                                          "JakartaRegular",
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                    ),

                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 4,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 4,
                                            child: Text(
                                              "Complaint Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: List.generate(4, (j) {
                                        final textheads = [
                                          "Complaint ID",
                                          "Complaint Description",
                                          "Opened Date",
                                          "Complaint Type",
                                        ];
                                        final textSubheads = [
                                          "${complaintDetails.complaintId}",
                                          "${complaintDetails.complaintDesc}",
                                          "${complaintDetails.openedDate}",
                                          "${complaintDetails.complaintType}",
                                        ];
                                        return Container(
                                          padding: EdgeInsets.symmetric(
                                            vertical: 6,
                                            horizontal: 0,
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                flex: 1,
                                                child: Text(
                                                  textheads[j].toString(),
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    fontFamily:
                                                        "JakartaRegular",
                                                  ),
                                                ),
                                              ),
                                              SizedBox(width: 5),
                                              Expanded(
                                                flex: 2,
                                                child: SizedBox(
                                                  child: Text(
                                                    textSubheads[j] == ""
                                                        ? "-"
                                                        : textSubheads[j],
                                                    maxLines: 2,
                                                    textAlign: TextAlign.right,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.grey_semi,
                                                      fontFamily:
                                                          "JakartaRegular",
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      }),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            InkResponse(
                              onTap: () async {
                                provider.showMoreDetails =
                                    !provider.showMoreDetails;
                              },
                              child: Container(
                                padding: EdgeInsets.symmetric(vertical: 5),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Text(
                                      provider.showMoreDetails
                                          ? "Hide Details"
                                          : "View Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                    Transform.flip(
                                      flipY:
                                          provider.showMoreDetails
                                              ? true
                                              : false,
                                      child: SvgPicture.asset(
                                        "assets/svg/arrow_dropdown.svg",
                                        height: 25,
                                        width: 20,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),

                      if (followups.isNotEmpty) ...[
                        Container(
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 5,
                          ),
                          child: Text(
                            "Followup Details",
                            style: TextStyle(
                              color: Color(0xFF818181),
                              fontFamily: "JakartaMedium",
                            ),
                          ),
                        ),

                        SizedBox(
                          width: double.infinity,
                          height: 350,
                          child: ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            shrinkWrap: true,
                            scrollDirection: Axis.horizontal,
                            padding: EdgeInsets.symmetric(
                              vertical: 10,
                              horizontal: 10,
                            ),
                            itemCount: provider.followUpList.length,
                            itemBuilder: (context, lp) {
                              return Container(
                                height: 350,
                                width: MediaQuery.of(context).size.width * 0.9,
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(14),
                                ),
                                padding: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 10,
                                ),
                                margin: EdgeInsets.symmetric(horizontal: 5),

                                child: Column(
                                  children: [
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          flex: 1,
                                          child: SvgPicture.asset(
                                            "assets/svg/crm/followup_details_ic.svg",
                                          ),
                                        ),
                                        SizedBox(width: 10),
                                        Expanded(
                                          flex: 8,
                                          child: SizedBox(
                                            child: Column(
                                              // mainAxisAlignment: MainAxisAlignment.start,
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              mainAxisAlignment:
                                                  MainAxisAlignment.start,
                                              children: [
                                                Row(
                                                  children: [
                                                    Expanded(
                                                      flex: 4,
                                                      child: Column(
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            provider
                                                                    .followUpList[lp]
                                                                    .ename ??
                                                                "-",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .semi_black,
                                                            ),
                                                          ),
                                                          Text(
                                                            provider
                                                                    .followUpList[lp]
                                                                    .date ??
                                                                "-",
                                                            style: TextStyle(
                                                              fontFamily:
                                                                  "JakartaMedium",
                                                              fontSize: 14,
                                                              color:
                                                                  AppColors
                                                                      .grey_semi,
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                    // Expanded(
                                                    //   flex: 3,
                                                    //   child: Container(
                                                    //     decoration: BoxDecoration(
                                                    //       borderRadius:
                                                    //       BorderRadius.circular(
                                                    //         8,
                                                    //       ),
                                                    //       color: Color(
                                                    //         0xFFF3FFD5,
                                                    //       ),
                                                    //     ),
                                                    //     padding:
                                                    //     EdgeInsets.symmetric(
                                                    //       horizontal: 5,
                                                    //       vertical: 10,
                                                    //     ),
                                                    //     child: Text(
                                                    //       "${provider.followUpList[lp].status ?? "-"}",
                                                    //       textAlign:
                                                    //       TextAlign.center,
                                                    //       style: TextStyle(
                                                    //         fontFamily:
                                                    //         "JakartaMedium",
                                                    //         fontSize: 14,
                                                    //         color: Color(
                                                    //           0xFF586000,
                                                    //         ),
                                                    //       ),
                                                    //     ),
                                                    //   ),
                                                    // ),
                                                  ],
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    // Container(
                                    //   padding: EdgeInsets.symmetric(
                                    //     vertical: 7.5,
                                    //   ),
                                    //   child: Row(
                                    //     children: [
                                    //       Expanded(
                                    //         flex: 4,
                                    //         child: Text(
                                    //           "Visit Type",
                                    //           style: TextStyle(
                                    //             fontSize: 14,
                                    //             fontFamily: "JakartaSemiBold",
                                    //           ),
                                    //         ),
                                    //       ),
                                    //       Expanded(
                                    //         flex: 6,
                                    //         child: DottedLine(
                                    //           dashGapLength: 4,
                                    //           dashGapColor: Colors.white,
                                    //           dashColor: AppColors.grey_semi,
                                    //           dashLength: 2,
                                    //           lineThickness: 0.5,
                                    //         ),
                                    //       ),
                                    //     ],
                                    //   ),
                                    // ),
                                    // ...List.generate(1, (j) {
                                    //   final heads = [
                                    //     "Type",
                                    //   ];
                                    //   final subHeads = [
                                    //     followups[lp].type??"-",
                                    //   ];
                                    //   return Container(
                                    //     padding: EdgeInsets.symmetric(
                                    //       vertical: 3,
                                    //     ),
                                    //     child: Row(
                                    //       crossAxisAlignment:
                                    //       CrossAxisAlignment.start,
                                    //       children: [
                                    //         Expanded(
                                    //           child: Text(
                                    //             textAlign: TextAlign.left,
                                    //             heads[j],
                                    //             style: TextStyle(
                                    //               fontFamily: "JakartaRegular",
                                    //               fontSize: 14,
                                    //               color: AppColors.semi_black,
                                    //             ),
                                    //           ),
                                    //         ),
                                    //         Expanded(
                                    //           child: Text(
                                    //             textAlign: TextAlign.right,
                                    //             maxLines: 1,
                                    //             overflow: TextOverflow.ellipsis,
                                    //             subHeads[j] == ""
                                    //                 ? "-"
                                    //                 : subHeads[j],
                                    //             style: TextStyle(
                                    //               fontSize: 14,
                                    //               color: AppColors.grey_semi,
                                    //             ),
                                    //           ),
                                    //         ),
                                    //       ],
                                    //     ),
                                    //   );
                                    // }),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7.5,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 4,
                                            child: Text(
                                              "Visit Time",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(3, (j) {
                                      final heads = [
                                        "In Time",
                                        "Out Time",
                                        "Running Hours",
                                      ];
                                      final subHeads = [
                                        followups[lp].time ?? "-",
                                        followups[lp].outTime ?? "-",
                                        followups[lp].runningHrs ?? "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                heads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.right,
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                subHeads[j] == ""
                                                    ? "-"
                                                    : subHeads[j],
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  color: AppColors.grey_semi,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                        vertical: 7,
                                      ),
                                      child: Row(
                                        children: [
                                          Expanded(
                                            flex: 4,
                                            child: Text(
                                              "FSR Details",
                                              style: TextStyle(
                                                fontSize: 14,
                                                fontFamily: "JakartaSemiBold",
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 6,
                                            child: DottedLine(
                                              dashGapLength: 4,
                                              dashGapColor: Colors.white,
                                              dashColor: AppColors.grey_semi,
                                              dashLength: 2,
                                              lineThickness: 0.5,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    ...List.generate(3, (j) {
                                      final heads = [
                                        "FSR File",
                                        "FSR Number",
                                        "Feedback",
                                      ];
                                      final subHeads = [
                                        followups[lp].fsrExt ?? "-",
                                        followups[lp].fsrNo ?? "-",
                                        followups[lp].feedback ?? "-",
                                      ];
                                      return Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 3,
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                textAlign: TextAlign.left,
                                                heads[j],
                                                style: TextStyle(
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                  color: AppColors.semi_black,
                                                ),
                                              ),
                                            ),
                                            if (heads[j] == "FSR File") ...[
                                              Expanded(
                                                child: InkResponse(
                                                  onTap: () {
                                                    if (heads[j] ==
                                                        "FSR File") {
                                                      Navigator.push(
                                                        context,
                                                        MaterialPageRoute(
                                                          builder:
                                                              (
                                                                context,
                                                              ) => Fileviewer(
                                                                fileName:
                                                                    followups[lp]
                                                                        .fsrExt!,
                                                                fileUrl:
                                                                    "https://erp.gengroup.in/files_genservices/tech_fsr_report/${followups[lp].fsrExt!}",
                                                              ),
                                                        ),
                                                      );
                                                    }
                                                  },
                                                  child: Text(
                                                    subHeads[j],
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    textAlign: TextAlign.right,
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color: AppColors.app_blue,
                                                      decorationColor:
                                                          AppColors.app_blue,
                                                      decoration:
                                                          TextDecoration
                                                              .underline,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ] else ...[
                                              Expanded(
                                                child: Text(
                                                  maxLines: 2,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                  textAlign: TextAlign.right,
                                                  subHeads[j] == ""
                                                      ? "-"
                                                      : subHeads[j],

                                                  style: TextStyle(
                                                    fontSize: 14,
                                                    color: AppColors.grey_semi,
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ],
                                        ),
                                      );
                                    }),
                                  ],
                                ),
                              );
                            },
                          ),
                        ),
                      ],
                      SizedBox(height: 75),
                    ],
                  ),
                ),
              ),
              bottomNavigationBar: Container(
                padding: EdgeInsets.symmetric(horizontal: 5),
                decoration: BoxDecoration(
                  color: AppColors.white,
                  borderRadius: BorderRadius.circular(14.0),
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Expanded(
                      child: InkWell(
                        onTap: () {
                          Navigator.push(
                            context,
                            MaterialPageRoute(
                              builder:
                                  (context) => Paymentdetails(
                                    accountName: "Generator",
                                    name: provider.customerDetails.cname,
                                    genId: provider.generatorDetails.id,
                                    referenceID:
                                        provider
                                            .complaintDetailsNew
                                            .complaintId,
                                  ),
                            ),
                          );
                        },
                        child: Container(
                          alignment: Alignment.center,
                          height: 65,
                          // margin: EdgeInsets.symmetric(horizontal: 10),
                          decoration: BoxDecoration(
                            color: AppColors.white,
                            borderRadius: BorderRadius.circular(14.0),
                          ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              SvgPicture.asset(
                                "assets/svg/se_payment_details.svg",
                              ),
                              SizedBox(width: 5),
                              if (widget.from == "Pending Complaints") ...[
                                Expanded(
                                  child: Text(
                                    "Payment Details",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      color: AppColors.semi_black,
                                      fontFamily: "JakartaMedium",
                                      fontSize: 12,
                                    ),
                                  ),
                                ),
                              ] else ...[
                                Text(
                                  "Payment Details",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.semi_black,
                                    fontFamily: "JakartaMedium",
                                    fontSize: 12,
                                  ),
                                ),
                              ],
                            ],
                          ),
                        ),
                      ),
                    ),
                    if (widget.from == "Pending Complaints") ...[
                      SvgPicture.asset("assets/svg/crm/vertical_line_ic.svg"),
                      Expanded(
                        child: InkWell(
                          onTap: () async {
                            var loc =
                                provider.generatorDetails.loc
                                    ?.split(",")
                                    .toString();
                            var uri = Uri.parse(
                              "google.navigation:q=${loc![0]},${loc[1]}&mode=d",
                            );
                            if (await canLaunch(uri.toString())) {
                              await launch(uri.toString());
                            } else {
                              throw 'Could not launch ${uri.toString()}';
                            }
                          },
                          child: Container(
                            alignment: Alignment.center,
                            height: 65,

                            // margin: EdgeInsets.symmetric(horizontal: 10),
                            decoration: BoxDecoration(
                              color: AppColors.white,
                              borderRadius: BorderRadius.circular(14.0),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                SvgPicture.asset(
                                  "assets/svg/se_locate_customer.svg",
                                ),
                                SizedBox(width: 5),
                                Text(
                                  "Location",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: AppColors.semi_black,
                                    fontFamily: "JakartaMedium",
                                    fontSize: 12,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                      SvgPicture.asset("assets/svg/crm/vertical_line_ic.svg"),
                      Expanded(
                        child: InkWell(
                          onTap: () async {
                            Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) => Updatecomplaints(
                                      ComplaintID:
                                          provider
                                              .complaintDetailsNew
                                              .complaintId,
                                    ),
                              ),
                            );
                          },
                          child: Container(
                            alignment: Alignment.center,
                            height: 65,
                            // margin: EdgeInsets.symmetric(horizontal: 10),
                            decoration: BoxDecoration(
                              color: AppColors.white,
                              borderRadius: BorderRadius.circular(14.0),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                SvgPicture.asset(
                                  "assets/svg/se_update_complaint.svg",
                                ),
                                SizedBox(width: 5),
                                Expanded(
                                  child: Text(
                                    "Update Complaint",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(
                                      color: AppColors.semi_black,
                                      fontFamily: "JakartaMedium",
                                      fontSize: 12,
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ],
                  ],
                ),
              ),
              // floatingActionButton: Align(
              //   alignment: Alignment.bottomCenter,
              //   child: InkWell(
              //     onTap: () {
              //       Navigator.push(
              //         context,
              //         MaterialPageRoute(
              //           builder:
              //               (context) =>
              //                   Followupdetails(complaintID: widget.complaintID),
              //         ),
              //       );
              //     },
              //     child: Container(
              //       alignment: Alignment.bottomCenter,
              //       height: 45,
              //       width: MediaQuery.of(context).size.width,
              //       margin: EdgeInsets.symmetric(horizontal: 10),
              //       decoration: BoxDecoration(
              //         color: AppColors.app_blue,
              //         borderRadius: BorderRadius.circular(14.0),
              //       ),
              //       child: Center(
              //         child: Text(
              //           "Followup Details",
              //           textAlign: TextAlign.center,
              //           style: TextStyle(
              //             color: Colors.white,
              //             fontFamily: "JakartaMedium",
              //           ),
              //         ),
              //       ),
              //     ),
              //   ),
              // ),
              // floatingActionButtonLocation:
              //     FloatingActionButtonLocation.centerFloat,
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Visitdetailsprovider>(
      builder: (context, provider, child) {
        var customerDetails = provider.customerDetails;
        var generatorDetails = provider.generatorDetails;
        var complaintDetails = provider.complaintDetailsNew;
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Visit Details"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: SizedBox(
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 8),
                        child: Text(
                          "Customer Details",
                          style: TextStyle(
                            fontSize: 14,
                            color: AppColors.grey_thick,
                          ),
                        ),
                      ),
                      Container(
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 15,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: List.generate(4, (j) {
                            final textheads = [
                              "${customerDetails.cname}",
                              "Mobile Number",
                              "Contact Person Number",
                              "Mail ID",
                            ];
                            final textSubheads = [
                              customerDetails.aname ?? "-",
                              customerDetails.mob1 ?? "-",
                              customerDetails.mob2 ?? "-",
                              customerDetails.mail ?? "-",
                            ];
                            return Container(
                              padding: EdgeInsets.symmetric(
                                vertical: 6,
                                horizontal: 0,
                              ),
                              child: Column(
                                children: [
                                  Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      if (j == 0) ...[
                                        SvgPicture.asset(
                                          "assets/svg/se_block_head.svg",
                                        ),
                                        SizedBox(width: 5),
                                        Expanded(
                                          child: SizedBox(
                                            child: Column(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Text(
                                                  "${customerDetails.cname}",
                                                  maxLines: 2,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                ),
                                                SizedBox(
                                                  // height:45,
                                                  width:
                                                      MediaQuery.of(
                                                        context,
                                                      ).size.width *
                                                      0.75,
                                                  child: Text(
                                                    textSubheads[j] == ""
                                                        ? "-"
                                                        : customerDetails
                                                                .aname ??
                                                            "-",
                                                    maxLines: 2,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    style: TextStyle(
                                                      color: Color(0xFF818181),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ] else ...[
                                        Expanded(
                                          child: Text(textheads[j].toString()),
                                        ),
                                        Expanded(
                                          child: SizedBox(
                                            child: Text(
                                              textSubheads[j] == ""
                                                  ? "-"
                                                  : textSubheads[j],
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                              style: TextStyle(
                                                color: Color(0xFF818181),
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ],
                                  ),
                                ],
                              ),
                            );
                          }),
                        ),
                      ),

                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 8),
                        child: Text(
                          "Generator Details",
                          style: TextStyle(
                            fontSize: 14,
                            color: AppColors.grey_thick,
                          ),
                        ),
                      ),
                      Container(
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 15,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          children: [
                            ...List.generate(6, (j) {
                              final textheads = [
                                "Gen ID",
                                "Engine Number",
                                "Address",
                                "Product Name",
                                "Engine Model",
                                "Date Of Supply",
                              ];
                              final textSubheads = [
                                "${generatorDetails.genHashId}",
                                "${generatorDetails.engineNo}",
                                "${generatorDetails.address}",
                                "${generatorDetails.spname}",
                                "${generatorDetails.engineModel}",
                                "${complaintDetails.dateOfSupply}",
                              ];
                              return Container(
                                padding: EdgeInsets.symmetric(
                                  vertical: 6,
                                  horizontal: 0,
                                ),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: Text(textheads[j].toString()),
                                    ),
                                    Expanded(
                                      child: SizedBox(
                                        child: Text(
                                          textSubheads[j] == ""
                                              ? "-"
                                              : textSubheads[j],
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            color: Color(0xFF818181),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                          ],
                        ),
                      ),

                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 8),
                        child: Text(
                          "Complaint Details",
                          style: TextStyle(
                            fontSize: 14,
                            color: AppColors.grey_thick,
                          ),
                        ),
                      ),
                      Container(
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 5,
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 15,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(20),
                        ),
                        child: Column(
                          children: [
                            ...List.generate(4, (j) {
                              final textheads = [
                                "Complaint ID",
                                "Complaint Description",
                                "Opened Date",
                                "Complaint Type",
                              ];
                              final textSubheads = [
                                "${complaintDetails.complaintId}",
                                "${complaintDetails.complaintDesc}",
                                "${complaintDetails.openedDate}",
                                "${complaintDetails.complaintType}",
                              ];
                              return Container(
                                padding: EdgeInsets.symmetric(vertical: 6),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: Text(textheads[j].toString()),
                                    ),
                                    Expanded(
                                      child: SizedBox(
                                        // height:45,
                                        // width:
                                        // MediaQuery.of(
                                        //   context,
                                        // ).size.width *
                                        //     0.8,
                                        child: Text(
                                          textSubheads[j] == ""
                                              ? "-"
                                              : textSubheads[j],
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: TextStyle(
                                            color: Color(0xFF818181),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                          ],
                        ),
                      ),

                      SizedBox(height: 75),
                    ],
                  ),
                ),
              ),
              floatingActionButton: Align(
                alignment: Alignment.bottomCenter,
                child: InkWell(
                  onTap: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder:
                            (context) => Followupdetails(
                              complaintID: widget.complaintID,
                            ),
                      ),
                    );
                  },
                  child: Container(
                    alignment: Alignment.bottomCenter,
                    height: 45,
                    width: MediaQuery.of(context).size.width,
                    margin: EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                      color: AppColors.app_blue,
                      borderRadius: BorderRadius.circular(14.0),
                    ),
                    child: Center(
                      child: Text(
                        "Followup Details",
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          color: Colors.white,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),
                  ),
                ),
              ),
              floatingActionButtonLocation:
                  FloatingActionButtonLocation.centerFloat,
            ),
          ),
        );
      },
    );
  }
}
