import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:qr_code_scanner/qr_code_scanner.dart';

import '../Notifiers/scanLoginProvider.dart';
import '../Utils/app_colors.dart';
import '../Utils/commonServices.dart';
import '../Utils/commonWidgets.dart';

class Scannerlogin extends StatefulWidget {
  const Scannerlogin({super.key});

  @override
  State<Scannerlogin> createState() => _ScannerloginState();
}

class _ScannerloginState extends State<Scannerlogin> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });

    super.initState();
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == 'Online')
        ? Consumer<Scanloginprovider>(
          builder: (context, provider, child) {
            return WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: Platform.isIOS ? false : true,
                child: Scaffold(
                  resizeToAvoidBottomInset: true,
                  backgroundColor: AppColors.scaffold_bg_color,
                  appBar: appbar(context, "QR Login"),
                  body: Container(
                    decoration: BoxDecoration(color: Colors.black),
                    child: Column(
                      children: [
                        Spacer(),
                        SizedBox(
                          height: 250,

                          child: QRView(
                            key: provider.scannerKey,
                            onQRViewCreated: (p0) {
                              provider.onQRViewCreated(p0, context);
                            },
                            formatsAllowed: [BarcodeFormat.qrcode],
                            cameraFacing: CameraFacing.back,

                            overlay: QrScannerOverlayShape(
                              borderColor: AppColors.app_blue,
                              borderRadius: 20,
                              borderLength: 60,
                              borderWidth: 10,
                              cutOutSize: 250.0,
                            ),
                          ),
                        ),
                        SizedBox(height: 25),
                        Text(
                          "Scan QR",
                          textAlign: TextAlign.center,
                          style: TextStyle(fontSize: 18, color: Colors.white),
                        ),
                        Text(
                          "to Login",
                          textAlign: TextAlign.center,
                          style: TextStyle(fontSize: 14, color: Colors.white),
                        ),
                        Spacer(),

                        SizedBox(height: 50),
                      ],
                    ),
                  ),
                ),
              ),
            );
          },
        )
        : NoNetwork(context);
  }
}
