import 'dart:async';
import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';

import '../screens/LoginScreen.dart';
import 'SharedpreferencesService.dart';

toast(context, text) {
  // OwnToast(context, text, "0");
  Fluttertoast.showToast(
    msg: text,
    toastLength: Toast.LENGTH_LONG,
    gravity: ToastGravity.BOTTOM,
    timeInSecForIosWeb: 1,
    backgroundColor: Colors.black45,
    textColor: Colors.white,
    fontSize: 15.0,
  );
}

void sessionDoesNotExist(context) {

  SharedpreferencesService().clearPreferences();
Navigator.push(
  context,
  MaterialPageRoute(
    builder: (context) => LoginScreen(),
    settings: RouteSettings(name: 'LoginScreen'),
  ),
);

}


String connection = "Online";
class MyConnectivity {

  MyConnectivity._();

  static final _instance = MyConnectivity._();
  static MyConnectivity get instance => _instance;
  final _connectivity = Connectivity();
  final _controller = StreamController.broadcast();
  Stream get myStream => _controller.stream;

  void initialise() async {
    List<ConnectivityResult> result =
        (await _connectivity.checkConnectivity());
    _checkStatus(result.first);
    _connectivity.onConnectivityChanged.listen((result) {
      _checkStatus(result.first);
    });
  }

  void _checkStatus(ConnectivityResult result) async {
    bool isOnline = false;
    try {
      final result = await InternetAddress.lookup('example.com');
      isOnline = result.isNotEmpty && result[0].rawAddress.isNotEmpty;
    } on SocketException catch (_) {
      isOnline = false;
    }
    _controller.sink.add({result: isOnline});
  }

  void disposeStream() => _controller.close();
}
